/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.farm_and_charm.core.block.entity;

import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.Containers;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.satisfy.farm_and_charm.core.block.SiloBlock;
import net.satisfy.farm_and_charm.core.recipe.SiloRecipe;
import net.satisfy.farm_and_charm.core.registry.EntityTypeRegistry;
import net.satisfy.farm_and_charm.core.util.ConnectivityHandler;
import net.satisfy.farm_and_charm.core.util.GeneralUtil;
import net.satisfy.farm_and_charm.core.util.IMultiBlockEntityContainer;
import net.satisfy.farm_and_charm.core.world.ImplementedInventory;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SiloBlockEntity
extends BlockEntity
implements IMultiBlockEntityContainer.Inventory,
ImplementedInventory,
MenuProvider,
BlockEntityTicker<SiloBlockEntity> {
    private static final int MAX_WIDTH = 3;
    private static final int MAX_HEIGHT = 9;
    public static final int MAX_CAPACITY = 81;
    private static final int DRY_TIME = 200;
    protected BlockPos controller;
    protected boolean updateConnectivity = false;
    protected int width = 1;
    protected int height = 1;
    private NonNullList<ItemStack> items = NonNullList.withSize((int)162, (Object)ItemStack.EMPTY);
    private int[] times = new int[81];

    public SiloBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)EntityTypeRegistry.SILO_BLOCK_ENTITY.get(), pos, state);
    }

    public static void dropStack(Level level, double x, double y, double z, ItemStack itemStack, Direction direction) {
        double g = EntityType.ITEM.getWidth();
        double h = 1.0 - g;
        double i = g / 2.0;
        double j = Math.floor(x) + level.random.nextDouble() * h + i;
        double k = Math.floor(y) + level.random.nextDouble() * h;
        double l = Math.floor(z) + level.random.nextDouble() * h + i;
        while (!itemStack.isEmpty()) {
            ItemEntity itemEntity = new ItemEntity(level, j, k, l, itemStack.split(level.random.nextInt(21) + 10));
            itemEntity.setDeltaMovement(level.random.triangle((double)direction.getStepX() * 0.4, 0.11485000171139836), level.random.triangle(-0.2, 0.11485000171139836), level.random.triangle((double)direction.getStepZ() * 0.4, 0.11485000171139836));
            level.addFreshEntity((Entity)itemEntity);
        }
    }

    @Override
    public void preventConnectivityUpdate() {
        this.updateConnectivity = false;
    }

    @Override
    public boolean isController() {
        return this.controller == null || this.worldPosition.equals((Object)this.controller);
    }

    @Override
    public BlockPos getController() {
        return this.isController() ? this.worldPosition : this.controller;
    }

    @Override
    public void setController(BlockPos controller) {
        assert (this.level != null);
        if (this.level.isClientSide || controller.equals((Object)this.controller)) {
            return;
        }
        this.controller = controller;
        Containers.dropContents((Level)this.level, (BlockPos)this.worldPosition, (Container)this);
    }

    @Override
    public <T extends BlockEntity> T getControllerBE() {
        if (this.isController()) {
            SiloBlockEntity result = this;
            return (T)result;
        }
        assert (this.level != null);
        BlockEntity be = this.level.getBlockEntity(this.controller);
        if (be instanceof IMultiBlockEntityContainer) {
            BlockEntity result = be;
            return (T)result;
        }
        return null;
    }

    @Override
    public void removeController(boolean keepContents) {
        if (this.level == null || this.level.isClientSide) {
            return;
        }
        this.updateConnectivity = true;
        this.controller = null;
        this.width = 1;
        this.height = 1;
        BlockState state = this.getBlockState();
        if (SiloBlock.isSilo(state)) {
            state = (BlockState)state.setValue((Property)SiloBlock.BOTTOM, (Comparable)Boolean.valueOf(true));
            state = (BlockState)state.setValue((Property)SiloBlock.TOP, (Comparable)Boolean.valueOf(true));
            state = (BlockState)state.setValue(SiloBlock.SHAPE, (Comparable)((Object)SiloBlock.Shape.NONE));
            this.level.setBlock(this.worldPosition, state, 23);
        }
    }

    public void tick(Level level, BlockPos blockPos, BlockState blockState, SiloBlockEntity blockEntity) {
        if (this.level == null) {
            this.level = level;
        }
        if (this.updateConnectivity) {
            this.updateConnectivity();
        }
        this.dry();
        this.tryDropFinish(blockState);
    }

    public void updateConnectivity() {
        this.updateConnectivity = false;
        if (this.level == null || this.level.isClientSide) {
            return;
        }
        if (!this.isController()) {
            return;
        }
        ConnectivityHandler.formMulti(this);
    }

    public boolean tryAddItem(ItemStack itemStack) {
        boolean added = false;
        for (int slot = 0; !itemStack.isEmpty() && slot < this.getCapacity(); ++slot) {
            if (!this.getItem(slot).isEmpty()) continue;
            this.setItem(slot, itemStack.split(1));
            added = true;
        }
        return added;
    }

    public ItemStack tryRemoveItem() {
        for (int slot = 81 + this.getCapacity(); slot > 81; --slot) {
            ItemStack stack = this.getItem(slot);
            if (stack.isEmpty()) continue;
            return this.removeItem(slot, stack.getCount());
        }
        return ItemStack.EMPTY;
    }

    @Override
    public void notifyMultiUpdated() {
        if (this.level == null) {
            return;
        }
        BlockState state = this.getBlockState();
        if (SiloBlock.isSilo(state)) {
            state = (BlockState)state.setValue((Property)SiloBlock.BOTTOM, (Comparable)Boolean.valueOf(this.getController().getY() == this.getBlockPos().getY()));
            state = (BlockState)state.setValue((Property)SiloBlock.TOP, (Comparable)Boolean.valueOf(this.getController().getY() + this.height - 1 == this.getBlockPos().getY()));
            BlockState controllerState = this.level.getBlockState(this.getController());
            if (controllerState.hasProperty((Property)BlockStateProperties.OPEN)) {
                state = (BlockState)state.setValue((Property)SiloBlock.OPEN, (Comparable)((Boolean)controllerState.getValue((Property)BlockStateProperties.OPEN)));
            }
            if (controllerState.hasProperty((Property)BlockStateProperties.HORIZONTAL_FACING)) {
                state = (BlockState)state.setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)((Direction)controllerState.getValue((Property)BlockStateProperties.HORIZONTAL_FACING)));
            }
            this.level.setBlock(this.worldPosition, state, 6);
        }
        if (this.isController()) {
            this.updateShape();
        }
    }

    public void updateShape() {
        for (int yOffset = 0; yOffset < this.height; ++yOffset) {
            for (int xOffset = 0; xOffset < this.width; ++xOffset) {
                for (int zOffset = 0; zOffset < this.width; ++zOffset) {
                    BlockPos pos = this.worldPosition.offset(xOffset, yOffset, zOffset);
                    assert (this.level != null);
                    BlockState blockState = this.level.getBlockState(pos);
                    if (!SiloBlock.isSilo(blockState)) continue;
                    SiloBlock.Shape shape = SiloBlock.Shape.NONE;
                    if (this.width == 2) {
                        SiloBlock.Shape shape2 = xOffset == 0 ? (zOffset == 0 ? SiloBlock.Shape.NORTH_WEST : SiloBlock.Shape.SOUTH_WEST) : (shape = zOffset == 0 ? SiloBlock.Shape.NORTH_EAST : SiloBlock.Shape.SOUTH_EAST);
                    }
                    if (this.width == 3) {
                        shape = switch (xOffset) {
                            case 0 -> {
                                if (zOffset == 0) {
                                    yield SiloBlock.Shape.NORTH_WEST;
                                }
                                if (zOffset == 2) {
                                    yield SiloBlock.Shape.SOUTH_WEST;
                                }
                                yield SiloBlock.Shape.WEST;
                            }
                            case 1 -> {
                                if (zOffset == 0) {
                                    yield SiloBlock.Shape.NORTH;
                                }
                                if (zOffset == 2) {
                                    yield SiloBlock.Shape.SOUTH;
                                }
                                yield SiloBlock.Shape.NONE;
                            }
                            case 2 -> {
                                if (zOffset == 0) {
                                    yield SiloBlock.Shape.NORTH_EAST;
                                }
                                if (zOffset == 2) {
                                    yield SiloBlock.Shape.SOUTH_EAST;
                                }
                                yield SiloBlock.Shape.EAST;
                            }
                            default -> SiloBlock.Shape.NONE;
                        };
                    }
                    this.level.setBlockAndUpdate(pos, (BlockState)blockState.setValue(SiloBlock.SHAPE, (Comparable)((Object)shape)));
                }
            }
        }
    }

    private void dry() {
        for (int fresh = 0; fresh < this.getCapacity(); ++fresh) {
            ItemStack freshStack = this.getItem(fresh);
            Optional<RecipeHolder<SiloRecipe>> recipe = SiloBlock.getDryItemRecipe(this.level, freshStack);
            if (!recipe.isPresent() || freshStack.isEmpty()) continue;
            int dryTime = this.times[fresh];
            if (++dryTime >= 200) {
                for (int finish = 81; finish < 81 + this.getCapacity(); ++finish) {
                    if (!this.getItem(finish).isEmpty()) continue;
                    ItemStack finishStack = this.removeItem(fresh, freshStack.getCount());
                    ItemStack outputStack = ((SiloRecipe)recipe.get().value()).getResultItem((HolderLookup.Provider)this.level.registryAccess()).copyWithCount(finishStack.getCount());
                    this.setItem(finish, SiloBlock.isDryItem(this.level, finishStack) ? outputStack : finishStack);
                    dryTime = 0;
                    if (this.level == null || this.level.isClientSide) break;
                    this.level.playSound(null, this.worldPosition, SoundEvents.COMPOSTER_FILL_SUCCESS, SoundSource.BLOCKS, 0.7f, 1.0f);
                    break;
                }
            }
            this.times[fresh] = dryTime;
        }
    }

    private void tryDropFinish(BlockState blockState) {
        if (this.level == null || !((Boolean)blockState.getValue((Property)SiloBlock.OPEN)).booleanValue()) {
            return;
        }
        for (int finish = 81; finish < 81 + this.getCapacity(); ++finish) {
            ItemStack finishStack = this.getItem(finish);
            if (finishStack.isEmpty()) continue;
            Direction direction = (Direction)blockState.getValue((Property)BlockStateProperties.HORIZONTAL_FACING);
            double x = switch (direction) {
                case Direction.EAST -> this.width;
                case Direction.WEST -> 0.0;
                default -> (double)this.width / 2.0;
            };
            double z = switch (direction) {
                case Direction.NORTH -> 0.0;
                case Direction.SOUTH -> this.width;
                default -> (double)this.width / 2.0;
            };
            SiloBlockEntity.dropStack(this.level, (double)this.worldPosition.getX() + x, (double)this.worldPosition.getY() + 0.5, (double)this.worldPosition.getZ() + z, finishStack, direction);
            return;
        }
    }

    public void open(boolean open) {
        if (!this.isController()) {
            return;
        }
        for (int yOffset = 0; yOffset < this.height; ++yOffset) {
            for (int xOffset = 0; xOffset < this.width; ++xOffset) {
                for (int zOffset = 0; zOffset < this.width; ++zOffset) {
                    BlockPos pos = this.worldPosition.offset(xOffset, yOffset, zOffset);
                    assert (this.level != null);
                    BlockState blockState = this.level.getBlockState(pos);
                    if (!SiloBlock.isSilo(blockState)) continue;
                    this.level.setBlockAndUpdate(pos, (BlockState)blockState.setValue((Property)SiloBlock.OPEN, (Comparable)Boolean.valueOf(open)));
                }
            }
        }
    }

    @Override
    public Direction.Axis getMainConnectionAxis() {
        return Direction.Axis.Y;
    }

    @Override
    public int getMaxLength(Direction.Axis longAxis, int width) {
        return longAxis.isHorizontal() ? this.getMaxWidth() : 9;
    }

    @Override
    public int getMaxWidth() {
        return 3;
    }

    @Override
    public int getHeight() {
        return this.height;
    }

    @Override
    public void setHeight(int height) {
        this.height = height;
    }

    @Override
    public int getWidth() {
        return this.width;
    }

    @Override
    public void setWidth(int width) {
        this.width = width;
    }

    public int getCapacity() {
        return !this.isController() ? 0 : this.width * this.width * this.height;
    }

    @Override
    public NonNullList<ItemStack> getItems() {
        return this.items;
    }

    @Override
    public boolean hasInventory() {
        return this.isController();
    }

    protected void saveAdditional(CompoundTag compoundTag, HolderLookup.Provider provider) {
        super.saveAdditional(compoundTag, provider);
        if (this.controller != null) {
            GeneralUtil.putBlockPos(compoundTag, this.controller);
        }
        compoundTag.putBoolean("Update", this.updateConnectivity);
        compoundTag.putInt("Width", this.width);
        compoundTag.putInt("Height", this.height);
        ContainerHelper.saveAllItems((CompoundTag)compoundTag, this.items, (HolderLookup.Provider)provider);
        compoundTag.putIntArray("Times", this.times);
    }

    protected void loadAdditional(CompoundTag compoundTag, HolderLookup.Provider provider) {
        super.loadAdditional(compoundTag, provider);
        this.controller = GeneralUtil.readBlockPos(compoundTag);
        this.updateConnectivity = !compoundTag.contains("Update") || compoundTag.getBoolean("Update");
        this.width = compoundTag.contains("Width") ? compoundTag.getInt("Width") : 1;
        this.height = compoundTag.contains("Height") ? compoundTag.getInt("Height") : 1;
        this.items = NonNullList.withSize((int)162, (Object)ItemStack.EMPTY);
        ContainerHelper.loadAllItems((CompoundTag)compoundTag, this.items, (HolderLookup.Provider)provider);
        this.times = compoundTag.contains("Times") ? compoundTag.getIntArray("Times") : new int[81];
    }

    @NotNull
    public Component getDisplayName() {
        return Component.empty();
    }

    @Nullable
    public AbstractContainerMenu createMenu(int i, Inventory inventory, Player player) {
        return null;
    }
}

