/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.farm_and_charm.core.block.crops;

import java.util.Optional;
import net.minecraft.BlockUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.satisfy.farm_and_charm.core.block.RopeBlock;
import net.satisfy.farm_and_charm.core.block.crops.ClimbingCropBlock;
import net.satisfy.farm_and_charm.core.block.crops.TomatoCropHeadBlock;
import net.satisfy.farm_and_charm.core.registry.ObjectRegistry;
import org.jetbrains.annotations.NotNull;

public class TomatoCropBodyBlock
extends ClimbingCropBlock
implements BonemealableBlock {
    public static final VoxelShape SHAPE = Block.box((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)16.0, (double)15.0);
    public static final IntegerProperty AGE = BlockStateProperties.AGE_4;

    public TomatoCropBodyBlock(BlockBehaviour.Properties properties) {
        super(properties, SHAPE);
        this.registerDefaultState((BlockState)((BlockState)this.defaultBlockState().setValue((Property)AGE, (Comparable)Integer.valueOf(0))).setValue((Property)SUPPORTED, (Comparable)Boolean.valueOf(false)));
    }

    @Override
    protected IntegerProperty getAgeProperty() {
        return AGE;
    }

    @Override
    protected int getMaxAge() {
        return 4;
    }

    @Override
    protected ItemLike getRipeItem() {
        return (ItemLike)ObjectRegistry.TOMATO.get();
    }

    @Override
    protected ItemLike getRottenItem() {
        return (ItemLike)ObjectRegistry.ROTTEN_TOMATO.get();
    }

    @Override
    protected int getHarvestResetAge(Level level, BlockPos pos, BlockState state) {
        return level.getBlockState(pos.above()).is((Block)ObjectRegistry.TOMATO_CROP.get()) ? 2 : 1;
    }

    @NotNull
    public ItemStack getCloneItemStack(LevelReader level, BlockPos pos, BlockState state) {
        return new ItemStack((ItemLike)ObjectRegistry.TOMATO_CROP.get());
    }

    public boolean canBeReplaced(BlockState state, BlockPlaceContext ctx) {
        boolean base = super.canBeReplaced(state, ctx);
        return (!base || !ctx.getItemInHand().is(((Block)ObjectRegistry.TOMATO_CROP.get()).asItem())) && base;
    }

    @NotNull
    public BlockState updateShape(BlockState state, Direction dir, BlockState neighbor, LevelAccessor level, BlockPos pos, BlockPos neighborPos) {
        if (dir == Direction.DOWN && !state.canSurvive((LevelReader)level, pos)) {
            level.scheduleTick(pos, (Block)this, 1);
        }
        return state;
    }

    public boolean isValidBonemealTarget(LevelReader level, BlockPos pos, BlockState state) {
        return (Integer)state.getValue((Property)AGE) < this.getMaxAge();
    }

    public boolean isBonemealSuccess(Level level, RandomSource random, BlockPos pos, BlockState state) {
        return (Integer)state.getValue((Property)AGE) < this.getMaxAge();
    }

    public void performBonemeal(ServerLevel level, RandomSource random, BlockPos pos, BlockState state) {
        Optional headOpt = BlockUtil.getTopConnectedBlock((BlockGetter)level, (BlockPos)pos, (Block)state.getBlock(), (Direction)Direction.UP, (Block)((Block)ObjectRegistry.TOMATO_CROP.get()));
        if (headOpt.isPresent()) {
            boolean ropeOk;
            BlockPos headPos = (BlockPos)headOpt.get();
            BlockState headState = level.getBlockState(headPos);
            BlockPos up = headPos.above();
            BlockState rope = level.getBlockState(up);
            boolean bl = ropeOk = !(!(rope.getBlock() instanceof RopeBlock) || rope.hasProperty((Property)RopeBlock.DOWN) && (Boolean)rope.getValue((Property)RopeBlock.DOWN) == false || rope.hasProperty((Property)RopeBlock.CENTER_PIECE) && (Boolean)rope.getValue((Property)RopeBlock.CENTER_PIECE) == false || rope.hasProperty((Property)RopeBlock.ROPE_KNOT) && (Boolean)rope.getValue((Property)RopeBlock.ROPE_KNOT) != false || rope.hasProperty((Property)RopeBlock.SUPPORTING_ROPE_KNOT) && (Boolean)rope.getValue((Property)RopeBlock.SUPPORTING_ROPE_KNOT) != false);
            if (headState.hasProperty((Property)SUPPORTED) && ((Boolean)headState.getValue((Property)SUPPORTED)).booleanValue() && ropeOk && TomatoCropHeadBlock.getHeight(headPos, (LevelAccessor)level) < TomatoCropHeadBlock.getMaxHeight((LevelAccessor)level, headPos)) {
                boolean supported = (Boolean)headState.getValue((Property)SUPPORTED);
                BlockState bodyAtHead = (BlockState)((BlockState)((Block)ObjectRegistry.TOMATO_CROP_BODY.get()).defaultBlockState().setValue((Property)AGE, (Comparable)((Integer)headState.getValue((Property)TomatoCropHeadBlock.AGE)))).setValue((Property)SUPPORTED, (Comparable)Boolean.valueOf(supported));
                level.setBlock(headPos, bodyAtHead, 2);
                level.setBlockAndUpdate(up, (BlockState)((BlockState)((Block)ObjectRegistry.TOMATO_CROP.get()).defaultBlockState().setValue((Property)TomatoCropHeadBlock.AGE, (Comparable)Integer.valueOf(0))).setValue((Property)SUPPORTED, (Comparable)Boolean.valueOf(supported)));
                return;
            }
        }
        if ((Integer)state.getValue((Property)AGE) < this.getMaxAge()) {
            boolean supported = (Boolean)state.getValue((Property)SUPPORTED);
            level.setBlockAndUpdate(pos, (BlockState)((BlockState)state.setValue((Property)AGE, (Comparable)Integer.valueOf((Integer)state.getValue((Property)AGE) + 1))).setValue((Property)SUPPORTED, (Comparable)Boolean.valueOf(supported)));
        } else {
            this.dropFruits((Level)level, pos, state);
        }
    }
}

