/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.farm_and_charm.core.block.crops;

import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.satisfy.farm_and_charm.core.registry.ObjectRegistry;

public interface BigCropCapable {
    public int getMaxAge();

    public IntegerProperty getAgeProperty();

    public BooleanProperty getBigProperty();

    public BooleanProperty getGiantProperty();

    default public void tryTransformToBigCrop(Level level, BlockPos pos, BlockState state, boolean usedCompost) {
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        IntegerProperty age = this.getAgeProperty();
        BooleanProperty big = this.getBigProperty();
        BooleanProperty giant = this.getGiantProperty();
        if (!(state.hasProperty((Property)age) && state.hasProperty((Property)big) && state.hasProperty((Property)giant))) {
            return;
        }
        int currentAge = (Integer)state.getValue((Property)age);
        boolean isBig = (Boolean)state.getValue((Property)big);
        boolean isGiant = (Boolean)state.getValue((Property)giant);
        if (currentAge != this.getMaxAge()) {
            return;
        }
        boolean hasWater = this.hasWaterSourceNearby(level, pos);
        boolean isRaining = level.isRainingAt(pos.above());
        int lightLevel = level.getMaxLocalRawBrightness(pos.above());
        RandomSource random = level.getRandom();
        if (usedCompost) {
            if (!hasWater) {
                return;
            }
            if (!isBig && random.nextFloat() < 0.144f) {
                level.setBlock(pos, (BlockState)state.setValue((Property)big, (Comparable)Boolean.valueOf(true)), 2);
                this.spawnHappyParticles(serverLevel, pos);
            } else if (isBig && !isGiant && random.nextFloat() < 0.1f) {
                level.setBlock(pos, (BlockState)state.setValue((Property)giant, (Comparable)Boolean.valueOf(true)), 2);
                this.spawnHappyParticles(serverLevel, pos);
            }
        } else {
            long seed = pos.asLong();
            RandomSource staticRandom = RandomSource.create((long)seed);
            if (staticRandom.nextFloat() >= 0.25f) {
                return;
            }
            if (!isBig && isRaining && lightLevel > 12 && random.nextFloat() < 0.03f) {
                level.setBlock(pos, (BlockState)state.setValue((Property)big, (Comparable)Boolean.valueOf(true)), 2);
                this.spawnHappyParticles(serverLevel, pos);
            } else if (!isBig && hasWater && random.nextFloat() < 0.144f) {
                level.setBlock(pos, (BlockState)state.setValue((Property)big, (Comparable)Boolean.valueOf(true)), 2);
                this.spawnHappyParticles(serverLevel, pos);
            }
        }
    }

    private boolean hasWaterSourceNearby(Level level, BlockPos pos) {
        for (BlockPos checkPos : BlockPos.betweenClosed((BlockPos)pos.offset(-4, 0, -4), (BlockPos)pos.offset(4, 1, 4))) {
            if (!level.getFluidState(checkPos).is(FluidTags.WATER)) continue;
            return true;
        }
        for (BlockPos checkPos : BlockPos.betweenClosed((BlockPos)pos.offset(-2, 0, -2), (BlockPos)pos.offset(2, 2, 2))) {
            if (!level.getBlockState(checkPos).is((Block)ObjectRegistry.WATER_SPRINKLER.get())) continue;
            return true;
        }
        return false;
    }

    private void spawnHappyParticles(ServerLevel level, BlockPos pos) {
        double x = (double)pos.getX() + 0.5;
        double y = (double)pos.getY() + 0.75;
        double z = (double)pos.getZ() + 0.5;
        level.sendParticles((ParticleOptions)ParticleTypes.HAPPY_VILLAGER, x, y, z, 8, 0.25, 0.25, 0.25, 0.0);
    }
}

