/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.farm_and_charm.core.block;

import com.mojang.serialization.MapCodec;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.satisfy.farm_and_charm.core.block.entity.RoasterBlockEntity;
import net.satisfy.farm_and_charm.core.registry.SoundEventRegistry;
import net.satisfy.farm_and_charm.core.util.GeneralUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RoasterBlock
extends BaseEntityBlock {
    public static final MapCodec<RoasterBlock> CODEC = RoasterBlock.simpleCodec(RoasterBlock::new);
    public static final DirectionProperty FACING = BlockStateProperties.HORIZONTAL_FACING;
    public static final BooleanProperty LIT = BooleanProperty.create((String)"lit");
    public static final BooleanProperty ROASTING = BooleanProperty.create((String)"roasting");
    public static final BooleanProperty HANGING = BooleanProperty.create((String)"hanging");
    protected static final VoxelShape HANGING_SHAPE = Shapes.or((VoxelShape)Shapes.box((double)0.1875, (double)0.5, (double)0.25, (double)0.8125, (double)0.5625, (double)0.75), (VoxelShape[])new VoxelShape[]{Shapes.box((double)0.4375, (double)0.5625, (double)0.4375, (double)0.5625, (double)0.625, (double)0.5625), Shapes.box((double)0.0, (double)0.3125, (double)0.3125, (double)0.125, (double)0.4375, (double)0.6875), Shapes.box((double)0.125, (double)0.125, (double)0.1875, (double)0.875, (double)0.5, (double)0.8125), Shapes.box((double)0.875, (double)0.3125, (double)0.3125, (double)1.0, (double)0.4375, (double)0.6875), Shapes.box((double)0.0625, (double)0.4375, (double)0.4375, (double)0.0625, (double)0.875, (double)0.5625), Shapes.box((double)0.9375, (double)0.4375, (double)0.4375, (double)0.9375, (double)0.875, (double)0.5625), Shapes.box((double)0.0625, (double)0.875, (double)0.4375, (double)0.9375, (double)0.875, (double)0.5625)});
    private static final Map<Direction, VoxelShape> SHAPES = (Map)Util.make(new HashMap(), map -> {
        Supplier<VoxelShape> voxelShapeSupplier = () -> Shapes.or((VoxelShape)Shapes.box((double)0.1875, (double)0.375, (double)0.25, (double)0.8125, (double)0.4375, (double)0.75), (VoxelShape[])new VoxelShape[]{Shapes.box((double)0.4375, (double)0.4375, (double)0.4375, (double)0.5625, (double)0.5, (double)0.5625), Shapes.box((double)0.0, (double)0.1875, (double)0.3125, (double)0.125, (double)0.3125, (double)0.6875), Shapes.box((double)0.125, (double)0.0, (double)0.1875, (double)0.875, (double)0.375, (double)0.8125), Shapes.box((double)0.875, (double)0.1875, (double)0.3125, (double)1.0, (double)0.3125, (double)0.6875)});
        for (Direction direction : Direction.Plane.HORIZONTAL) {
            map.put(direction, GeneralUtil.rotateShape(Direction.NORTH, direction, voxelShapeSupplier.get()));
        }
    });

    public RoasterBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)FACING, (Comparable)Direction.NORTH)).setValue((Property)LIT, (Comparable)Boolean.valueOf(false))).setValue((Property)ROASTING, (Comparable)Boolean.valueOf(false))).setValue((Property)HANGING, (Comparable)Boolean.valueOf(false)));
    }

    @NotNull
    protected MapCodec<? extends BaseEntityBlock> codec() {
        return CODEC;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING, LIT, ROASTING, HANGING});
    }

    @NotNull
    public VoxelShape getShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        Direction facing = (Direction)state.getValue((Property)FACING);
        boolean hanging = (Boolean)state.getValue((Property)HANGING);
        if (hanging) {
            return GeneralUtil.rotateShape(Direction.NORTH, facing, HANGING_SHAPE);
        }
        return SHAPES.get(facing);
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        Direction facing = context.getHorizontalDirection().getOpposite();
        boolean hanging = context.getClickedFace() == Direction.DOWN;
        return (BlockState)((BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)facing)).setValue((Property)HANGING, (Comparable)Boolean.valueOf(hanging));
    }

    public boolean canSurvive(BlockState state, LevelReader world, BlockPos pos) {
        if (((Boolean)state.getValue((Property)HANGING)).booleanValue()) {
            return !world.isEmptyBlock(pos.above());
        }
        VoxelShape shape = world.getBlockState(pos.below()).getShape((BlockGetter)world, pos.below());
        return Block.isFaceFull((VoxelShape)shape, (Direction)Direction.UP);
    }

    public void tick(BlockState state, ServerLevel world, BlockPos pos, RandomSource random) {
        if (!state.canSurvive((LevelReader)world, pos)) {
            world.destroyBlock(pos, true);
        }
    }

    @NotNull
    public BlockState updateShape(BlockState state, Direction direction, BlockState neighborState, LevelAccessor world, BlockPos pos, BlockPos neighborPos) {
        if (!state.canSurvive((LevelReader)world, pos)) {
            world.scheduleTick(pos, (Block)this, 1);
        }
        return super.updateShape(state, direction, neighborState, world, pos, neighborPos);
    }

    @NotNull
    public InteractionResult useWithoutItem(BlockState state, Level world, BlockPos pos, Player player, BlockHitResult hit) {
        BlockEntity entity;
        if (!world.isClientSide && (entity = world.getBlockEntity(pos)) instanceof MenuProvider) {
            player.openMenu((MenuProvider)entity);
            return InteractionResult.CONSUME;
        }
        return InteractionResult.SUCCESS;
    }

    public void animateTick(BlockState state, Level world, BlockPos pos, RandomSource random) {
        if (!((Boolean)state.getValue((Property)ROASTING)).booleanValue() && !((Boolean)state.getValue((Property)LIT)).booleanValue()) {
            return;
        }
        double d = (double)pos.getX() + 0.5;
        double e = (double)pos.getY() + 0.7;
        double f = (double)pos.getZ() + 0.5;
        world.playLocalSound(d, e, f, (SoundEvent)SoundEventRegistry.ROASTER_COOKING.get(), SoundSource.BLOCKS, 0.05f, 1.0f, false);
        double h = random.nextDouble() * 0.6 - 0.3;
        double i = h * (double)(random.nextBoolean() ? 1 : -1);
        double j = random.nextDouble() * 0.5625;
        double k = h * (double)(random.nextBoolean() ? 1 : -1);
        world.addParticle((ParticleOptions)ParticleTypes.SMOKE, d + i, e + j, f + k, 0.0, 0.0, 0.0);
    }

    @NotNull
    public RenderShape getRenderShape(BlockState state) {
        return RenderShape.MODEL;
    }

    @Nullable
    public BlockEntity newBlockEntity(@NotNull BlockPos pos, @NotNull BlockState state) {
        return new RoasterBlockEntity(pos, state);
    }

    public void onRemove(BlockState state, Level world, BlockPos pos, BlockState newState, boolean isMoving) {
        if (!state.is(newState.getBlock())) {
            BlockEntity blockEntity = world.getBlockEntity(pos);
            if (blockEntity instanceof RoasterBlockEntity) {
                Containers.dropContents((Level)world, (BlockPos)pos, ((RoasterBlockEntity)blockEntity).getItems());
                world.updateNeighbourForOutputSignal(pos, (Block)this);
            }
            super.onRemove(state, world, pos, newState, isMoving);
        }
    }

    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level world, BlockState state, BlockEntityType<T> type) {
        if (!world.isClientSide) {
            return (lvl, pos, blkState, t) -> {
                if (t instanceof RoasterBlockEntity) {
                    RoasterBlockEntity roastingPot = (RoasterBlockEntity)t;
                    roastingPot.tick(lvl, pos, blkState, roastingPot);
                }
            };
        }
        return null;
    }

    public void appendHoverText(ItemStack itemStack, Item.TooltipContext tooltipContext, List<Component> list, TooltipFlag tooltipFlag) {
        list.add((Component)Component.translatable((String)"tooltip.farm_and_charm.canbeplaced").withStyle(ChatFormatting.GRAY));
    }
}

