/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.brewery.core.registry;

import dev.architectury.platform.Platform;
import dev.architectury.registry.registries.DeferredRegister;
import dev.architectury.registry.registries.Registrar;
import dev.architectury.registry.registries.RegistrySupplier;
import java.util.function.Supplier;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.effect.MobEffectInstance;
import net.satisfy.brewery.Brewery;
import net.satisfy.brewery.core.effect.BlackoutEffect;
import net.satisfy.brewery.core.effect.CombustionEffect;
import net.satisfy.brewery.core.effect.ExplosionEffect;
import net.satisfy.brewery.core.effect.HaleyEffect;
import net.satisfy.brewery.core.effect.HealingTouchEffect;
import net.satisfy.brewery.core.effect.IntoxicationEffect;
import net.satisfy.brewery.core.effect.LightningStrikeEffect;
import net.satisfy.brewery.core.effect.MiningEffect;
import net.satisfy.brewery.core.effect.PacifyEffect;
import net.satisfy.brewery.core.effect.PartystarterEffect;
import net.satisfy.brewery.core.effect.PintCharismaEffect;
import net.satisfy.brewery.core.effect.ProtectiveTouchEffect;
import net.satisfy.brewery.core.effect.RenewingTouchEffect;
import net.satisfy.brewery.core.effect.RepulsionEffect;
import net.satisfy.brewery.core.effect.SnowWhiteEffect;
import net.satisfy.brewery.core.effect.ToxicTouchEffect;

public class MobEffectRegistry {
    private static final DeferredRegister<MobEffect> MOB_EFFECTS = DeferredRegister.create((String)"brewery", (ResourceKey)Registries.MOB_EFFECT);
    private static final Registrar<MobEffect> MOB_EFFECTS_REGISTRAR = MOB_EFFECTS.getRegistrar();
    public static final RegistrySupplier<MobEffect> DRUNK = MobEffectRegistry.registerEffect("drunk", IntoxicationEffect::new);
    public static final RegistrySupplier<MobEffect> BLACKOUT = MobEffectRegistry.registerEffect("blackout", () -> new BlackoutEffect().setBlendDuration(22));
    public static final RegistrySupplier<MobEffect> MINING = MobEffectRegistry.registerEffect("mining", () -> new MiningEffect(MobEffectCategory.BENEFICIAL, 7032618));
    public static final RegistrySupplier<MobEffect> PACIFY = MobEffectRegistry.registerEffect("pacify", () -> new PacifyEffect(MobEffectCategory.BENEFICIAL, 0x88DDEE));
    public static final RegistrySupplier<MobEffect> REPULSION = MobEffectRegistry.registerEffect("repulsion", () -> new RepulsionEffect(MobEffectCategory.BENEFICIAL, 0xFF4444));
    public static final RegistrySupplier<MobEffect> LIGHTNING_STRIKE = MobEffectRegistry.registerEffect("lightning_strike", () -> new LightningStrikeEffect(MobEffectCategory.BENEFICIAL, 0xE6E600));
    public static final RegistrySupplier<MobEffect> EXPLOSION = MobEffectRegistry.registerEffect("explosion", () -> new ExplosionEffect(MobEffectCategory.BENEFICIAL, 0xFF7700));
    public static final RegistrySupplier<MobEffect> COMBUSTION = MobEffectRegistry.registerEffect("combustion", () -> new CombustionEffect(MobEffectCategory.BENEFICIAL, 0xCC2200));
    public static final RegistrySupplier<MobEffect> TOXICTOUCH = MobEffectRegistry.registerEffect("toxictouch", () -> new ToxicTouchEffect(MobEffectCategory.HARMFUL, 43588));
    public static final RegistrySupplier<MobEffect> RENEWINGTOUCH = MobEffectRegistry.registerEffect("renewingtouch", () -> new RenewingTouchEffect(MobEffectCategory.BENEFICIAL, 0x66FF99));
    public static final RegistrySupplier<MobEffect> HEALINGTOUCH = MobEffectRegistry.registerEffect("healingtouch", () -> new HealingTouchEffect(MobEffectCategory.BENEFICIAL, 0xFF66CC));
    public static final RegistrySupplier<MobEffect> PROTECTIVETOUCH = MobEffectRegistry.registerEffect("protectivetouch", () -> new ProtectiveTouchEffect(MobEffectCategory.BENEFICIAL, 0x3399FF));
    public static final RegistrySupplier<MobEffect> PARTYSTARTER = MobEffectRegistry.registerEffect("partystarter", () -> new PartystarterEffect(MobEffectCategory.BENEFICIAL, 0xFF33AA));
    public static final RegistrySupplier<MobEffect> SNOWWHITE = MobEffectRegistry.registerEffect("snowwhite", () -> new SnowWhiteEffect(MobEffectCategory.BENEFICIAL, 0xE0FFFF));
    public static final RegistrySupplier<MobEffect> PINTCHARISMA = MobEffectRegistry.registerEffect("pintcharisma", () -> new PintCharismaEffect(MobEffectCategory.BENEFICIAL, 16766720));
    public static final RegistrySupplier<MobEffect> HALEY = MobEffectRegistry.registerEffect("haley", () -> new HaleyEffect(MobEffectCategory.BENEFICIAL, 0xFF99FF));

    private static RegistrySupplier<MobEffect> registerEffect(String name, Supplier<MobEffect> effect) {
        if (Platform.isNeoForge()) {
            return MOB_EFFECTS.register(name, effect);
        }
        return MOB_EFFECTS_REGISTRAR.register(Brewery.identifier(name), effect);
    }

    public static void init() {
        MOB_EFFECTS.register();
    }

    public static Holder<MobEffect> holder(RegistrySupplier<MobEffect> supplier) {
        return (Holder)BuiltInRegistries.MOB_EFFECT.getResourceKey((Object)((MobEffect)supplier.get())).flatMap(arg_0 -> ((Registry)BuiltInRegistries.MOB_EFFECT).getHolder(arg_0)).orElseThrow();
    }

    public static MobEffectInstance inst(RegistrySupplier<MobEffect> supplier, int duration) {
        return new MobEffectInstance(MobEffectRegistry.holder(supplier), duration);
    }
}

