/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.brewery.core.registry;

import dev.architectury.registry.level.entity.EntityAttributeRegistry;
import dev.architectury.registry.registries.DeferredRegister;
import dev.architectury.registry.registries.RegistrySupplier;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Supplier;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.satisfy.brewery.Brewery;
import net.satisfy.brewery.core.block.entity.BeerMugBlockEntity;
import net.satisfy.brewery.core.block.entity.BrewstationBlockEntity;
import net.satisfy.brewery.core.block.entity.CabinetBlockEntity;
import net.satisfy.brewery.core.block.entity.CompletionistBannerEntity;
import net.satisfy.brewery.core.block.entity.StorageBlockEntity;
import net.satisfy.brewery.core.block.entity.WallDecorationBlockEntity;
import net.satisfy.brewery.core.entity.BeerElementalAttackEntity;
import net.satisfy.brewery.core.entity.BeerElementalEntity;
import net.satisfy.brewery.core.entity.DarkBrewEntity;
import net.satisfy.brewery.core.registry.ObjectRegistry;
import net.satisfy.brewery.core.registry.StorageTypeRegistry;

public class EntityTypeRegistry {
    private static final DeferredRegister<BlockEntityType<?>> BLOCK_ENTITY_TYPES = DeferredRegister.create((String)"brewery", (ResourceKey)Registries.BLOCK_ENTITY_TYPE);
    private static final DeferredRegister<EntityType<?>> ENTITY_TYPES = DeferredRegister.create((String)"brewery", (ResourceKey)Registries.ENTITY_TYPE);
    public static final RegistrySupplier<EntityType<DarkBrewEntity>> DARK_BREW = EntityTypeRegistry.registerEntityType("dark_brew", () -> EntityType.Builder.of(DarkBrewEntity::new, (MobCategory)MobCategory.MISC).sized(0.5f, 0.5f).build(Brewery.identifier("dark_brew").toString()));
    public static final RegistrySupplier<EntityType<BeerElementalEntity>> BEER_ELEMENTAL = EntityTypeRegistry.registerEntityType("beer_elemental", () -> EntityType.Builder.of(BeerElementalEntity::new, (MobCategory)MobCategory.MONSTER).sized(1.0f, 1.6f).clientTrackingRange(80).updateInterval(3).build(Brewery.identifier("beer_elemental").toString()));
    public static final RegistrySupplier<EntityType<BeerElementalAttackEntity>> BEER_ELEMENTAL_ATTACK = EntityTypeRegistry.registerEntityType("beer_elemental_attack", () -> EntityType.Builder.of(BeerElementalAttackEntity::new, (MobCategory)MobCategory.MISC).sized(0.3125f, 0.3125f).clientTrackingRange(4).updateInterval(10).build(Brewery.identifier("beer_elemental_attack").toString()));
    public static final RegistrySupplier<BlockEntityType<BrewstationBlockEntity>> BREWINGSTATION_BLOCK_ENTITY = EntityTypeRegistry.registerBlockEntity("brewingstation", () -> BlockEntityType.Builder.of(BrewstationBlockEntity::new, (Block[])new Block[]{(Block)ObjectRegistry.WOODEN_BREWINGSTATION.get(), (Block)ObjectRegistry.COPPER_BREWINGSTATION.get(), (Block)ObjectRegistry.NETHERITE_BREWINGSTATION.get()}).build(null));
    public static final RegistrySupplier<BlockEntityType<BeerMugBlockEntity>> BEER_MUG_BLOCK_ENTITY = EntityTypeRegistry.registerBlockEntity("beer_mug", () -> BlockEntityType.Builder.of(BeerMugBlockEntity::new, (Block[])new Block[]{(Block)ObjectRegistry.BEER_MUG.get()}).build(null));
    public static final RegistrySupplier<BlockEntityType<StorageBlockEntity>> STORAGE_ENTITY = EntityTypeRegistry.registerBlockEntity("storage", () -> BlockEntityType.Builder.of(StorageBlockEntity::new, (Block[])StorageTypeRegistry.registerBlocks(new HashSet<Block>()).toArray(new Block[0])).build(null));
    public static final RegistrySupplier<BlockEntityType<CabinetBlockEntity>> CABINET_BLOCK_ENTITY = EntityTypeRegistry.registerBlockEntity("cabinet", () -> BlockEntityType.Builder.of(CabinetBlockEntity::new, (Block[])EntityTypeRegistry.addCabinet(new HashSet<Block>()).toArray(new Block[0])).build(null));
    public static final RegistrySupplier<BlockEntityType<CompletionistBannerEntity>> BREWERY_BANNER = EntityTypeRegistry.registerBlockEntity("brewery_banner", () -> BlockEntityType.Builder.of(CompletionistBannerEntity::new, (Block[])new Block[]{(Block)ObjectRegistry.BREWERY_BANNER.get(), (Block)ObjectRegistry.BREWERY_WALL_BANNER.get()}).build(null));
    public static final RegistrySupplier<BlockEntityType<WallDecorationBlockEntity>> WALL_DECORATION = EntityTypeRegistry.registerBlockEntity("wall_decoration", () -> BlockEntityType.Builder.of(WallDecorationBlockEntity::new, (Block[])new Block[]{(Block)ObjectRegistry.GINGERBREAD.get()}).build(null));

    public static Set<Block> addCabinet(Set<Block> blocks) {
        blocks.add((Block)ObjectRegistry.CABINET.get());
        blocks.add((Block)ObjectRegistry.DRAWER.get());
        blocks.add((Block)ObjectRegistry.SIDEBOARD.get());
        blocks.add((Block)ObjectRegistry.WALL_CABINET.get());
        return blocks;
    }

    public static void registerBeerElemental(Supplier<? extends EntityType<? extends Monster>> typeSupplier) {
        EntityAttributeRegistry.register(typeSupplier, BeerElementalEntity::createAttributes);
    }

    private static <T extends BlockEntityType<?>> RegistrySupplier<T> registerBlockEntity(String path, Supplier<T> type) {
        return BLOCK_ENTITY_TYPES.register(Brewery.identifier(path), type);
    }

    private static <T extends EntityType<?>> RegistrySupplier<T> registerEntityType(String path, Supplier<T> type) {
        return ENTITY_TYPES.register(Brewery.identifier(path), type);
    }

    public static void init() {
        ENTITY_TYPES.register();
        BLOCK_ENTITY_TYPES.register();
        EntityTypeRegistry.registerBeerElemental(BEER_ELEMENTAL);
    }
}

