/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.brewery.core.mixin;

import java.util.Objects;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.trading.MerchantOffer;
import net.satisfy.brewery.core.registry.MobEffectRegistry;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={Villager.class})
public class VillagerDiscountMixin {
    @Inject(method={"updateSpecialPrices(Lnet/minecraft/world/entity/player/Player;)V"}, at={@At(value="HEAD")})
    private void applyHasteDiscount(Player player, CallbackInfo ci) {
        if (player.hasEffect(BuiltInRegistries.MOB_EFFECT.wrapAsHolder((Object)((MobEffect)MobEffectRegistry.PINTCHARISMA.get())))) {
            Villager villager = (Villager)this;
            for (MerchantOffer offer : villager.getOffers()) {
                int discountLevel = Objects.requireNonNull(player.getEffect(BuiltInRegistries.MOB_EFFECT.wrapAsHolder((Object)((MobEffect)MobEffectRegistry.PINTCHARISMA.get())))).getAmplifier();
                double discountForEffect = 0.1 * (double)(discountLevel + 1);
                int discount = (int)Math.floor(discountForEffect * (double)offer.getBaseCostA().getCount());
                offer.addToSpecialPriceDiff(-Math.max(discount, 1));
            }
        }
    }
}

