/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.brewery.core.block;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.satisfy.brewery.core.block.BrewingstationBlock;
import net.satisfy.brewery.core.block.property.BrewMaterial;
import net.satisfy.brewery.core.registry.BlockStateRegistry;
import net.satisfy.brewery.core.registry.SoundEventRegistry;
import net.satisfy.farm_and_charm.core.util.GeneralUtil;
import org.jetbrains.annotations.NotNull;
import org.joml.Vector3f;

public class BrewTimerBlock
extends BrewingstationBlock {
    public static final BooleanProperty TIME = BlockStateRegistry.TIME;
    public static final BooleanProperty ACTIVATED;
    public static final BooleanProperty PRESSED;
    public static final Map<Direction, VoxelShape> SHAPE;
    private static final int PRESS_DURATION = 60;
    private static final boolean canBePressed = false;
    private static final Supplier<VoxelShape> voxelShapeSupplier;
    private static int pressedTime;
    private long lastSoundTime = 0L;

    public BrewTimerBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue((Property)MATERIAL, (Comparable)((Object)BrewMaterial.WOOD))).setValue((Property)TIME, (Comparable)Boolean.valueOf(false))).setValue((Property)ACTIVATED, (Comparable)Boolean.valueOf(false))).setValue((Property)PRESSED, (Comparable)Boolean.valueOf(false)));
    }

    @NotNull
    protected InteractionResult useWithoutItem(BlockState blockState, Level level, BlockPos blockPos, Player player, BlockHitResult blockHitResult) {
        if (Boolean.TRUE.equals(blockState.getValue((Property)TIME))) {
            level.setBlockAndUpdate(blockPos, (BlockState)((BlockState)blockState.setValue((Property)TIME, (Comparable)Boolean.valueOf(false))).setValue((Property)ACTIVATED, (Comparable)Boolean.valueOf(false)));
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.CONSUME;
    }

    @NotNull
    public VoxelShape getShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return SHAPE.get(state.getValue((Property)FACING));
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{TIME, ACTIVATED, PRESSED});
    }

    public void animateTick(BlockState blockState, Level level, BlockPos blockPos, RandomSource randomSource) {
        if (Boolean.TRUE.equals(blockState.getValue((Property)TIME))) {
            double x = (double)blockPos.getX() + 0.5;
            double y = (double)blockPos.getY() + 1.2;
            double z = (double)blockPos.getZ() + 0.5;
            DustParticleOptions redDust = new DustParticleOptions(new Vector3f(1.0f, 0.0f, 0.0f), 1.0f);
            long currentTime = System.currentTimeMillis();
            if (currentTime - this.lastSoundTime >= 900L) {
                level.playLocalSound(x, y, z, (SoundEvent)SoundEventRegistry.BREWSTATION_TIMER_LOOP.get(), SoundSource.BLOCKS, 1.0f, 1.0f, false);
                this.lastSoundTime = currentTime;
            }
            for (int i = 0; i < 4; ++i) {
                double offsetX = randomSource.nextDouble() * 0.6 - 0.3;
                double offsetZ = randomSource.nextDouble() * 0.6 - 0.3;
                level.addParticle((ParticleOptions)redDust, x + offsetX, y, z + offsetZ, 1.0, 0.0, 0.0);
            }
            if (!Boolean.TRUE.equals(blockState.getValue((Property)ACTIVATED))) {
                level.setBlock(blockPos, (BlockState)blockState.setValue((Property)ACTIVATED, (Comparable)Boolean.valueOf(true)), 3);
            }
        }
    }

    static {
        PRESSED = BooleanProperty.create((String)"pressed");
        ACTIVATED = BooleanProperty.create((String)"activated");
        voxelShapeSupplier = () -> {
            VoxelShape shape = Shapes.empty();
            shape = Shapes.or((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.125, (double)0.5, (double)0.9375, (double)0.5, (double)0.875, (double)1.0));
            shape = Shapes.or((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.6875, (double)0.6875, (double)0.9375, (double)0.8125, (double)0.8125, (double)1.0));
            shape = Shapes.or((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.6875, (double)0.5, (double)0.9375, (double)0.8125, (double)0.625, (double)1.0));
            shape = Shapes.or((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.0, (double)0.125, (double)0.875, (double)1.0, (double)1.0, (double)0.9375));
            shape = Shapes.or((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.875, (double)0.125, (double)0.0, (double)1.0, (double)1.0, (double)0.875));
            shape = Shapes.or((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.0, (double)0.0, (double)0.0, (double)0.875, (double)0.125, (double)0.875));
            shape = Shapes.or((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.0, (double)0.9375, (double)0.0, (double)0.875, (double)1.0, (double)0.875));
            return shape;
        };
        SHAPE = (Map)Util.make(new HashMap(), map -> {
            for (Direction direction : Direction.Plane.HORIZONTAL.stream().toList()) {
                map.put(direction, GeneralUtil.rotateShape((Direction)Direction.NORTH, (Direction)direction, (VoxelShape)voxelShapeSupplier.get()));
            }
        });
    }
}

