/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.beachparty.neoforge.client;

import java.util.function.Function;
import net.minecraft.client.model.BoatModel;
import net.minecraft.client.model.ChestBoatModel;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.resources.PlayerSkin;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.Item;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.event.lifecycle.FMLClientSetupEvent;
import net.neoforged.neoforge.client.event.EntityRenderersEvent;
import net.neoforged.neoforge.client.event.RegisterMenuScreensEvent;
import net.neoforged.neoforge.client.extensions.common.IClientItemExtensions;
import net.neoforged.neoforge.client.extensions.common.RegisterClientExtensionsEvent;
import net.neoforged.neoforge.registries.RegisterEvent;
import net.satisfy.beachparty.client.BeachPartyClient;
import net.satisfy.beachparty.client.gui.MiniFridgeGui;
import net.satisfy.beachparty.client.gui.PalmBarGui;
import net.satisfy.beachparty.client.model.FloatyBoatModel;
import net.satisfy.beachparty.core.entity.PalmBoatEntity;
import net.satisfy.beachparty.core.registry.ObjectRegistry;
import net.satisfy.beachparty.core.registry.ScreenHandlerTypeRegistry;
import net.satisfy.beachparty.core.util.BeachpartyIdentifier;
import net.satisfy.beachparty.neoforge.client.extensions.BeachpartyChestplateExtensions;
import net.satisfy.beachparty.neoforge.client.extensions.BeachpartyHatExtensions;
import net.satisfy.beachparty.neoforge.client.extensions.DyeableBeachpartyArmorExtensions;
import net.satisfy.beachparty.neoforge.client.integration.CuriosRubberRingAxolotlRenderer;
import net.satisfy.beachparty.neoforge.client.integration.CuriosRubberRingPelicanRenderer;
import net.satisfy.beachparty.neoforge.client.integration.CuriosRubberRingRenderer;
import net.satisfy.beachparty.neoforge.client.renderer.player.layers.RubberRingAxolotlLayer;
import net.satisfy.beachparty.neoforge.client.renderer.player.layers.RubberRingLayer;
import net.satisfy.beachparty.neoforge.client.renderer.player.layers.RubberRingPelicanLayer;
import top.theillusivec4.curios.api.client.CuriosRendererRegistry;

@EventBusSubscriber(modid="beachparty", value={Dist.CLIENT}, bus=EventBusSubscriber.Bus.MOD)
public class BeachpartyClientNeoForge {
    @SubscribeEvent
    public static void beforeClientSetup(RegisterEvent event) {
        BeachPartyClient.preInitClient();
    }

    @SubscribeEvent
    public static void clientSetup(RegisterMenuScreensEvent event) {
        event.register((MenuType)ScreenHandlerTypeRegistry.PALM_BAR_GUI_HANDLER.get(), PalmBarGui::new);
        event.register((MenuType)ScreenHandlerTypeRegistry.MINI_FRIDGE_GUI_HANDLER.get(), MiniFridgeGui::new);
    }

    @SubscribeEvent
    public static void registerClientExtensions(RegisterClientExtensionsEvent event) {
        event.registerItem((IClientItemExtensions)new BeachpartyChestplateExtensions(), new Item[]{(Item)ObjectRegistry.RUBBER_RING_BLUE.get()});
        event.registerItem((IClientItemExtensions)new BeachpartyChestplateExtensions(), new Item[]{(Item)ObjectRegistry.RUBBER_RING_PINK.get()});
        event.registerItem((IClientItemExtensions)new BeachpartyChestplateExtensions(), new Item[]{(Item)ObjectRegistry.RUBBER_RING_STRIPPED.get()});
        event.registerItem((IClientItemExtensions)new BeachpartyChestplateExtensions(), new Item[]{(Item)ObjectRegistry.RUBBER_RING_AXOLOTL.get()});
        event.registerItem((IClientItemExtensions)new BeachpartyChestplateExtensions(), new Item[]{(Item)ObjectRegistry.RUBBER_RING_PELICAN.get()});
        event.registerItem((IClientItemExtensions)new BeachpartyHatExtensions(), new Item[]{(Item)ObjectRegistry.BEACH_HAT.get()});
        event.registerItem((IClientItemExtensions)new BeachpartyHatExtensions(), new Item[]{(Item)ObjectRegistry.SUNGLASSES.get()});
        event.registerItem((IClientItemExtensions)new DyeableBeachpartyArmorExtensions(), new Item[]{(Item)ObjectRegistry.TRUNKS.get()});
        event.registerItem((IClientItemExtensions)new DyeableBeachpartyArmorExtensions(), new Item[]{(Item)ObjectRegistry.BIKINI.get()});
        event.registerItem((IClientItemExtensions)new DyeableBeachpartyArmorExtensions(), new Item[]{(Item)ObjectRegistry.SWIM_WINGS.get()});
        event.registerItem((IClientItemExtensions)new DyeableBeachpartyArmorExtensions(), new Item[]{(Item)ObjectRegistry.CROCS.get()});
    }

    @SubscribeEvent
    public static void onClientSetup(FMLClientSetupEvent event) {
        event.enqueueWork(() -> {
            BeachPartyClient.initClient();
            CuriosRendererRegistry.register((Item)((Item)ObjectRegistry.RUBBER_RING_BLUE.get()), CuriosRubberRingRenderer::new);
            CuriosRendererRegistry.register((Item)((Item)ObjectRegistry.RUBBER_RING_PINK.get()), CuriosRubberRingRenderer::new);
            CuriosRendererRegistry.register((Item)((Item)ObjectRegistry.RUBBER_RING_STRIPPED.get()), CuriosRubberRingRenderer::new);
            CuriosRendererRegistry.register((Item)((Item)ObjectRegistry.RUBBER_RING_PELICAN.get()), CuriosRubberRingPelicanRenderer::new);
            CuriosRendererRegistry.register((Item)((Item)ObjectRegistry.RUBBER_RING_AXOLOTL.get()), CuriosRubberRingAxolotlRenderer::new);
        });
    }

    @SubscribeEvent
    public static void registerLayerDefinitions(EntityRenderersEvent.RegisterLayerDefinitions event) {
        for (PalmBoatEntity.Type type : PalmBoatEntity.Type.values()) {
            if (type == PalmBoatEntity.Type.FLOATY) {
                event.registerLayerDefinition(new ModelLayerLocation(BeachpartyIdentifier.identifier(type.getModelLocation()), "main"), FloatyBoatModel::createBodyModel);
                event.registerLayerDefinition(new ModelLayerLocation(BeachpartyIdentifier.identifier(type.getChestModelLocation()), "main"), FloatyBoatModel::createBodyModel);
                continue;
            }
            event.registerLayerDefinition(new ModelLayerLocation(BeachpartyIdentifier.identifier(type.getModelLocation()), "main"), BoatModel::createBodyModel);
            event.registerLayerDefinition(new ModelLayerLocation(BeachpartyIdentifier.identifier(type.getChestModelLocation()), "main"), ChestBoatModel::createBodyModel);
        }
    }

    @SubscribeEvent
    public static void registerLayersForRenderers(EntityRenderersEvent.AddLayers event) {
        BeachpartyClientNeoForge.addLayerToPlayerSkin(event, "default", RubberRingLayer::new);
        BeachpartyClientNeoForge.addLayerToPlayerSkin(event, "default", RubberRingPelicanLayer::new);
        BeachpartyClientNeoForge.addLayerToPlayerSkin(event, "default", RubberRingAxolotlLayer::new);
        BeachpartyClientNeoForge.addLayerToPlayerSkin(event, "slim", RubberRingAxolotlLayer::new);
        BeachpartyClientNeoForge.addLayerToPlayerSkin(event, "slim", RubberRingLayer::new);
        BeachpartyClientNeoForge.addLayerToPlayerSkin(event, "slim", RubberRingPelicanLayer::new);
    }

    private static <E extends Player, M extends HumanoidModel<E>> void addLayerToPlayerSkin(EntityRenderersEvent.AddLayers event, String skinName, Function<LivingEntityRenderer<E, M>, ? extends RenderLayer<E, M>> factory) {
        LivingEntityRenderer renderer = (LivingEntityRenderer)event.getSkin(PlayerSkin.Model.byName((String)skinName));
        if (renderer != null) {
            renderer.addLayer(factory.apply(renderer));
        }
    }
}

