/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.beachparty.core.item;

import dev.architectury.platform.Platform;
import java.util.List;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextColor;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ClickAction;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.CustomData;
import org.jetbrains.annotations.NotNull;

public class TrinketsArmorItem
extends ArmorItem {
    private final ResourceLocation getTexture;

    public TrinketsArmorItem(Holder<ArmorMaterial> armorMaterial, ArmorItem.Type type, Item.Properties properties, ResourceLocation getTexture) {
        super(armorMaterial, type, properties);
        this.getTexture = getTexture;
    }

    public ResourceLocation getTexture() {
        return this.getTexture;
    }

    @NotNull
    public EquipmentSlot getEquipmentSlot() {
        return this.type.getSlot();
    }

    public void toggleVisibility(ItemStack itemStack) {
        CustomData data = CustomData.of((CompoundTag)new CompoundTag());
        boolean isVisible = !data.contains("Visible") || data.copyTag().getBoolean("Visible");
        data.copyTag().putBoolean("Visible", !isVisible);
        itemStack.set(DataComponents.CUSTOM_DATA, (Object)data);
    }

    public boolean overrideOtherStackedOnMe(ItemStack slotStack, ItemStack holdingStack, Slot slot, ClickAction clickAction, Player player, SlotAccess slotAccess) {
        if (clickAction == ClickAction.SECONDARY && holdingStack.isEmpty()) {
            this.toggleVisibility(slotStack);
            return true;
        }
        return super.overrideOtherStackedOnMe(slotStack, holdingStack, slot, clickAction, player, slotAccess);
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext tooltipContext, List<Component> tooltip, TooltipFlag context) {
        if (Platform.isFabric()) {
            tooltip.add((Component)Component.translatable((String)"tooltip.beachparty.trinketsslot").withStyle(Style.EMPTY.withColor(TextColor.fromRgb((int)16446432))));
        } else if (Platform.isNeoForge()) {
            tooltip.add((Component)Component.translatable((String)"tooltip.beachparty.curiosslot").withStyle(Style.EMPTY.withColor(TextColor.fromRgb((int)16446432))));
        }
        tooltip.add((Component)Component.translatable((String)("tooltip.beachparty.effect." + this.getDescriptionId())).withStyle(Style.EMPTY.withColor(TextColor.fromRgb((int)13939843))));
        tooltip.add((Component)Component.empty());
        if (Platform.isFabric()) {
            CustomData data = CustomData.of((CompoundTag)new CompoundTag());
            boolean isVisible = !data.contains("Visible") || data.copyTag().getBoolean("Visible");
            MutableComponent toggleText = isVisible ? Component.translatable((String)"tooltip.beachparty.toggle.hide").withStyle(Style.EMPTY.withColor(TextColor.fromRgb((int)6076508))) : Component.translatable((String)"tooltip.beachparty.toggle.show").withStyle(Style.EMPTY.withColor(TextColor.fromRgb((int)6076508)));
            tooltip.add((Component)toggleText);
        }
    }
}

