/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.beachparty.core.item;

import dev.architectury.platform.Platform;
import java.util.List;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextColor;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ClickAction;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.item.component.DyedItemColor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DyeableBeachpartyArmorItem
extends ArmorItem {
    private final int defaultColor;
    private final ResourceLocation texture;
    private final ResourceLocation overlayTexture;
    private final ResourceLocation normalizedTexture;
    private final ResourceLocation normalizedOverlayTexture;

    public DyeableBeachpartyArmorItem(ArmorMaterial armorMaterial, ArmorItem.Type type, int color, Item.Properties properties, ResourceLocation texture) {
        super(BuiltInRegistries.ARMOR_MATERIAL.wrapAsHolder((Object)armorMaterial), type, properties);
        this.defaultColor = color;
        this.texture = texture;
        this.overlayTexture = null;
        this.normalizedTexture = DyeableBeachpartyArmorItem.normalize(texture);
        this.normalizedOverlayTexture = null;
    }

    public DyeableBeachpartyArmorItem(ArmorMaterial armorMaterial, ArmorItem.Type type, int color, Item.Properties properties, ResourceLocation texture, ResourceLocation overlayTexture) {
        super(BuiltInRegistries.ARMOR_MATERIAL.wrapAsHolder((Object)armorMaterial), type, properties);
        this.defaultColor = color;
        this.texture = texture;
        this.overlayTexture = overlayTexture;
        this.normalizedTexture = DyeableBeachpartyArmorItem.normalize(texture);
        this.normalizedOverlayTexture = DyeableBeachpartyArmorItem.normalize(overlayTexture);
    }

    public int getColor(ItemStack stack) {
        DyedItemColor dyed = (DyedItemColor)stack.get(DataComponents.DYED_COLOR);
        if (dyed != null) {
            return dyed.rgb();
        }
        CompoundTag tag = ((CustomData)stack.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY)).copyTag().getCompound("display");
        if (tag.contains("color", 99)) {
            return tag.getInt("color");
        }
        return this.defaultColor;
    }

    public ResourceLocation getTexture() {
        return this.normalizedTexture;
    }

    @Nullable
    public ResourceLocation getOverlayTexture() {
        return this.normalizedOverlayTexture;
    }

    @NotNull
    public EquipmentSlot getEquipmentSlot() {
        return this.type.getSlot();
    }

    public void toggleVisibility(ItemStack itemStack) {
        CustomData existing = (CustomData)itemStack.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.of((CompoundTag)new CompoundTag()));
        CompoundTag data = existing.copyTag();
        boolean isVisible = !data.contains("Visible") || data.getBoolean("Visible");
        data.putBoolean("Visible", !isVisible);
        itemStack.set(DataComponents.CUSTOM_DATA, (Object)CustomData.of((CompoundTag)data));
    }

    public boolean overrideOtherStackedOnMe(ItemStack slotStack, ItemStack holdingStack, Slot slot, ClickAction clickAction, Player player, SlotAccess slotAccess) {
        if (clickAction == ClickAction.SECONDARY && holdingStack.isEmpty()) {
            this.toggleVisibility(slotStack);
            return true;
        }
        return super.overrideOtherStackedOnMe(slotStack, holdingStack, slot, clickAction, player, slotAccess);
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext tooltipContext, List<Component> tooltip, TooltipFlag tooltipFlag) {
        if (Platform.isFabric()) {
            tooltip.add((Component)Component.translatable((String)"tooltip.beachparty.trinketsslot").withStyle(Style.EMPTY.withColor(TextColor.fromRgb((int)16446432))));
        } else if (Platform.isNeoForge()) {
            tooltip.add((Component)Component.translatable((String)"tooltip.beachparty.curiosslot").withStyle(Style.EMPTY.withColor(TextColor.fromRgb((int)16446432))));
        }
        tooltip.add((Component)Component.translatable((String)("tooltip.beachparty.effect." + this.getDescriptionId())).withStyle(Style.EMPTY.withColor(TextColor.fromRgb((int)13939843))));
        tooltip.add((Component)Component.empty());
        if (Platform.isFabric()) {
            CustomData tag = (CustomData)stack.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.of((CompoundTag)new CompoundTag()));
            boolean isVisible = !tag.copyTag().contains("Visible") || tag.copyTag().getBoolean("Visible");
            MutableComponent toggleText = isVisible ? Component.translatable((String)"tooltip.beachparty.toggle.hide").withStyle(Style.EMPTY.withColor(TextColor.fromRgb((int)6076508))) : Component.translatable((String)"tooltip.beachparty.toggle.show").withStyle(Style.EMPTY.withColor(TextColor.fromRgb((int)6076508)));
            tooltip.add((Component)toggleText);
        }
    }

    private static ResourceLocation normalize(ResourceLocation loc) {
        Object path = loc.getPath();
        if (!((String)path).startsWith("textures/")) {
            path = "textures/" + (String)path;
        }
        if (!((String)path).endsWith(".png")) {
            path = (String)path + ".png";
        }
        return ResourceLocation.fromNamespaceAndPath((String)loc.getNamespace(), (String)path);
    }
}

