/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.beachparty.core.item;

import com.google.common.collect.Lists;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TextColor;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffectUtil;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.item.component.ItemAttributeModifiers;
import net.minecraft.world.level.block.Block;
import org.jetbrains.annotations.NotNull;

public class DrinkBlockItem
extends BlockItem {
    public DrinkBlockItem(Block block, Item.Properties settings) {
        super(block, settings);
    }

    @NotNull
    public UseAnim getUseAnimation(ItemStack stack) {
        return UseAnim.DRINK;
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext tooltipContext, List<Component> tooltip, TooltipFlag context) {
        PotionContents potionContents = (PotionContents)stack.getOrDefault(DataComponents.POTION_CONTENTS, (Object)PotionContents.EMPTY);
        if (!potionContents.hasEffects()) {
            tooltip.add((Component)Component.translatable((String)"effect.none").withStyle(ChatFormatting.GRAY));
        } else {
            potionContents.forEachEffect(mobEffectInstance -> {
                MutableComponent mutableText = Component.translatable((String)mobEffectInstance.getDescriptionId());
                if (mobEffectInstance.getDuration() > 20) {
                    mutableText = Component.translatable((String)"potion.withDuration", (Object[])new Object[]{mutableText, MobEffectUtil.formatDuration((MobEffectInstance)mobEffectInstance, (float)mobEffectInstance.getDuration(), (float)mobEffectInstance.getAmplifier())});
                }
                tooltip.add((Component)mutableText.withStyle(((MobEffect)mobEffectInstance.getEffect().value()).getCategory().getTooltipFormatting()));
            });
            ArrayList attributeModifiers = Lists.newArrayList();
            if (stack.has(DataComponents.ATTRIBUTE_MODIFIERS)) {
                ItemAttributeModifiers itemAttributeModifiers = (ItemAttributeModifiers)stack.getOrDefault(DataComponents.ATTRIBUTE_MODIFIERS, (Object)ItemAttributeModifiers.EMPTY);
                itemAttributeModifiers.modifiers().forEach(entry -> {
                    Attribute attribute = (Attribute)entry.attribute().value();
                    double amount = entry.modifier().amount();
                    AttributeModifier modifier = new AttributeModifier(entry.modifier().id(), amount, entry.modifier().operation());
                    attributeModifiers.add(new Pair((Object)attribute, (Object)modifier));
                });
            }
            if (!attributeModifiers.isEmpty()) {
                tooltip.add((Component)Component.empty());
                tooltip.add((Component)Component.translatable((String)"potion.whenDrank").withStyle(ChatFormatting.DARK_PURPLE));
                for (Pair pair : attributeModifiers) {
                    double displayAmount;
                    AttributeModifier modifier = (AttributeModifier)pair.getSecond();
                    double amount = modifier.amount();
                    double d = displayAmount = modifier.operation() == AttributeModifier.Operation.ADD_MULTIPLIED_BASE || modifier.operation() == AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL ? amount * 100.0 : amount;
                    if (amount > 0.0) {
                        tooltip.add((Component)Component.translatable((String)("attribute.modifier.plus." + modifier.operation().id()), (Object[])new Object[]{ItemAttributeModifiers.ATTRIBUTE_MODIFIER_FORMAT.format(displayAmount), Component.translatable((String)((Attribute)pair.getFirst()).getDescriptionId())}).withStyle(ChatFormatting.BLUE));
                        continue;
                    }
                    if (!(amount < 0.0)) continue;
                    tooltip.add((Component)Component.translatable((String)("attribute.modifier.take." + modifier.operation().id()), (Object[])new Object[]{ItemAttributeModifiers.ATTRIBUTE_MODIFIER_FORMAT.format(-displayAmount), Component.translatable((String)((Attribute)pair.getFirst()).getDescriptionId())}).withStyle(ChatFormatting.RED));
                }
            }
        }
        tooltip.add((Component)Component.empty());
        tooltip.add((Component)Component.translatable((String)"tooltip.beachparty.canbeplaced").withStyle(style -> style.withColor(TextColor.fromRgb((int)13939843))));
    }
}

