/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.beachparty.core.compat.jei.categorys;

import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.drawable.IDrawableAnimated;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.core.HolderLookup;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.block.Block;
import net.satisfy.beachparty.core.recipe.MiniFridgeRecipe;
import net.satisfy.beachparty.core.registry.ObjectRegistry;
import net.satisfy.beachparty.core.util.BeachpartyIdentifier;
import org.jetbrains.annotations.NotNull;

public class MiniFridgeCategory
implements IRecipeCategory<MiniFridgeRecipe> {
    public static final RecipeType<MiniFridgeRecipe> RECIPE_TYPE = RecipeType.create((String)"beachparty", (String)"mini_fridge_freezing", MiniFridgeRecipe.class);
    public static final ResourceLocation TEXTURE = BeachpartyIdentifier.identifier("textures/gui/freezer_gui.png");
    private final IDrawable background;
    private final IDrawable icon;
    private final IDrawableAnimated arrow;
    private static final int WIDTH = 124;
    private static final int HEIGHT = 60;
    private static final int WIDTH_OF = 26;
    private static final int HEIGHT_OF = 13;

    public MiniFridgeCategory(IGuiHelper helper) {
        this.background = helper.createDrawable(TEXTURE, 26, 13, 124, 60);
        this.arrow = helper.drawableBuilder(TEXTURE, 176, 14, 24, 17).buildAnimated(250, IDrawableAnimated.StartDirection.LEFT, false);
        this.icon = helper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)((Block)ObjectRegistry.MINI_FRIDGE.get()).asItem().getDefaultInstance());
    }

    @NotNull
    public RecipeType<MiniFridgeRecipe> getRecipeType() {
        return RECIPE_TYPE;
    }

    @NotNull
    public Component getTitle() {
        return ((Block)ObjectRegistry.MINI_FRIDGE.get()).getName();
    }

    public int getWidth() {
        return 124;
    }

    public int getHeight() {
        return 60;
    }

    public void draw(MiniFridgeRecipe recipe, IRecipeSlotsView recipeSlotsView, GuiGraphics guiGraphics, double mouseX, double mouseY) {
        this.background.draw(guiGraphics, 0, 0);
        this.arrow.draw(guiGraphics, 53, 22);
    }

    @NotNull
    public IDrawable getIcon() {
        return this.icon;
    }

    public void setRecipe(IRecipeLayoutBuilder builder, MiniFridgeRecipe recipe, IFocusGroup focuses) {
        builder.addSlot(RecipeIngredientRole.INPUT, 30, 22).addIngredients((Ingredient)recipe.getIngredients().get(0));
        assert (Minecraft.getInstance().level != null);
        builder.addSlot(RecipeIngredientRole.OUTPUT, 90, 22).addItemStack(recipe.getResultItem((HolderLookup.Provider)Minecraft.getInstance().level.registryAccess()));
    }
}

