/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.beachparty.core.block;

import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.satisfy.beachparty.core.block.LineConnectingBlock;
import net.satisfy.beachparty.core.util.BeachpartyUtil;
import org.jetbrains.annotations.NotNull;

public class PalmTableBlock
extends LineConnectingBlock
implements SimpleWaterloggedBlock {
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.WATERLOGGED;
    public static final VoxelShape TOP_SHAPE = PalmTableBlock.box((double)0.0, (double)13.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    public static final VoxelShape[] LEG_SHAPES = new VoxelShape[]{PalmTableBlock.box((double)0.0, (double)0.0, (double)0.0, (double)2.0, (double)13.0, (double)2.0), PalmTableBlock.box((double)14.0, (double)0.0, (double)0.0, (double)16.0, (double)13.0, (double)2.0), PalmTableBlock.box((double)14.0, (double)0.0, (double)14.0, (double)16.0, (double)13.0, (double)16.0), PalmTableBlock.box((double)0.0, (double)0.0, (double)14.0, (double)2.0, (double)13.0, (double)16.0)};

    public PalmTableBlock(BlockBehaviour.Properties settings) {
        super(settings);
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    @NotNull
    public BlockState updateShape(BlockState state, Direction direction, BlockState neighborState, LevelAccessor world, BlockPos pos, BlockPos neighborPos) {
        if (direction.getAxis().isHorizontal()) {
            boolean rightConnected;
            Direction facing = (Direction)state.getValue((Property)FACING);
            BlockPos leftPos = pos.relative(facing.getCounterClockWise());
            BlockPos rightPos = pos.relative(facing.getClockWise());
            boolean leftConnected = world.getBlockState(leftPos).getBlock() == this;
            boolean bl = rightConnected = world.getBlockState(rightPos).getBlock() == this;
            state = leftConnected && rightConnected ? (BlockState)state.setValue((Property)TYPE, (Comparable)((Object)BeachpartyUtil.LineConnectingType.MIDDLE)) : (leftConnected ? (BlockState)state.setValue((Property)TYPE, (Comparable)((Object)BeachpartyUtil.LineConnectingType.RIGHT)) : (rightConnected ? (BlockState)state.setValue((Property)TYPE, (Comparable)((Object)BeachpartyUtil.LineConnectingType.LEFT)) : (BlockState)state.setValue((Property)TYPE, (Comparable)((Object)BeachpartyUtil.LineConnectingType.NONE))));
        }
        return super.updateShape(state, direction, neighborState, world, pos, neighborPos);
    }

    @NotNull
    public VoxelShape getShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        Direction direction = (Direction)state.getValue((Property)FACING);
        BeachpartyUtil.LineConnectingType type = (BeachpartyUtil.LineConnectingType)((Object)state.getValue((Property)TYPE));
        if (type == BeachpartyUtil.LineConnectingType.MIDDLE) {
            return TOP_SHAPE;
        }
        if (direction == Direction.NORTH && type == BeachpartyUtil.LineConnectingType.RIGHT || direction == Direction.SOUTH && type == BeachpartyUtil.LineConnectingType.LEFT) {
            return Shapes.or((VoxelShape)TOP_SHAPE, (VoxelShape[])new VoxelShape[]{LEG_SHAPES[1], LEG_SHAPES[2]});
        }
        if (direction == Direction.NORTH && type == BeachpartyUtil.LineConnectingType.LEFT || direction == Direction.SOUTH && type == BeachpartyUtil.LineConnectingType.RIGHT) {
            return Shapes.or((VoxelShape)TOP_SHAPE, (VoxelShape[])new VoxelShape[]{LEG_SHAPES[0], LEG_SHAPES[3]});
        }
        if (direction == Direction.EAST && type == BeachpartyUtil.LineConnectingType.LEFT || direction == Direction.WEST && type == BeachpartyUtil.LineConnectingType.RIGHT) {
            return Shapes.or((VoxelShape)TOP_SHAPE, (VoxelShape[])new VoxelShape[]{LEG_SHAPES[0], LEG_SHAPES[1]});
        }
        if (direction == Direction.EAST && type == BeachpartyUtil.LineConnectingType.RIGHT || direction == Direction.WEST && type == BeachpartyUtil.LineConnectingType.LEFT) {
            return Shapes.or((VoxelShape)TOP_SHAPE, (VoxelShape[])new VoxelShape[]{LEG_SHAPES[2], LEG_SHAPES[3]});
        }
        return Shapes.or((VoxelShape)TOP_SHAPE, (VoxelShape[])LEG_SHAPES);
    }

    @Override
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        BlockPos clickedPos;
        Level world;
        return (BlockState)Objects.requireNonNull(super.getStateForPlacement(context)).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf((world = context.getLevel()).getFluidState(clickedPos = context.getClickedPos()).getType() == Fluids.WATER));
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{WATERLOGGED});
    }

    @NotNull
    public FluidState getFluidState(BlockState state) {
        return (Boolean)state.getValue((Property)WATERLOGGED) != false ? Fluids.WATER.getSource(false) : super.getFluidState(state);
    }
}

