/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.beachparty.client.model;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.world.entity.Entity;
import net.satisfy.beachparty.client.model.LeggingsModel;
import net.satisfy.beachparty.core.util.BeachpartyIdentifier;

public class TrunksModel<T extends Entity>
extends EntityModel<T>
implements LeggingsModel {
    public static final ModelLayerLocation LAYER_LOCATION = new ModelLayerLocation(BeachpartyIdentifier.identifier("trunks"), "main");
    private final ModelPart body;
    private final ModelPart right_leg;
    private final ModelPart left_leg;

    public TrunksModel(ModelPart root) {
        this.body = root.getChild("body");
        this.right_leg = root.getChild("right_leg");
        this.left_leg = root.getChild("left_leg");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition body = partdefinition.addOrReplaceChild("body", CubeListBuilder.create().texOffs(0, 14).addBox(-4.0f, 9.6f, -2.0f, 8.0f, 1.0f, 4.0f, new CubeDeformation(0.325f)), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition right_leg = partdefinition.addOrReplaceChild("right_leg", CubeListBuilder.create().texOffs(0, 0).addBox(-2.0f, -1.0f, -2.0f, 4.0f, 12.0f, 4.0f, new CubeDeformation(0.3f)), PartPose.offset((float)-1.9f, (float)12.0f, (float)0.0f));
        PartDefinition left_leg = partdefinition.addOrReplaceChild("left_leg", CubeListBuilder.create().texOffs(16, 0).mirror().addBox(-2.0f, -1.0f, -2.0f, 4.0f, 12.0f, 4.0f, new CubeDeformation(0.3f)).mirror(false), PartPose.offset((float)1.9f, (float)12.0f, (float)0.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)32, (int)32);
    }

    public void setupAnim(T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.right_leg.xRot = (float)Math.cos(limbSwing * 0.6662f) * 1.4f * limbSwingAmount;
        this.left_leg.xRot = (float)Math.cos((double)(limbSwing * 0.6662f) + Math.PI) * 1.4f * limbSwingAmount;
    }

    @Override
    public void copyBody(ModelPart model, ModelPart left_leg, ModelPart right_leg) {
        this.body.copyFrom(model);
        this.right_leg.copyFrom(right_leg);
        this.left_leg.copyFrom(left_leg);
    }

    public void renderToBuffer(PoseStack poseStack, VertexConsumer vertexConsumer, int buffer, int packedLight, int color) {
        poseStack.pushPose();
        poseStack.scale(1.1f, 1.1f, 1.1f);
        this.body.render(poseStack, vertexConsumer, buffer, packedLight, color);
        this.right_leg.render(poseStack, vertexConsumer, buffer, packedLight, color);
        this.left_leg.render(poseStack, vertexConsumer, buffer, packedLight, color);
        poseStack.popPose();
    }
}

