/*
 * Decompiled with CFR 0.152.
 */
package de.cristelknight.doapi.terraform.boat.item;

import de.cristelknight.doapi.DoApiCommonEP;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Position;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.Boat;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public class TerraformBoatItem
extends Item {
    private static final Predicate<Entity> RIDERS = EntitySelector.NO_SPECTATORS.and(Entity::isPickable);
    private final ResourceLocation boatTypeName;
    private final boolean chest;

    public TerraformBoatItem(ResourceLocation boatTypeName, boolean chest, Item.Properties settings) {
        super(settings);
        this.boatTypeName = boatTypeName;
        this.chest = chest;
    }

    public InteractionResultHolder<ItemStack> use(Level world, Player user, InteractionHand hand) {
        ItemStack stack = user.getItemInHand(hand);
        BlockHitResult hitResult = Item.getPlayerPOVHitResult((Level)world, (Player)user, (ClipContext.Fluid)ClipContext.Fluid.ANY);
        if (hitResult.getType() == HitResult.Type.MISS) {
            return InteractionResultHolder.pass((Object)stack);
        }
        Vec3 rotationVec = user.getViewVector(1.0f);
        List riders = world.getEntities((Entity)user, user.getBoundingBox().expandTowards(rotationVec.scale(5.0)).inflate(1.0), RIDERS);
        if (!riders.isEmpty()) {
            Vec3 eyePos = user.getEyePosition();
            for (Entity entity : riders) {
                AABB box = entity.getBoundingBox().inflate((double)entity.getPickRadius());
                if (!box.contains(eyePos)) continue;
                return InteractionResultHolder.pass((Object)stack);
            }
        }
        if (hitResult.getType() == HitResult.Type.BLOCK) {
            double x = hitResult.getLocation().x;
            double y = hitResult.getLocation().y;
            double z = hitResult.getLocation().z;
            Boat boatEntity = DoApiCommonEP.createBoat(this.boatTypeName, world, x, y, z, this.chest);
            boatEntity.setYRot(user.getYRot());
            if (!world.noCollision((Entity)boatEntity, boatEntity.getBoundingBox().inflate(-0.1))) {
                return InteractionResultHolder.fail((Object)stack);
            }
            if (!world.isClientSide()) {
                world.addFreshEntity((Entity)boatEntity);
                world.gameEvent((Entity)user, (Holder)GameEvent.ENTITY_PLACE, BlockPos.containing((Position)hitResult.getLocation()));
                if (!user.getAbilities().instabuild) {
                    stack.shrink(1);
                }
            }
            user.awardStat(Stats.ITEM_USED.get((Object)this));
            return InteractionResultHolder.sidedSuccess((Object)stack, (boolean)world.isClientSide());
        }
        return InteractionResultHolder.pass((Object)stack);
    }
}

