/*
 * Decompiled with CFR 0.152.
 */
package de.cristelknight.doapi.terraform.boat.item;

import de.cristelknight.doapi.DoApiCommonEP;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.dispenser.BlockSource;
import net.minecraft.core.dispenser.DefaultDispenseItemBehavior;
import net.minecraft.core.dispenser.DispenseItemBehavior;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.vehicle.Boat;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.DispenserBlock;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.NotNull;

public class TerraformBoatDispenserBehavior
extends DefaultDispenseItemBehavior {
    private static final DispenseItemBehavior FALLBACK_BEHAVIOR = new DefaultDispenseItemBehavior();
    private static final float OFFSET_MULTIPLIER = 1.125f;
    private final ResourceLocation boatTypeName;
    private final boolean chest;

    public TerraformBoatDispenserBehavior(ResourceLocation boatTypeName, boolean chest) {
        this.boatTypeName = boatTypeName;
        this.chest = chest;
    }

    @NotNull
    public ItemStack execute(BlockSource pointer, ItemStack stack) {
        BlockPos pos;
        Direction facing = (Direction)pointer.state().getValue((Property)DispenserBlock.FACING);
        double x = (float)pointer.pos().getX() + (float)facing.getStepX() * 1.125f;
        double y = (float)pointer.pos().getY() + (float)facing.getStepY() * 1.125f;
        double z = (float)pointer.pos().getZ() + (float)facing.getStepZ() * 1.125f;
        ServerLevel world = pointer.level();
        if (world.getFluidState(pos = pointer.pos().relative(facing)).is(FluidTags.WATER)) {
            y += 1.0;
        } else if (!world.getBlockState(pos).isAir() || !world.getFluidState(pos.below()).is(FluidTags.WATER)) {
            return FALLBACK_BEHAVIOR.dispense(pointer, stack);
        }
        Boat boatEntity = DoApiCommonEP.createBoat(this.boatTypeName, (Level)world, x, y, z, this.chest);
        boatEntity.setYRot(facing.toYRot());
        world.addFreshEntity((Entity)boatEntity);
        stack.shrink(1);
        return stack;
    }
}

