/*
 * Decompiled with CFR 0.152.
 */
package de.cristelknight.doapi.neoforge.terraform.boat.impl.entity;

import de.cristelknight.doapi.neoforge.terraform.boat.impl.TerraformBoatInitializer;
import de.cristelknight.doapi.neoforge.terraform.boat.impl.TerraformBoatTrackedData;
import de.cristelknight.doapi.neoforge.terraform.boat.impl.entity.TerraformBoatHolder;
import de.cristelknight.doapi.terraform.boat.TerraformBoatType;
import java.util.Optional;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.vehicle.Boat;
import net.minecraft.world.entity.vehicle.ChestBoat;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;

public class TerraformChestBoatEntity
extends ChestBoat
implements TerraformBoatHolder {
    private static final EntityDataAccessor<Optional<TerraformBoatType>> TERRAFORM_BOAT = SynchedEntityData.defineId(TerraformChestBoatEntity.class, (EntityDataSerializer)((EntityDataSerializer)TerraformBoatTrackedData.ENTITY_DATA_BOAT.get()));

    public TerraformChestBoatEntity(EntityType<? extends TerraformChestBoatEntity> type, Level world) {
        super(type, world);
    }

    public TerraformChestBoatEntity(Level world) {
        this((EntityType<? extends TerraformChestBoatEntity>)((EntityType)TerraformBoatInitializer.CHEST_BOAT.get()), world);
    }

    public TerraformChestBoatEntity(Level world, double x, double y, double z) {
        this((EntityType<? extends TerraformChestBoatEntity>)((EntityType)TerraformBoatInitializer.CHEST_BOAT.get()), world);
        this.setPos(x, y, z);
        this.xo = x;
        this.yo = y;
        this.zo = z;
    }

    @Override
    public TerraformBoatType getTerraformBoat() {
        return ((Optional)this.entityData.get(TERRAFORM_BOAT)).orElse(null);
    }

    @Override
    public void setTerraformBoat(TerraformBoatType boat) {
        this.entityData.set(TERRAFORM_BOAT, Optional.of(boat));
    }

    protected Component getTypeName() {
        return EntityType.CHEST_BOAT.getDescription();
    }

    public Item getDropItem() {
        return this.getTerraformBoat().getChestItem();
    }

    public boolean shouldRender(double cameraX, double cameraY, double cameraZ) {
        return this.hasValidTerraformBoat() && super.shouldRender(cameraX, cameraY, cameraZ);
    }

    public void tick() {
        if (this.hasValidTerraformBoat()) {
            super.tick();
        } else {
            this.discard();
        }
    }

    public void setVariant(Boat.Type type) {
    }

    public Boat.Type getVariant() {
        return this.getImpersonatedBoatType();
    }

    protected void defineSynchedData(SynchedEntityData.Builder arg) {
        arg.define(TERRAFORM_BOAT, Optional.empty());
        super.defineSynchedData(arg);
    }

    protected void readAdditionalSaveData(CompoundTag nbt) {
        super.readAdditionalSaveData(nbt);
        this.readTerraformBoatFromNbt(nbt);
        if (!this.hasValidTerraformBoat()) {
            this.discard();
        }
    }

    protected void addAdditionalSaveData(CompoundTag nbt) {
        super.addAdditionalSaveData(nbt);
        this.writeTerraformBoatToNbt(nbt);
    }
}

