/*
 * Decompiled with CFR 0.152.
 */
package de.cristelknight.doapi.neoforge;

import com.google.common.collect.Lists;
import com.mojang.datafixers.util.Pair;
import de.cristelknight.doapi.DoApi;
import java.util.ArrayList;
import java.util.List;
import net.neoforged.fml.ModList;
import net.neoforged.neoforgespi.language.IModInfo;
import net.neoforged.neoforgespi.language.ModFileScanData;
import org.objectweb.asm.Type;

public class ApiFinder {
    public static <T> List<Pair<List<String>, T>> scanForAPIs(Class<?> annotationClazz, Class<T> returnClazz) {
        ArrayList instances = Lists.newArrayList();
        for (ModFileScanData data : ModList.get().getAllScanData()) {
            List<ModFileScanData.AnnotationData> ebsTargets = data.getAnnotations().stream().filter(annotationData -> Type.getType((Class)annotationClazz).equals((Object)annotationData.annotationType())).toList();
            List<String> modIds = data.getIModInfoData().stream().flatMap(info -> info.getMods().stream()).map(IModInfo::getModId).toList();
            for (ModFileScanData.AnnotationData ad : ebsTargets) {
                Class<?> clazz;
                try {
                    clazz = Class.forName(ad.memberName());
                }
                catch (ClassNotFoundException e) {
                    DoApi.LOGGER.error("Failed to load api class {} for @{} annotation", (Object)ad.clazz(), (Object)annotationClazz.getSimpleName(), (Object)e);
                    continue;
                }
                try {
                    instances.add(new Pair(modIds, clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0])));
                }
                catch (Throwable throwable) {
                    DoApi.LOGGER.error("Failed to load api: " + ad.memberName(), throwable);
                }
            }
        }
        return instances;
    }
}

