/*
 * Decompiled with CFR 0.152.
 */
package de.cristelknight.doapi.common.block.entity;

import de.cristelknight.doapi.common.registry.DoApiBlockEntityTypes;
import de.cristelknight.doapi.common.util.GeneralUtil;
import java.util.ArrayList;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;

public class FlowerBoxBlockEntity
extends BlockEntity {
    private NonNullList<ItemStack> flowers = NonNullList.withSize((int)2, (Object)ItemStack.EMPTY);

    public FlowerBoxBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)DoApiBlockEntityTypes.FLOWER_BOX_ENTITY.get(), pos, state);
    }

    protected void saveAdditional(CompoundTag compoundTag, HolderLookup.Provider provider) {
        ContainerHelper.saveAllItems((CompoundTag)compoundTag, this.flowers, (HolderLookup.Provider)provider);
        super.saveAdditional(compoundTag, provider);
    }

    protected void loadAdditional(CompoundTag compoundTag, HolderLookup.Provider provider) {
        super.loadAdditional(compoundTag, provider);
        this.flowers = NonNullList.withSize((int)3, (Object)ItemStack.EMPTY);
        ContainerHelper.loadAllItems((CompoundTag)compoundTag, this.flowers, (HolderLookup.Provider)provider);
    }

    public void addFlower(ItemStack stack, int slot) {
        this.flowers.set(slot, (Object)stack);
        this.setChanged();
    }

    public ItemStack removeFlower(int slot) {
        ItemStack stack = (ItemStack)this.flowers.set(slot, (Object)ItemStack.EMPTY);
        this.setChanged();
        return stack;
    }

    public ItemStack getFlower(int slot) {
        return (ItemStack)this.flowers.get(slot);
    }

    public boolean isSlotEmpty(int slot) {
        return slot < this.flowers.size() && ((ItemStack)this.flowers.get(slot)).isEmpty();
    }

    public Item[] getFlowers() {
        ArrayList<Item> items = new ArrayList<Item>();
        for (ItemStack stack : this.flowers) {
            if (stack.isEmpty()) continue;
            items.add(stack.getItem());
        }
        return items.toArray(new Item[0]);
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider provider) {
        return this.saveWithoutMetadata(provider);
    }

    public void setChanged() {
        if (this.level != null && !this.level.isClientSide()) {
            ClientboundBlockEntityDataPacket updatePacket = this.getUpdatePacket();
            for (ServerPlayer player : GeneralUtil.tracking((ServerLevel)this.level, this.getBlockPos())) {
                player.connection.send((Packet)updatePacket);
            }
        }
        super.setChanged();
    }
}

