/*
 * Decompiled with CFR 0.152.
 */
package de.cristelknight.doapi.client.recipebook.screen.widgets;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import de.cristelknight.doapi.config.builtin.RBConfig;
import java.util.Iterator;
import java.util.List;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.recipebook.PlaceRecipe;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4fStack;

@Deprecated
@OnlyIn(value=Dist.CLIENT)
public class PrivateRecipeAlternativesWidget
implements Renderable,
GuiEventListener {
    static final ResourceLocation BACKGROUND_TEXTURE = ResourceLocation.withDefaultNamespace((String)"textures/gui/recipe_book.png");
    private final List<CustomAlternativeButtonWidget> alternativeButtons = Lists.newArrayList();
    private boolean visible;
    private int buttonX;
    private int buttonY;
    private RecipeHolder<?> recipe;
    @Nullable
    private Recipe<?> lastClickedRecipe;
    float time;

    public void setVisible(boolean visible) {
        this.visible = visible;
    }

    public boolean isVisible() {
        return this.visible;
    }

    public RecipeHolder<?> getResults() {
        return this.recipe;
    }

    @Nullable
    public Recipe<?> getLastClickedRecipe() {
        return this.lastClickedRecipe;
    }

    public void showAlternativesForResult(RecipeHolder<?> recipe, int buttonX, int buttonY, int areaCenterX, int areaCenterY, float delta) {
        float p;
        float o;
        float n;
        float h;
        this.recipe = recipe;
        boolean bl = ((RBConfig)RBConfig.DEFAULT.getConfig()).craftableToggle();
        int k = 4;
        int l = (int)Math.ceil(1.0f / (float)k);
        this.buttonX = buttonX;
        this.buttonY = buttonY;
        float f = this.buttonX + 25;
        float g = areaCenterX + 50;
        if (f > g) {
            this.buttonX = (int)((float)this.buttonX - delta * (float)((int)((f - g) / delta)));
        }
        if ((h = (float)(this.buttonY + l * 25)) > (n = (float)(areaCenterY + 50))) {
            this.buttonY = (int)((float)this.buttonY - delta * (float)Mth.ceil((float)((h - n) / delta)));
        }
        if ((o = (float)this.buttonY) < (p = (float)(areaCenterY - 100))) {
            this.buttonY = (int)((float)this.buttonY - delta * (float)Mth.ceil((float)((o - p) / delta)));
        }
        this.visible = true;
        this.alternativeButtons.clear();
        this.alternativeButtons.add(new CustomAlternativeButtonWidget(this.buttonX + 6, this.buttonY + 6, this.recipe, bl));
        this.lastClickedRecipe = null;
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        CustomAlternativeButtonWidget alternativeButtonWidget;
        if (button != 0) {
            return false;
        }
        Iterator<CustomAlternativeButtonWidget> var6 = this.alternativeButtons.iterator();
        do {
            if (var6.hasNext()) continue;
            return false;
        } while (!(alternativeButtonWidget = var6.next()).mouseClicked(mouseX, mouseY, button));
        this.lastClickedRecipe = alternativeButtonWidget.recipe.value();
        return true;
    }

    public void setFocused(boolean focused) {
    }

    public boolean isFocused() {
        return false;
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float delta) {
        if (this.visible) {
            this.time += delta;
            RenderSystem.enableBlend();
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderSystem.setShaderTexture((int)0, (ResourceLocation)BACKGROUND_TEXTURE);
            PoseStack poseStack = guiGraphics.pose();
            poseStack.pushPose();
            poseStack.translate(0.0, 0.0, 170.0);
            int i = this.alternativeButtons.size() <= 16 ? 4 : 5;
            int j = Math.min(this.alternativeButtons.size(), i);
            int k = Mth.ceil((float)((float)this.alternativeButtons.size() / (float)i));
            this.renderGrid(guiGraphics, j, k, 24, 4, 82, 208);
            RenderSystem.disableBlend();
            for (CustomAlternativeButtonWidget alternativeButtonWidget : this.alternativeButtons) {
                alternativeButtonWidget.render(guiGraphics, mouseX, mouseY, delta);
            }
            poseStack.popPose();
        }
    }

    private void renderGrid(GuiGraphics guiGraphics, int i, int j, int k, int l, int m, int n) {
        guiGraphics.blit(BACKGROUND_TEXTURE, this.buttonX, this.buttonY, m, n, l, l);
        guiGraphics.blit(BACKGROUND_TEXTURE, this.buttonX + l * 2 + i * k, this.buttonY, m + k + l, n, l, l);
        guiGraphics.blit(BACKGROUND_TEXTURE, this.buttonX, this.buttonY + l * 2 + j * k, m, n + k + l, l, l);
        guiGraphics.blit(BACKGROUND_TEXTURE, this.buttonX + l * 2 + i * k, this.buttonY + l * 2 + j * k, m + k + l, n + k + l, l, l);
        for (int o = 0; o < i; ++o) {
            guiGraphics.blit(BACKGROUND_TEXTURE, this.buttonX + l + o * k, this.buttonY, m + l, n, k, l);
            guiGraphics.blit(BACKGROUND_TEXTURE, this.buttonX + l + (o + 1) * k, this.buttonY, m + l, n, l, l);
            for (int p = 0; p < j; ++p) {
                if (o == 0) {
                    guiGraphics.blit(BACKGROUND_TEXTURE, this.buttonX, this.buttonY + l + p * k, m, n + l, l, k);
                    guiGraphics.blit(BACKGROUND_TEXTURE, this.buttonX, this.buttonY + l + (p + 1) * k, m, n + l, l, l);
                }
                guiGraphics.blit(BACKGROUND_TEXTURE, this.buttonX + l + o * k, this.buttonY + l + p * k, m + l, n + l, k, k);
                guiGraphics.blit(BACKGROUND_TEXTURE, this.buttonX + l + (o + 1) * k, this.buttonY + l + p * k, m + l, n + l, l, k);
                guiGraphics.blit(BACKGROUND_TEXTURE, this.buttonX + l + o * k, this.buttonY + l + (p + 1) * k, m + l, n + l, k, l);
                guiGraphics.blit(BACKGROUND_TEXTURE, this.buttonX + l + (o + 1) * k - 1, this.buttonY + l + (p + 1) * k - 1, m + l, n + l, l + 1, l + 1);
                if (o != i - 1) continue;
                guiGraphics.blit(BACKGROUND_TEXTURE, this.buttonX + l * 2 + i * k, this.buttonY + l + p * k, m + k + l, n + l, l, k);
                guiGraphics.blit(BACKGROUND_TEXTURE, this.buttonX + l * 2 + i * k, this.buttonY + l + (p + 1) * k, m + k + l, n + l, l, l);
            }
            guiGraphics.blit(BACKGROUND_TEXTURE, this.buttonX + l + o * k, this.buttonY + l * 2 + j * k, m + l, n + k + l, k, l);
            guiGraphics.blit(BACKGROUND_TEXTURE, this.buttonX + l + (o + 1) * k, this.buttonY + l * 2 + j * k, m + l, n + k + l, l, l);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private class CustomAlternativeButtonWidget
    extends AbstractWidget
    implements PlaceRecipe<Ingredient> {
        final RecipeHolder<?> recipe;
        private final boolean craftable;
        protected final List<InputSlot> slots;

        public CustomAlternativeButtonWidget(int x, int y, RecipeHolder<?> recipe, boolean craftable) {
            super(x, y, 200, 20, CommonComponents.EMPTY);
            this.slots = Lists.newArrayList();
            this.width = 24;
            this.height = 24;
            this.recipe = recipe;
            this.craftable = craftable;
            this.alignRecipe(recipe);
        }

        protected void alignRecipe(RecipeHolder<?> recipe) {
            this.placeRecipe(3, 3, -1, recipe, recipe.value().getIngredients().iterator(), 0);
        }

        protected void updateWidgetNarration(NarrationElementOutput builder) {
            this.defaultButtonNarrationText(builder);
        }

        public void renderWidget(GuiGraphics guiGraphics, int mouseX, int mouseY, float delta) {
            RenderSystem.setShaderTexture((int)0, (ResourceLocation)BACKGROUND_TEXTURE);
            int i = 152;
            if (!this.craftable) {
                i += 26;
            }
            int j = 78;
            if (this.isHovered()) {
                j += 26;
            }
            guiGraphics.blit(BACKGROUND_TEXTURE, this.getX(), this.getY(), i, j, this.width, this.height);
            Matrix4fStack matrix4fStack = RenderSystem.getModelViewStack();
            matrix4fStack.pushMatrix();
            matrix4fStack.translate((float)(this.getX() + 2), (float)(this.getY() + 2), 125.0f);
            for (InputSlot inputSlot : this.slots) {
                matrix4fStack.pushMatrix();
                matrix4fStack.translate((float)inputSlot.y, (float)inputSlot.x, 0.0f);
                matrix4fStack.scale(0.375f, 0.375f, 1.0f);
                matrix4fStack.translate(-8.0f, -8.0f, 0.0f);
                RenderSystem.applyModelViewMatrix();
                guiGraphics.renderItem(inputSlot.stacks[Mth.floor((float)(PrivateRecipeAlternativesWidget.this.time / 30.0f)) % inputSlot.stacks.length], 0, 0);
                matrix4fStack.popMatrix();
            }
            matrix4fStack.popMatrix();
            RenderSystem.applyModelViewMatrix();
        }

        public void addItemToSlot(Ingredient ingredient, int slot, int amount, int gridX, int gridY) {
            ItemStack[] itemStacks = ingredient.getItems();
            if (itemStacks.length != 0) {
                this.slots.add(new InputSlot(this, 3 + gridY * 7, 3 + gridX * 7, itemStacks));
            }
        }

        @OnlyIn(value=Dist.CLIENT)
        protected class InputSlot {
            public final ItemStack[] stacks;
            public final int y;
            public final int x;

            public InputSlot(CustomAlternativeButtonWidget this$1, int y, int x, ItemStack[] stacks) {
                this.y = y;
                this.x = x;
                this.stacks = stacks;
            }
        }
    }
}

