/*
 * Decompiled with CFR 0.152.
 */
package de.cristelknight.doapi.client.recipebook.screen.widgets;

import com.mojang.blaze3d.systems.RenderSystem;
import de.cristelknight.doapi.client.recipebook.handler.AbstractPrivateRecipeScreenHandler;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.narration.NarratedElementType;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.core.HolderLookup;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.joml.Matrix4fStack;

@OnlyIn(value=Dist.CLIENT)
public class PrivateAnimatedResultButton
extends AbstractWidget {
    private static final ResourceLocation BACKGROUND_TEXTURE = ResourceLocation.withDefaultNamespace((String)"textures/gui/sprites/recipe_book/slot_craftable.png");
    public static final ResourceLocation SLOT_CRAFTABLE_SPRITE = ResourceLocation.withDefaultNamespace((String)"recipe_book/slot_craftable");
    public static final ResourceLocation SLOT_UNCRAFTABLE_SPRITE = ResourceLocation.withDefaultNamespace((String)"recipe_book/slot_uncraftable");
    private AbstractPrivateRecipeScreenHandler craftingScreenHandler;
    private Recipe<?> recipe;
    private float bounce;

    public PrivateAnimatedResultButton() {
        super(0, 0, 25, 25, CommonComponents.EMPTY);
    }

    public void showResultCollection(Recipe<?> recipe, AbstractPrivateRecipeScreenHandler craftingScreenHandler) {
        this.recipe = recipe;
        this.craftingScreenHandler = craftingScreenHandler;
    }

    public Recipe<?> getRecipe() {
        return this.recipe;
    }

    public void setPos(int x, int y) {
        this.setX(x);
        this.setY(y);
    }

    public void renderWidget(GuiGraphics guiGraphics, int mouseX, int mouseY, float delta) {
        Minecraft minecraftClient = Minecraft.getInstance();
        RenderSystem.setShader(GameRenderer::getPositionTexShader);
        ResourceLocation background = SLOT_CRAFTABLE_SPRITE;
        if (!this.craftingScreenHandler.hasIngredient(this.getRecipe())) {
            background = SLOT_UNCRAFTABLE_SPRITE;
        }
        boolean bl = this.bounce > 0.0f;
        Matrix4fStack matrix4fStack = RenderSystem.getModelViewStack();
        if (bl) {
            float f = 1.0f + 0.1f * (float)Math.sin(this.bounce / 15.0f * (float)Math.PI);
            matrix4fStack.pushMatrix();
            matrix4fStack.translate((float)(this.getX() + 8), (float)(this.getY() + 12), 0.0f);
            matrix4fStack.scale(f, f, 1.0f);
            matrix4fStack.translate((float)(-(this.getX() + 8)), (float)(-(this.getY() + 12)), 0.0f);
            RenderSystem.applyModelViewMatrix();
            this.bounce -= delta;
        }
        guiGraphics.blitSprite(background, this.getX(), this.getY(), this.width, this.height);
        Recipe<?> recipe = this.getResult();
        int k = 4;
        guiGraphics.renderItem(recipe.getResultItem((HolderLookup.Provider)minecraftClient.level.registryAccess()), this.getX() + k, this.getY() + k);
        if (bl) {
            matrix4fStack.popMatrix();
            RenderSystem.applyModelViewMatrix();
        }
    }

    private Recipe<?> getResult() {
        return this.recipe;
    }

    public boolean hasResult() {
        return this.getResult() != null;
    }

    public Recipe<?> currentRecipe() {
        return this.getResult();
    }

    protected boolean isValidClickButton(int button) {
        return button == 0 || button == 1;
    }

    public List<Component> getOutputTooltip() {
        ItemStack itemStack = this.currentRecipe().getResultItem((HolderLookup.Provider)Minecraft.getInstance().level.registryAccess());
        return List.of(itemStack.getHoverName());
    }

    protected void updateWidgetNarration(NarrationElementOutput builder) {
        ItemStack itemStack = this.currentRecipe().getResultItem((HolderLookup.Provider)Minecraft.getInstance().level.registryAccess());
        builder.add(NarratedElementType.TITLE, (Component)Component.translatable((String)"narration.recipe", (Object[])new Object[]{itemStack.getHoverName()}));
        builder.add(NarratedElementType.USAGE, (Component)Component.translatable((String)"narration.button.usage.hovered"));
    }

    public int getWidth() {
        return 25;
    }
}

