/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.laserio.client.screens;

import com.direwolf20.laserio.client.screens.LaserNodeSettingsScreen;
import com.direwolf20.laserio.client.screens.widgets.IconButton;
import com.direwolf20.laserio.client.screens.widgets.ToggleButton;
import com.direwolf20.laserio.common.containers.LaserNodeContainer;
import com.direwolf20.laserio.common.containers.customslot.CardHolderSlot;
import com.direwolf20.laserio.common.containers.customslot.LaserNodeSlot;
import com.direwolf20.laserio.common.items.CardCloner;
import com.direwolf20.laserio.common.items.CardHolder;
import com.direwolf20.laserio.common.items.cards.BaseCard;
import com.direwolf20.laserio.common.network.data.CopyPasteCardPayload;
import com.direwolf20.laserio.common.network.data.OpenCardPayload;
import com.direwolf20.laserio.common.network.data.OpenNodePayload;
import com.direwolf20.laserio.common.network.data.ToggleParticlesPayload;
import com.direwolf20.laserio.util.MiscTools;
import com.direwolf20.laserio.util.Vec2i;
import com.mojang.blaze3d.systems.RenderSystem;
import java.awt.Color;
import java.util.ArrayList;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.network.PacketDistributor;

public class LaserNodeScreen
extends AbstractContainerScreen<LaserNodeContainer> {
    private final ResourceLocation GUI = ResourceLocation.fromNamespaceAndPath((String)"laserio", (String)"textures/gui/laser_node.png");
    protected final LaserNodeContainer container;
    private boolean showCardHolderUI;
    private boolean currentParticles;
    Button settingsButton;
    Button particlesButton;
    private final MutableComponent[] sides = new MutableComponent[]{Component.translatable((String)"screen.laserio.down"), Component.translatable((String)"screen.laserio.up"), Component.translatable((String)"screen.laserio.north"), Component.translatable((String)"screen.laserio.south"), Component.translatable((String)"screen.laserio.west"), Component.translatable((String)"screen.laserio.east")};
    private final Vec2i[] tabs = new Vec2i[]{new Vec2i(34, 4), new Vec2i(6, 4), new Vec2i(62, 4), new Vec2i(90, 4), new Vec2i(118, 4), new Vec2i(146, 4)};

    public LaserNodeScreen(LaserNodeContainer container, Inventory inv, Component name) {
        super((AbstractContainerMenu)container, inv, name);
        this.container = container;
        this.imageHeight = 181;
        this.showCardHolderUI = container.cardHolder.isEmpty();
        this.currentParticles = container.tile.getShowParticles();
    }

    public void init() {
        super.init();
        ArrayList<Button> leftWidgets = new ArrayList<Button>();
        ResourceLocation settings = ResourceLocation.fromNamespaceAndPath((String)"laserio", (String)"textures/gui/buttons/settings.png");
        this.settingsButton = new IconButton(this.getGuiLeft() + 155, this.getGuiTop() + 25, 16, 16, settings, button -> Minecraft.getInstance().setScreen((Screen)new LaserNodeSettingsScreen(this.container, (Component)Component.translatable((String)"screen.laserio.settings"))));
        leftWidgets.add(this.settingsButton);
        ResourceLocation[] regulateTextures = new ResourceLocation[]{ResourceLocation.fromNamespaceAndPath((String)"laserio", (String)"textures/gui/buttons/regulatefalse.png"), ResourceLocation.fromNamespaceAndPath((String)"laserio", (String)"textures/gui/buttons/regulatetrue.png")};
        this.particlesButton = new ToggleButton(this.getGuiLeft() + 155, this.getGuiTop() + 45, 16, 16, regulateTextures, this.currentParticles ? 1 : 0, button -> {
            this.currentParticles = !this.currentParticles;
            ((ToggleButton)button).setTexturePosition(this.currentParticles ? 1 : 0);
            PacketDistributor.sendToServer((CustomPacketPayload)new ToggleParticlesPayload(this.currentParticles), (CustomPacketPayload[])new CustomPacketPayload[0]);
        });
        leftWidgets.add(this.particlesButton);
        for (int i = 0; i < leftWidgets.size(); ++i) {
            this.addRenderableWidget((GuiEventListener)((AbstractWidget)leftWidgets.get(i)));
        }
    }

    protected boolean hasClickedOutside(double mouseX, double mouseY, int guiLeftIn, int guiTopIn, int mouseButton) {
        if (this.showCardHolderUI) {
            return mouseX < (double)guiLeftIn - 100.0 || mouseY < (double)guiTopIn || mouseX >= (double)(guiLeftIn + this.imageWidth) || mouseY >= (double)(guiTopIn + this.imageHeight);
        }
        return super.hasClickedOutside(mouseX, mouseY, guiLeftIn, guiTopIn, mouseButton);
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        this.validateHolder();
        super.render(guiGraphics, mouseX, mouseY, partialTicks);
        this.renderTooltip(guiGraphics, mouseX, mouseY);
        if (MiscTools.inBounds(this.particlesButton.getX(), this.particlesButton.getY(), this.particlesButton.getWidth(), this.particlesButton.getHeight(), mouseX, mouseY)) {
            MutableComponent[] translatableComponents = new MutableComponent[4];
            translatableComponents[0] = Component.translatable((String)"screen.laserio.showparticles");
            translatableComponents[1] = Component.translatable((String)"screen.laserio.hideparticles");
            guiGraphics.renderTooltip(this.font, (Component)(this.currentParticles ? translatableComponents[0] : translatableComponents[1]), mouseX, mouseY);
        }
    }

    protected void renderLabels(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        guiGraphics.fill(this.tabs[this.container.side].x + 2, this.tabs[this.container.side].y + 2, this.tabs[this.container.side].x + 22, this.tabs[this.container.side].y + 14, -3750202);
        guiGraphics.fill(this.tabs[this.container.side].x, this.tabs[this.container.side].y + 11, this.tabs[this.container.side].x + 2, this.tabs[this.container.side].y + 12, -1);
        guiGraphics.fill(this.tabs[this.container.side].x + 22, this.tabs[this.container.side].y + 11, this.tabs[this.container.side].x + 24, this.tabs[this.container.side].y + 12, -1);
        guiGraphics.drawString(this.font, this.sides[this.container.side].getString(), this.imageWidth / 2 - this.font.width(this.sides[this.container.side].getString()) / 2, 20, Color.DARK_GRAY.getRGB(), false);
        guiGraphics.drawString(this.font, "U", 15, 7, Color.DARK_GRAY.getRGB(), false);
        guiGraphics.drawString(this.font, "D", 43, 7, Color.DARK_GRAY.getRGB(), false);
        guiGraphics.drawString(this.font, "N", 71, 7, Color.DARK_GRAY.getRGB(), false);
        guiGraphics.drawString(this.font, "S", 99, 7, Color.DARK_GRAY.getRGB(), false);
        guiGraphics.drawString(this.font, "W", 128, 7, Color.DARK_GRAY.getRGB(), false);
        guiGraphics.drawString(this.font, "E", 155, 7, Color.DARK_GRAY.getRGB(), false);
        for (Direction direction : Direction.values()) {
            ItemStack itemStack = this.getAdjacentBlock(direction);
            if (itemStack.isEmpty()) continue;
            guiGraphics.renderItem(itemStack, this.tabs[direction.ordinal()].x + 4, this.tabs[direction.ordinal()].y - 14, 0);
            if (!MiscTools.inBounds(this.getGuiLeft() + this.tabs[direction.ordinal()].x + 4, this.getGuiTop() + this.tabs[direction.ordinal()].y - 14, 16, 16, mouseX, mouseY)) continue;
            guiGraphics.renderTooltip(this.font, itemStack, mouseX - this.getGuiLeft(), mouseY - this.getGuiTop());
        }
    }

    protected ItemStack getAdjacentBlock(Direction direction) {
        BlockEntity blockEntity;
        BlockPos blockPos = this.container.tile.getBlockPos().relative(direction);
        Level level = this.container.playerEntity.level();
        BlockState blockState = level.getBlockState(blockPos);
        ItemStack itemStack = blockState.getBlock().asItem().getDefaultInstance();
        if (blockState.hasBlockEntity() && (blockEntity = level.getBlockEntity(blockPos)) != null) {
            blockEntity.saveToItem(itemStack, (HolderLookup.Provider)level.registryAccess());
        }
        return itemStack;
    }

    protected void renderBg(GuiGraphics guiGraphics, float partialTicks, int mouseX, int mouseY) {
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)this.GUI);
        int relX = (this.width - this.imageWidth) / 2;
        int relY = (this.height - this.imageHeight) / 2;
        guiGraphics.blit(this.GUI, relX, relY, 0, 0, this.imageWidth, this.imageHeight);
        if (this.showCardHolderUI) {
            ResourceLocation CardHolderGUI = ResourceLocation.fromNamespaceAndPath((String)"laserio", (String)"textures/gui/cardholder_node.png");
            RenderSystem.setShaderTexture((int)0, (ResourceLocation)CardHolderGUI);
            guiGraphics.blit(CardHolderGUI, this.getGuiLeft() - 100, this.getGuiTop() + 24, 0, 0, this.imageWidth, this.imageHeight);
        }
    }

    public boolean validateHolder() {
        Inventory playerInventory = this.container.playerEntity.getInventory();
        for (int i = 0; i < playerInventory.items.size(); ++i) {
            ItemStack itemStack = (ItemStack)playerInventory.items.get(i);
            if (!(itemStack.getItem() instanceof CardHolder) || !CardHolder.getUUID(itemStack).equals(this.container.cardHolderUUID)) continue;
            this.showCardHolderUI = true;
            this.toggleHolderSlots();
            return true;
        }
        this.showCardHolderUI = false;
        this.toggleHolderSlots();
        return false;
    }

    public void toggleHolderSlots() {
        for (int i = 10; i < 25; ++i) {
            Slot slot;
            if (i >= this.container.slots.size() || !((slot = this.container.getSlot(i)) instanceof CardHolderSlot)) continue;
            ((CardHolderSlot)slot).setEnabled(this.showCardHolderUI);
        }
    }

    public boolean mouseClicked(double x, double y, int btn) {
        if (this.hoveredSlot != null && this.container.getCarried().getItem() instanceof CardCloner) {
            if (this.hoveredSlot instanceof LaserNodeSlot && !this.hoveredSlot.getItem().isEmpty() && btn == 0) {
                PacketDistributor.sendToServer((CustomPacketPayload)new CopyPasteCardPayload(this.hoveredSlot.getSlotIndex(), true), (CustomPacketPayload[])new CustomPacketPayload[0]);
            }
            if (btn == 1) {
                PacketDistributor.sendToServer((CustomPacketPayload)new CopyPasteCardPayload(this.hoveredSlot.getSlotIndex(), false), (CustomPacketPayload[])new CustomPacketPayload[0]);
            }
            return true;
        }
        if (MiscTools.inBounds(this.getGuiLeft() + this.tabs[1].x, this.getGuiTop() + this.tabs[1].y, 24, 12, x, y) && this.container.side != 1) {
            PacketDistributor.sendToServer((CustomPacketPayload)new OpenNodePayload(this.container.tile.getBlockPos(), 1), (CustomPacketPayload[])new CustomPacketPayload[0]);
            Minecraft.getInstance().getSoundManager().play((SoundInstance)SimpleSoundInstance.forUI((Holder)SoundEvents.UI_BUTTON_CLICK, (float)1.0f));
            return true;
        }
        if (MiscTools.inBounds(this.getGuiLeft() + this.tabs[0].x, this.getGuiTop() + this.tabs[0].y, 24, 12, x, y) && this.container.side != 0) {
            PacketDistributor.sendToServer((CustomPacketPayload)new OpenNodePayload(this.container.tile.getBlockPos(), 0), (CustomPacketPayload[])new CustomPacketPayload[0]);
            Minecraft.getInstance().getSoundManager().play((SoundInstance)SimpleSoundInstance.forUI((Holder)SoundEvents.UI_BUTTON_CLICK, (float)1.0f));
            return true;
        }
        if (MiscTools.inBounds(this.getGuiLeft() + this.tabs[2].x, this.getGuiTop() + this.tabs[2].y, 24, 12, x, y) && this.container.side != 2) {
            PacketDistributor.sendToServer((CustomPacketPayload)new OpenNodePayload(this.container.tile.getBlockPos(), 2), (CustomPacketPayload[])new CustomPacketPayload[0]);
            Minecraft.getInstance().getSoundManager().play((SoundInstance)SimpleSoundInstance.forUI((Holder)SoundEvents.UI_BUTTON_CLICK, (float)1.0f));
            return true;
        }
        if (MiscTools.inBounds(this.getGuiLeft() + this.tabs[3].x, this.getGuiTop() + this.tabs[3].y, 24, 12, x, y) && this.container.side != 3) {
            PacketDistributor.sendToServer((CustomPacketPayload)new OpenNodePayload(this.container.tile.getBlockPos(), 3), (CustomPacketPayload[])new CustomPacketPayload[0]);
            Minecraft.getInstance().getSoundManager().play((SoundInstance)SimpleSoundInstance.forUI((Holder)SoundEvents.UI_BUTTON_CLICK, (float)1.0f));
            return true;
        }
        if (MiscTools.inBounds(this.getGuiLeft() + this.tabs[4].x, this.getGuiTop() + this.tabs[4].y, 24, 12, x, y) && this.container.side != 4) {
            PacketDistributor.sendToServer((CustomPacketPayload)new OpenNodePayload(this.container.tile.getBlockPos(), 4), (CustomPacketPayload[])new CustomPacketPayload[0]);
            Minecraft.getInstance().getSoundManager().play((SoundInstance)SimpleSoundInstance.forUI((Holder)SoundEvents.UI_BUTTON_CLICK, (float)1.0f));
            return true;
        }
        if (MiscTools.inBounds(this.getGuiLeft() + this.tabs[5].x, this.getGuiTop() + this.tabs[5].y, 24, 12, x, y) && this.container.side != 5) {
            PacketDistributor.sendToServer((CustomPacketPayload)new OpenNodePayload(this.container.tile.getBlockPos(), 5), (CustomPacketPayload[])new CustomPacketPayload[0]);
            Minecraft.getInstance().getSoundManager().play((SoundInstance)SimpleSoundInstance.forUI((Holder)SoundEvents.UI_BUTTON_CLICK, (float)1.0f));
            return true;
        }
        if (this.hoveredSlot == null || this.hoveredSlot.getItem().isEmpty() || !(this.hoveredSlot.getItem().getItem() instanceof BaseCard)) {
            return super.mouseClicked(x, y, btn);
        }
        if (btn == 1 && this.hoveredSlot instanceof LaserNodeSlot) {
            int slot = this.hoveredSlot.getSlotIndex();
            PacketDistributor.sendToServer((CustomPacketPayload)new OpenCardPayload(slot, this.container.tile.getBlockPos(), LaserNodeScreen.hasShiftDown()), (CustomPacketPayload[])new CustomPacketPayload[0]);
            return true;
        }
        return super.mouseClicked(x, y, btn);
    }
}

