/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.kubejs.recipe.schema.function;

import com.google.gson.JsonElement;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.latvian.mods.kubejs.recipe.RecipeScriptContext;
import dev.latvian.mods.kubejs.recipe.schema.RecipeSchema;
import dev.latvian.mods.kubejs.recipe.schema.function.RecipeSchemaFunction;
import dev.latvian.mods.kubejs.recipe.schema.function.RecipeSchemaFunctionType;
import dev.latvian.mods.kubejs.recipe.schema.function.ResolvedRecipeSchemaFunction;
import java.util.ArrayList;
import java.util.List;

public record BundleFunction(List<RecipeSchemaFunction> functions) implements RecipeSchemaFunction
{
    public static final RecipeSchemaFunctionType<BundleFunction> TYPE = new RecipeSchemaFunctionType("bundle", RecordCodecBuilder.mapCodec(instance -> instance.group((App)RecipeSchemaFunction.CODEC.listOf().fieldOf("functions").forGetter(BundleFunction::functions)).apply((Applicative)instance, BundleFunction::new)));

    @Override
    public RecipeSchemaFunctionType<?> type() {
        return TYPE;
    }

    @Override
    public DataResult<ResolvedRecipeSchemaFunction> resolve(DynamicOps<JsonElement> jsonOps, RecipeSchema schema) {
        ArrayList<ResolvedRecipeSchemaFunction> list = new ArrayList<ResolvedRecipeSchemaFunction>(this.functions.size());
        for (int i = 0; i < this.functions.size(); ++i) {
            RecipeSchemaFunction function = this.functions.get(i);
            DataResult<ResolvedRecipeSchemaFunction> r = function.resolve(jsonOps, schema);
            if (r.isError()) {
                int j = i + 1;
                return r.ap(DataResult.error(() -> "Failed to parse function #" + j));
            }
            list.add((ResolvedRecipeSchemaFunction)r.getOrThrow());
        }
        if (list.isEmpty()) {
            return DataResult.error(() -> "Bundled function list is empty");
        }
        return DataResult.success((Object)new Resolved(list));
    }

    public record Resolved(List<ResolvedRecipeSchemaFunction> functions) implements ResolvedRecipeSchemaFunction
    {
        @Override
        public void execute(RecipeScriptContext cx, List<Object> args) {
            for (ResolvedRecipeSchemaFunction function : this.functions) {
                function.execute(cx, args);
            }
        }
    }
}

