/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.kubejs.recipe.schema;

import dev.latvian.mods.kubejs.recipe.RecipeKey;
import dev.latvian.mods.kubejs.recipe.schema.RecipeSchema;
import dev.latvian.mods.kubejs.recipe.schema.RecipeSchemaStorage;
import dev.latvian.mods.kubejs.recipe.schema.RecipeSchemaType;
import dev.latvian.mods.kubejs.recipe.schema.RegistryAwareSchema;
import java.util.LinkedHashMap;
import java.util.NoSuchElementException;
import net.minecraft.resources.ResourceLocation;

public class RecipeNamespace
extends LinkedHashMap<String, RecipeSchemaType> {
    public final RecipeSchemaStorage storage;
    public final String name;

    public RecipeNamespace(RecipeSchemaStorage storage, String name) {
        this.storage = storage;
        this.name = name;
    }

    public RecipeNamespace register(String id, RecipeSchema type) {
        this.put(id, new RecipeSchemaType(this, ResourceLocation.fromNamespaceAndPath((String)this.name, (String)id), type));
        return this;
    }

    public RecipeNamespace register(String id, RegistryAwareSchema type) {
        return this.register(id, type.create(this.storage.getRegistries()));
    }

    public RecipeNamespace registerBasic(String id, RecipeKey<?> ... keys) {
        return this.register(id, new RecipeSchema(keys));
    }

    public RecipeNamespace shaped(String id) {
        return this.withExistingParent(id, ResourceLocation.withDefaultNamespace((String)"shaped"));
    }

    public RecipeNamespace shapeless(String id) {
        return this.withExistingParent(id, ResourceLocation.withDefaultNamespace((String)"shapeless"));
    }

    public RecipeNamespace special(String id) {
        return this.withExistingParent(id, ResourceLocation.withDefaultNamespace((String)"special"));
    }

    public RecipeNamespace withExistingParent(String id, ResourceLocation parent) {
        return this.register(id, this.storage.namespace((String)parent.getNamespace()).getRegisteredOrThrow((String)parent.getPath()).schema);
    }

    public RecipeSchemaType getRegisteredOrThrow(String id) {
        RecipeSchemaType value = (RecipeSchemaType)this.get(id);
        if (value != null) {
            return value;
        }
        throw new NoSuchElementException("Required schema %s not found!".formatted(id));
    }

    @Override
    public String toString() {
        return this.name;
    }
}

