/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.kubejs.block.custom;

import dev.latvian.mods.kubejs.block.BlockRenderType;
import dev.latvian.mods.kubejs.block.custom.ShapedBlockBuilder;
import dev.latvian.mods.kubejs.client.VariantBlockStateGenerator;
import dev.latvian.mods.kubejs.generator.KubeAssetGenerator;
import dev.latvian.mods.kubejs.util.ID;
import dev.latvian.mods.rhino.util.ReturnsSelf;
import java.util.Collection;
import java.util.List;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.TrapDoorBlock;
import net.minecraft.world.level.block.state.properties.BlockSetType;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Half;

@ReturnsSelf
public class TrapdoorBlockBuilder
extends ShapedBlockBuilder {
    public static final ResourceLocation[] TRAPDOOR_TAGS = new ResourceLocation[]{BlockTags.TRAPDOORS.location()};
    private static final ResourceLocation MODEL = ResourceLocation.withDefaultNamespace((String)"block/template_trapdoor_bottom");
    private static final ResourceLocation TOP_MODEL = ResourceLocation.withDefaultNamespace((String)"block/template_trapdoor_top");
    private static final ResourceLocation OPEN_MODEL = ResourceLocation.withDefaultNamespace((String)"block/template_trapdoor_open");
    public transient BlockSetType behaviour;

    public TrapdoorBlockBuilder(ResourceLocation i) {
        super(i, new String[0]);
        this.renderType(BlockRenderType.CUTOUT);
        this.noValidSpawns(true);
        this.notSolid();
        this.tagBoth(TRAPDOOR_TAGS);
        this.baseTexture = this.id.withPath(ID.BLOCK).toString();
        this.hardness(3.0f);
        this.behaviour = BlockSetType.OAK;
    }

    public TrapdoorBlockBuilder behaviour(BlockSetType wt) {
        this.behaviour = wt;
        return this;
    }

    @Override
    public Block createObject() {
        return new TrapDoorBlock(this.behaviour, this.createProperties());
    }

    @Override
    protected void generateBlockState(VariantBlockStateGenerator bs) {
        ResourceLocation modelBottom = this.id.withPath(ID.BLOCK);
        ResourceLocation modelTop = this.newID("block/", "_top");
        ResourceLocation modelOpen = this.newID("block/", "_open");
        Half[] halfValues = Half.values();
        List<Boolean> openValues = List.of(Boolean.TRUE, Boolean.FALSE);
        Collection facingValues = BlockStateProperties.HORIZONTAL_FACING.getPossibleValues();
        for (Half half : halfValues) {
            for (Boolean open : openValues) {
                for (Direction facing : facingValues) {
                    bs.variant("facing=" + facing.getSerializedName() + ",half=" + half.getSerializedName() + ",open=" + open, v -> {
                        VariantBlockStateGenerator.Model m = v.model(open != false ? modelOpen : (half == Half.TOP ? modelTop : modelBottom));
                        if (open.booleanValue()) {
                            m.y(switch (facing) {
                                case Direction.EAST -> 90;
                                case Direction.SOUTH -> 180;
                                case Direction.WEST -> 270;
                                default -> 0;
                            });
                        }
                    });
                }
            }
        }
    }

    @Override
    protected void generateBlockModels(KubeAssetGenerator generator) {
        generator.blockModel(this.id, m -> {
            m.parent(MODEL);
            m.texture("texture", this.baseTexture);
        });
        generator.blockModel(this.newID("", "_top"), m -> {
            m.parent(TOP_MODEL);
            m.texture("texture", this.baseTexture);
        });
        generator.blockModel(this.newID("", "_open"), m -> {
            m.parent(OPEN_MODEL);
            m.texture("texture", this.baseTexture);
        });
    }
}

