/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.justdirethings.util;

import net.minecraft.world.entity.player.Player;

public class ExperienceUtils {
    public static int getTotalExperienceForLevel(int level) {
        if (level <= 16) {
            return level * level + 6 * level;
        }
        if (level <= 31) {
            return (int)(2.5 * (double)level * (double)level - 40.5 * (double)level + 360.0);
        }
        long totalXp = (long)(4.5 * (double)level * (double)level - 162.5 * (double)level + 2220.0);
        return (int)Math.min(totalXp, Integer.MAX_VALUE);
    }

    public static int getLevelFromTotalExperience(int totalExp) {
        if (totalExp < ExperienceUtils.getTotalExperienceForLevel(16)) {
            return (int)Math.floor((-6.0 + Math.sqrt(36 + 4 * totalExp)) / 2.0);
        }
        if (totalExp < ExperienceUtils.getTotalExperienceForLevel(31)) {
            return (int)Math.floor((40.5 + Math.sqrt(1640.25 - 10.0 * (double)(360 - totalExp))) / 5.0);
        }
        return (int)Math.floor((162.5 + Math.sqrt(26406.25 - 18.0 * (double)(2220 - totalExp))) / 9.0);
    }

    public static int removeLevels(Player player, int levelsToRemove) {
        int currentTotalExp = ExperienceUtils.getPlayerTotalExperience(player);
        int targetLevel = Math.max(0, player.experienceLevel - levelsToRemove);
        int targetTotalExp = ExperienceUtils.getTotalExperienceForLevel(targetLevel);
        int expToRemove = currentTotalExp - targetTotalExp;
        player.giveExperienceLevels(-levelsToRemove);
        return expToRemove;
    }

    public static int getExperienceForNextLevel(int level) {
        if (level >= 30) {
            return 112 + (level - 30) * 9;
        }
        return level >= 15 ? 37 + (level - 15) * 5 : 7 + level * 2;
    }

    public static int getPlayerTotalExperience(Player player) {
        int exp = ExperienceUtils.getTotalExperienceForLevel(player.experienceLevel);
        long totalXp = (long)exp + (long)Math.round(player.experienceProgress * (float)player.getXpNeededForNextLevel());
        return (int)Math.min(totalXp, Integer.MAX_VALUE);
    }

    public static int getExpNeededForNextLevel(Player player) {
        return player.getXpNeededForNextLevel() - (int)(player.experienceProgress * (float)player.getXpNeededForNextLevel());
    }

    public static float getProgressToNextLevel(int totalExp) {
        int level = ExperienceUtils.getLevelFromTotalExperience(totalExp);
        int expForCurrentLevel = ExperienceUtils.getTotalExperienceForLevel(level);
        int expForNextLevel = ExperienceUtils.getExperienceForNextLevel(level);
        int expAfterFullLevels = totalExp - expForCurrentLevel;
        return (float)expAfterFullLevels / (float)expForNextLevel;
    }

    public static int removePoints(Player player, int pointsToRemove) {
        int currentTotalExp = ExperienceUtils.getPlayerTotalExperience(player);
        int expToRemove = Math.min(currentTotalExp, pointsToRemove);
        player.giveExperiencePoints(-expToRemove);
        return expToRemove;
    }
}

