/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.justdirethings.common.items.interfaces;

import com.direwolf20.justdirethings.common.items.datacomponents.JustDireDataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;

public interface ToggleableItem {
    default public boolean getEnabled(ItemStack stack) {
        return (Boolean)stack.getOrDefault(JustDireDataComponents.TOOL_ENABLED, (Object)true);
    }

    default public void toggleEnabled(ItemStack stack, Player player) {
        stack.update(JustDireDataComponents.TOOL_ENABLED, (Object)true, v -> v == false);
        boolean nowEnabled = (Boolean)stack.getOrDefault(JustDireDataComponents.TOOL_ENABLED, (Object)true);
        player.displayClientMessage((Component)Component.translatable((String)"justdirethings.toolenabled", (Object[])new Object[]{stack.getDisplayName(), nowEnabled ? Component.translatable((String)"justdirethings.enabled") : Component.translatable((String)"justdirethings.disabled")}), true);
        if (nowEnabled) {
            player.playNotifySound(SoundEvents.END_PORTAL_FRAME_FILL, SoundSource.PLAYERS, 1.0f, 1.0f);
        } else {
            player.playNotifySound(SoundEvents.ENDER_EYE_DEATH, SoundSource.PLAYERS, 1.0f, 0.5f);
        }
    }

    public static ItemStack getToggleableItem(Player player) {
        ItemStack mainHand = player.getMainHandItem();
        if (mainHand.getItem() instanceof ToggleableItem) {
            return mainHand;
        }
        ItemStack offHand = player.getOffhandItem();
        if (offHand.getItem() instanceof ToggleableItem) {
            return offHand;
        }
        return ItemStack.EMPTY;
    }
}

