/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.justdirethings.common.fluids.unrefinedt4fuel;

import com.direwolf20.justdirethings.setup.Registration;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.neoforged.neoforge.fluids.BaseFlowingFluid;

public abstract class UnrefinedT4Fuel
extends BaseFlowingFluid {
    public static final BaseFlowingFluid.Properties PROPERTIES = new BaseFlowingFluid.Properties(Registration.UNREFINED_T4_FLUID_TYPE, Registration.UNREFINED_T4_FLUID_FLOWING, Registration.UNREFINED_T4_FLUID_SOURCE).bucket(Registration.UNREFINED_T4_FLUID_BUCKET).block(Registration.UNREFINED_T4_FLUID_BLOCK);

    protected UnrefinedT4Fuel(BaseFlowingFluid.Properties properties) {
        super(properties);
    }

    public Fluid getFlowing() {
        return (Fluid)Registration.UNREFINED_T4_FLUID_FLOWING.get();
    }

    public Fluid getSource() {
        return (Fluid)Registration.UNREFINED_T4_FLUID_SOURCE.get();
    }

    public Item getBucket() {
        return (Item)Registration.UNREFINED_T4_FLUID_BUCKET.get();
    }

    protected boolean canConvertToSource(Level pLevel) {
        return false;
    }

    public static class Source
    extends UnrefinedT4Fuel {
        public Source() {
            super(PROPERTIES);
        }

        public int getAmount(FluidState pState) {
            return 8;
        }

        public boolean isSource(FluidState pState) {
            return true;
        }
    }

    public static class Flowing
    extends UnrefinedT4Fuel {
        public Flowing() {
            super(PROPERTIES);
        }

        protected void createFluidStateDefinition(StateDefinition.Builder<Fluid, FluidState> pBuilder) {
            super.createFluidStateDefinition(pBuilder);
            pBuilder.add(new Property[]{LEVEL});
        }

        public int getAmount(FluidState pState) {
            return (Integer)pState.getValue((Property)LEVEL);
        }

        public boolean isSource(FluidState pState) {
            return false;
        }
    }
}

