/*
 * Decompiled with CFR 0.152.
 */
package pro.mikey.justhammers.utils;

import java.util.Objects;
import java.util.function.Supplier;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import pro.mikey.justhammers.Hammers;

public final class DeferredResource<R, T extends R>
implements Supplier<T> {
    private final ResourceLocation location;
    private final Supplier<T> creator;
    private T instance;

    public DeferredResource(ResourceLocation location, Supplier<T> creator) {
        this.location = location;
        this.creator = creator;
    }

    public DeferredResource(String location, Supplier<T> creator) {
        this(Hammers.id(location), creator);
    }

    public ResourceLocation location() {
        return this.location;
    }

    public ResourceKey<R> createKey(ResourceKey<Registry<R>> registryKey) {
        return ResourceKey.create(registryKey, (ResourceLocation)this.location);
    }

    @Override
    public T get() {
        if (this.instance == null) {
            this.instance = this.creator.get();
        }
        return this.instance;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        DeferredResource that = (DeferredResource)obj;
        return Objects.equals(this.location, that.location);
    }

    public int hashCode() {
        return Objects.hash(this.location);
    }

    public String toString() {
        return "DeferredResource[location=" + String.valueOf(this.location) + ", supplier=" + String.valueOf(this.creator) + "]";
    }
}

