/*
 * Decompiled with CFR 0.152.
 */
package com.kreezcraft.jumpoverfences;

import com.kreezcraft.jumpoverfences.platform.Services;
import java.util.List;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.FenceBlock;
import net.minecraft.world.level.block.FenceGateBlock;
import net.minecraft.world.level.block.WallBlock;
import net.minecraft.world.level.block.state.BlockState;

public class CommonClass {
    public static void onJump(LivingEntity entity) {
        if (entity instanceof LocalPlayer) {
            LocalPlayer player = (LocalPlayer)entity;
            if (player.input.jumping && CommonClass.isPlayerNextToFence(player)) {
                player.setDeltaMovement(player.getDeltaMovement().add(0.0, 0.05, 0.0));
            }
        }
    }

    private static boolean isPlayerNextToFence(LocalPlayer player) {
        BlockPos pos = player.blockPosition();
        for (int i = -1; i < 2; ++i) {
            for (int j = -1; j < 2; ++j) {
                BlockState state = player.level().getBlockState(pos.offset(i, 0, j));
                Block block = state.getBlock();
                if (!(block instanceof FenceBlock) && !(block instanceof WallBlock) && !(block instanceof FenceGateBlock) && !state.is(BlockTags.FENCES) && !state.is(BlockTags.WALLS) && !state.is(BlockTags.FENCE_GATES) && !CommonClass.canJumpToo(block)) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean canJumpToo(Block block) {
        List<? extends String> jumpTheseToo = Services.PLATFORM.jumpTheseToo();
        if (jumpTheseToo.isEmpty()) {
            return false;
        }
        String blockName = BuiltInRegistries.BLOCK.getKey((Object)block).toString();
        return jumpTheseToo.contains(blockName);
    }
}

