/*
 * Decompiled with CFR 0.152.
 */
package net.commoble.jumbofurnace.jumbo_furnace;

import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.commoble.jumbofurnace.JumboFurnace;
import net.commoble.jumbofurnace.jumbo_furnace.JumboFurnaceCoreBlockEntity;
import net.commoble.jumbofurnace.jumbo_furnace.JumboFurnaceMenu;
import net.commoble.jumbofurnace.jumbo_furnace.JumboFurnaceOutputSlot;
import net.commoble.jumbofurnace.recipes.InFlightRecipe;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.neoforged.neoforge.common.Tags;
import net.neoforged.neoforge.items.IItemHandler;

public class JumboFurnaceBlock
extends Block
implements EntityBlock {
    public static final IntegerProperty X = IntegerProperty.create((String)"x", (int)0, (int)2);
    public static final IntegerProperty Y = IntegerProperty.create((String)"y", (int)0, (int)2);
    public static final IntegerProperty Z = IntegerProperty.create((String)"z", (int)0, (int)2);
    public static final BooleanProperty LIT = BlockStateProperties.LIT;

    public JumboFurnaceBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)X, (Comparable)Integer.valueOf(0))).setValue((Property)Y, (Comparable)Integer.valueOf(0))).setValue((Property)Z, (Comparable)Integer.valueOf(0))).setValue((Property)LIT, (Comparable)Boolean.valueOf(false)));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{X, Y, Z, LIT});
    }

    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return this.isCore(state) ? ((BlockEntityType)JumboFurnace.get().jumboFurnaceCoreBlockEntityType.get()).create(pos, state) : ((BlockEntityType)JumboFurnace.get().jumboFurnaceExteriorBlockEntityType.get()).create(pos, state);
    }

    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        if (player.isShiftKeyDown() && stack.is(Tags.Items.TOOLS_SHEAR)) {
            return ItemInteractionResult.SUCCESS;
        }
        return super.useItemOn(stack, state, level, pos, player, hand, hit);
    }

    public InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hit) {
        BlockPos corePos = JumboFurnaceBlock.getCorePos(state, pos);
        BlockEntity be = level.getBlockEntity(corePos);
        if (be instanceof JumboFurnaceCoreBlockEntity) {
            JumboFurnaceCoreBlockEntity core = (JumboFurnaceCoreBlockEntity)be;
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                serverPlayer.openMenu(JumboFurnaceMenu.getServerMenuProvider(core, pos));
            }
            return InteractionResult.SUCCESS;
        }
        return super.useWithoutItem(state, level, pos, player, hit);
    }

    public void onRemove(BlockState state, Level level, BlockPos pos, BlockState newState, boolean isMoving) {
        if (state.getBlock() != newState.getBlock()) {
            BlockEntity be = level.getBlockEntity(pos);
            if (be instanceof JumboFurnaceCoreBlockEntity) {
                JumboFurnaceCoreBlockEntity core = (JumboFurnaceCoreBlockEntity)be;
                ArrayList<ItemStack> drops = new ArrayList<ItemStack>();
                double x = (double)pos.getX() + 0.5;
                double y = (double)pos.getY() + 0.5;
                double z = (double)pos.getZ() + 0.5;
                float experience = core.output.storedExperience;
                for (int i = 0; i < 9; ++i) {
                    drops.add(core.input.getStackInSlot(i));
                    drops.add(core.fuel.getStackInSlot(i));
                    drops.add(core.output.getStackInSlot(i));
                }
                drops.add(core.multiprocessUpgradeHandler.getStackInSlot(0));
                for (InFlightRecipe inflight : core.inFlightRecipes) {
                    for (ItemStack input : inflight.inputs()) {
                        drops.add(input);
                    }
                }
                for (ItemStack stack : core.backstock) {
                    drops.add(stack);
                }
                for (ItemStack drop : drops) {
                    Containers.dropItemStack((Level)level, (double)x, (double)y, (double)z, (ItemStack)drop);
                }
                Player player = level.getNearestPlayer(x, y, z, 16.0, null);
                if (player != null) {
                    JumboFurnaceOutputSlot.spawnExpOrbs(player, experience);
                }
            }
            if (!isMoving) {
                this.destroyNextBlockPos(level, state, pos);
            }
            super.onRemove(state, level, pos, newState, isMoving);
        }
    }

    public void destroyNextBlockPos(Level level, BlockState state, BlockPos pos) {
        int zIndex;
        int nextZIndex;
        int yIndex;
        int nextYIndex;
        int xIndex;
        int nextXIndex;
        BlockPos nextPos;
        BlockState nextState;
        if (state.hasProperty((Property)X) && state.hasProperty((Property)Y) && state.hasProperty((Property)Z) && (nextState = level.getBlockState(nextPos = pos.offset((nextXIndex = ((xIndex = ((Integer)state.getValue((Property)X)).intValue()) + 1) % 3) - xIndex, (nextYIndex = xIndex == 2 ? (yIndex + 1) % 3 : yIndex) - (yIndex = ((Integer)state.getValue((Property)Y)).intValue()), (nextZIndex = xIndex == 2 && yIndex == 2 ? (zIndex + 1) % 3 : zIndex) - (zIndex = ((Integer)state.getValue((Property)Z)).intValue())))).getBlock() == this) {
            level.destroyBlock(nextPos, true);
        }
    }

    public static BlockPos getCorePos(BlockState exteriorState, BlockPos exteriorPos) {
        int xOff = exteriorState.hasProperty((Property)X) ? 1 - (Integer)exteriorState.getValue((Property)X) : 0;
        int yOff = exteriorState.hasProperty((Property)Y) ? 1 - (Integer)exteriorState.getValue((Property)Y) : 0;
        int zOff = exteriorState.hasProperty((Property)Z) ? 1 - (Integer)exteriorState.getValue((Property)Z) : 0;
        return exteriorPos.offset(xOff, yOff, zOff);
    }

    public boolean isCore(BlockState state) {
        return state.hasProperty((Property)X) && state.hasProperty((Property)Y) && state.hasProperty((Property)Z) && (Integer)state.getValue((Property)X) == 1 && (Integer)state.getValue((Property)Y) == 1 && (Integer)state.getValue((Property)Z) == 1;
    }

    public List<Pair<BlockPos, BlockState>> getStatesForFurnace(BlockPos corePos) {
        ArrayList<Pair<BlockPos, BlockState>> pairs = new ArrayList<Pair<BlockPos, BlockState>>(27);
        for (int x = 0; x < 3; ++x) {
            for (int y = 0; y < 3; ++y) {
                for (int z = 0; z < 3; ++z) {
                    BlockState state = (BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue((Property)X, (Comparable)Integer.valueOf(x))).setValue((Property)Y, (Comparable)Integer.valueOf(y))).setValue((Property)Z, (Comparable)Integer.valueOf(z));
                    BlockPos pos = corePos.offset(x - 1, y - 1, z - 1);
                    pairs.add((Pair<BlockPos, BlockState>)Pair.of((Object)pos, (Object)state));
                }
            }
        }
        return pairs;
    }

    public void animateTick(BlockState state, Level level, BlockPos pos, RandomSource rand) {
        if (((Boolean)state.getValue((Property)LIT)).booleanValue()) {
            Direction direction;
            double x = (double)pos.getX() + 0.5;
            double y = pos.getY();
            double z = (double)pos.getZ() + 0.5;
            if (rand.nextDouble() < 0.1) {
                level.playLocalSound(x, y, z, SoundEvents.FURNACE_FIRE_CRACKLE, SoundSource.BLOCKS, 1.0f, 1.0f, false);
            }
            if ((direction = this.getSmelterHoleDirection(state)) != null) {
                Direction.Axis axis = direction.getAxis();
                double orthagonalOffset = rand.nextDouble() * 0.6 - 0.3;
                double xOff = axis == Direction.Axis.X ? (double)direction.getStepX() * 0.52 : orthagonalOffset;
                double yOff = rand.nextDouble() * 6.0 / 16.0;
                double zOff = axis == Direction.Axis.Z ? (double)direction.getStepZ() * 0.52 : orthagonalOffset;
                level.addParticle((ParticleOptions)ParticleTypes.SMOKE, x + xOff, y + yOff, z + zOff, 0.0, 0.0, 0.0);
                level.addParticle((ParticleOptions)ParticleTypes.FLAME, x + xOff, y + yOff, z + zOff, 0.0, 0.0, 0.0);
            }
        }
    }

    @Nullable
    public Direction getSmelterHoleDirection(BlockState state) {
        if (!(state.hasProperty((Property)X) && state.hasProperty((Property)Y) && state.hasProperty((Property)Z))) {
            return null;
        }
        int y = (Integer)state.getValue((Property)Y);
        if (y != 1) {
            return null;
        }
        int x = (Integer)state.getValue((Property)X);
        int z = (Integer)state.getValue((Property)Z);
        if (x == 1 && z == 0) {
            return Direction.NORTH;
        }
        if (x == 1 && z == 2) {
            return Direction.SOUTH;
        }
        if (x == 0 && z == 1) {
            return Direction.WEST;
        }
        if (x == 2 && z == 1) {
            return Direction.EAST;
        }
        return null;
    }

    @Deprecated
    public boolean hasAnalogOutputSignal(BlockState state) {
        return true;
    }

    @Deprecated
    public int getAnalogOutputSignal(BlockState state, Level level, BlockPos pos) {
        JumboFurnaceCoreBlockEntity core;
        block8: {
            block7: {
                BlockPos corePos = JumboFurnaceBlock.getCorePos(state, pos);
                BlockEntity be = level.getBlockEntity(corePos);
                if (!(be instanceof JumboFurnaceCoreBlockEntity)) break block7;
                core = (JumboFurnaceCoreBlockEntity)be;
                if (state.hasProperty((Property)Y)) break block8;
            }
            return 0;
        }
        int y = (Integer)state.getValue((Property)Y);
        switch (y) {
            case 0: {
                return JumboFurnaceBlock.calcRedstoneFromItemHandler((IItemHandler)core.output);
            }
            case 1: {
                return JumboFurnaceBlock.calcRedstoneFromItemHandler((IItemHandler)core.fuel);
            }
            case 2: {
                return JumboFurnaceBlock.calcRedstoneFromItemHandler((IItemHandler)core.input);
            }
        }
        return 0;
    }

    public static int calcRedstoneFromItemHandler(@Nonnull IItemHandler handler) {
        int nonEmptySlots = 0;
        float totalItemValue = 0.0f;
        int slots = handler.getSlots();
        for (int slot = 0; slot < slots; ++slot) {
            ItemStack itemstack = handler.getStackInSlot(slot);
            if (itemstack.isEmpty()) continue;
            totalItemValue += (float)itemstack.getCount() / (float)Math.min(handler.getSlotLimit(slot), itemstack.getMaxStackSize());
            ++nonEmptySlots;
        }
        float averageItemValue = totalItemValue / (float)slots;
        return Mth.floor((float)(averageItemValue * 14.0f)) + (nonEmptySlots > 0 ? 1 : 0);
    }

    @Deprecated
    public BlockState rotate(BlockState state, Rotation rot) {
        if (state.hasProperty((Property)X) && state.hasProperty((Property)Z)) {
            int x = (Integer)state.getValue((Property)X);
            int z = (Integer)state.getValue((Property)Z);
            switch (rot) {
                case NONE: {
                    return state;
                }
                case CLOCKWISE_90: {
                    return (BlockState)((BlockState)state.setValue((Property)X, (Comparable)Integer.valueOf(2 - z))).setValue((Property)Z, (Comparable)Integer.valueOf(x));
                }
                case CLOCKWISE_180: {
                    return (BlockState)((BlockState)state.setValue((Property)X, (Comparable)Integer.valueOf(2 - x))).setValue((Property)Z, (Comparable)Integer.valueOf(2 - z));
                }
                case COUNTERCLOCKWISE_90: {
                    return (BlockState)((BlockState)state.setValue((Property)X, (Comparable)Integer.valueOf(z))).setValue((Property)Z, (Comparable)Integer.valueOf(2 - x));
                }
            }
            return state;
        }
        return super.rotate(state, rot);
    }

    @Deprecated
    public BlockState mirror(BlockState state, Mirror mirror) {
        if (state.hasProperty((Property)X) && state.hasProperty((Property)Z)) {
            switch (mirror) {
                case NONE: {
                    return state;
                }
                case LEFT_RIGHT: {
                    return (BlockState)state.setValue((Property)Z, (Comparable)Integer.valueOf(2 - (Integer)state.getValue((Property)Z)));
                }
                case FRONT_BACK: {
                    return (BlockState)state.setValue((Property)X, (Comparable)Integer.valueOf(2 - (Integer)state.getValue((Property)X)));
                }
            }
            return state;
        }
        return super.mirror(state, mirror);
    }

    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, BlockState state, BlockEntityType<T> type) {
        return type == JumboFurnace.get().jumboFurnaceCoreBlockEntityType.get() && !level.isClientSide ? JumboFurnaceCoreBlockEntity.SERVER_TICKER : null;
    }
}

