/*
 * Decompiled with CFR 0.152.
 */
package net.commoble.jumbofurnace.client;

import net.commoble.jumbofurnace.JumboFurnace;
import net.commoble.jumbofurnace.jumbo_furnace.JumboFurnaceMenu;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;

public class JumboFurnaceScreen
extends AbstractContainerScreen<JumboFurnaceMenu> {
    public static final ResourceLocation GUI_TEXTURE = JumboFurnace.id("textures/gui/jumbo_furnace.png");
    public static final ResourceLocation LIT_PROGRESS_SPRITE = ResourceLocation.withDefaultNamespace((String)"container/furnace/lit_progress");
    private static final ResourceLocation COOK_PROGRESS_SPRITE = ResourceLocation.withDefaultNamespace((String)"container/furnace/burn_progress");
    public static final int BURN_METER_FROM_X = 176;
    public static final int BURN_METER_FROM_Y = 0;
    public static final int BURN_METER_WIDTH = 13;
    public static final int BURN_METER_HEIGHT = 13;
    public static final int BURN_METER_TO_X = 27;
    public static final int BURN_METER_TO_Y = 73;
    public static final int COOK_METER_WIDTH = 24;
    public static final int COOK_METER_HEIGHT = 16;
    public static final int COOK_METER_TO_X = 79;
    public static final int COOK_METER_TO_Y = 72;

    public JumboFurnaceScreen(JumboFurnaceMenu screenContainer, Inventory inv, Component titleIn) {
        super((AbstractContainerMenu)screenContainer, inv, titleIn);
        this.imageWidth = 176;
        this.imageHeight = 240;
        this.titleLabelX = 8;
        this.titleLabelY = 6;
        this.inventoryLabelX = 8;
        this.inventoryLabelY = this.imageHeight - 94;
    }

    public void render(GuiGraphics graphics, int x, int y, float partialTicks) {
        this.renderBackground(graphics, x, y, partialTicks);
        super.render(graphics, x, y, partialTicks);
        this.renderTooltip(graphics, x, y);
    }

    protected void renderBg(GuiGraphics graphics, float partialTicks, int mouseX, int mouseY) {
        int cookMeterPixels;
        int xStart = (this.width - this.imageWidth) / 2;
        int yStart = (this.height - this.imageHeight) / 2;
        graphics.blit(GUI_TEXTURE, xStart, yStart, 0, 0, this.imageWidth, this.imageHeight);
        if (((JumboFurnaceMenu)this.menu).isBurning()) {
            int burnAmount = ((JumboFurnaceMenu)this.menu).getBurnLeftScaled() + 1;
            graphics.blitSprite(LIT_PROGRESS_SPRITE, 14, 14, 0, 14 - burnAmount, xStart + 27, yStart + 73 + 14 - burnAmount, 14, burnAmount);
        }
        if ((cookMeterPixels = this.getCookMeterPixels(partialTicks)) > 0) {
            graphics.blitSprite(COOK_PROGRESS_SPRITE, 24, 16, 0, 0, xStart + 79, yStart + 72, cookMeterPixels, 16);
        }
        graphics.drawString(Minecraft.getInstance().font, (Component)Component.literal((String)("x" + String.valueOf(((JumboFurnaceMenu)this.menu).getCurrentRecipeCount()))), xStart + 79 + 10, yStart + 72 + 20, 0x373737, false);
    }

    private int getCookMeterPixels(float partialTicks) {
        int recipes = ((JumboFurnaceMenu)this.menu).getCurrentRecipeCount();
        if (recipes <= 0) {
            return 0;
        }
        if (((JumboFurnaceMenu)this.menu).getBurnTimeRemaining() <= 0) {
            return 12;
        }
        long gameTime = (long)((double)Util.getMillis() / 50.0) % 24L;
        return (int)gameTime;
    }
}

