/*
 * Decompiled with CFR 0.152.
 */
package com.unrealdinnerbone.jamd.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import com.unrealdinnerbone.jamd.WorldType;
import com.unrealdinnerbone.jamd.util.OreRegistry;
import java.io.IOException;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.network.chat.Component;

public class JamdCommand {
    private static final DynamicCommandExceptionType INVALID_WORLD_TYPE = new DynamicCommandExceptionType(object -> Component.translatable((String)"commands.jamd.invalid_world_type", (Object[])new Object[]{object}));

    public static void register(CommandDispatcher<CommandSourceStack> commandDispatcher) {
        commandDispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"jamd").requires(commandSourceStack -> commandSourceStack.hasPermission(2))).then(Commands.literal((String)"export").then(Commands.argument((String)"type", (ArgumentType)StringArgumentType.string()).suggests((context, builder) -> SharedSuggestionProvider.suggest(WorldType.TYPES.stream().map(WorldType::getName), (SuggestionsBuilder)builder)).executes(JamdCommand::export)))).then(Commands.literal((String)"reload").executes(JamdCommand::reload)));
    }

    private static int export(CommandContext<CommandSourceStack> stackCommandContext) throws CommandSyntaxException {
        String string = StringArgumentType.getString(stackCommandContext, (String)"type");
        WorldType worldType = WorldType.TYPES.stream().filter(theWorldType -> theWorldType.getName().equalsIgnoreCase(string)).findFirst().orElseThrow(() -> INVALID_WORLD_TYPE.create((Object)string));
        try {
            worldType.export(((CommandSourceStack)stackCommandContext.getSource()).getLevel().getServer());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        ((CommandSourceStack)stackCommandContext.getSource()).sendSuccess(() -> Component.literal((String)"Exported Biomes Data"), true);
        return 1;
    }

    private static int reload(CommandContext<CommandSourceStack> stackCommandContext) throws CommandSyntaxException {
        OreRegistry.REGISTERED_FEATURES.clear();
        ((CommandSourceStack)stackCommandContext.getSource()).sendSuccess(() -> Component.literal((String)"Reloaded Biomes Data"), true);
        return 1;
    }
}

