/*
 * Decompiled with CFR 0.152.
 */
package com.squoshi.irons_spells_js.spell.school;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import dev.latvian.mods.kubejs.generator.KubeDataGenerator;
import dev.latvian.mods.kubejs.registry.BuilderBase;
import dev.latvian.mods.kubejs.script.ConsoleJS;
import dev.latvian.mods.kubejs.typings.Info;
import io.redspace.ironsspellbooks.api.spells.SchoolType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.damagesource.DamageType;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;

public class SchoolTypeJSBuilder
extends BuilderBase<SchoolType> {
    public transient ResourceLocation schoolResource;
    public transient TagKey<Item> schoolFocus;
    public transient List<Item> focusItems = new ArrayList<Item>();
    public transient List<TagKey<Item>> focusTags = new ArrayList<TagKey<Item>>();
    public transient Component name;
    public transient Holder<Attribute> powerAttribute;
    public transient Holder<Attribute> resistanceAttribute;
    public transient Holder<SoundEvent> defaultCastSound;
    public transient ResourceKey<DamageType> damageType;
    public transient boolean requiresLearning = false;
    public transient boolean allowLooting = true;

    public SchoolTypeJSBuilder(ResourceLocation i) {
        super(i);
        this.schoolResource = i;
        this.schoolFocus = ItemTags.create((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)this.schoolResource.getNamespace(), (String)(this.schoolResource.getPath() + "_focus")));
    }

    @Info(value="        Sets the ID of the item tag used for the focus item.\n        \u26a0\ufe0f Default tag is `${mod_id}:${school_name}_focus` \u26a0\ufe0f\ufe0f\n")
    public SchoolTypeJSBuilder setDefaultFocusTag(TagKey<Item> focus) {
        this.schoolFocus = focus;
        return this;
    }

    public SchoolTypeJSBuilder addFocusItems(Item ... items) {
        for (Item item : items) {
            if (Items.AIR == item) {
                ConsoleJS.STARTUP.error((Object)"Tried to add an invalid item to IronSpells School Focus");
                continue;
            }
            this.focusItems.add(item);
        }
        return this;
    }

    @SafeVarargs
    public final SchoolTypeJSBuilder addFocusItemTags(TagKey<Item> ... focusTags) {
        this.focusTags.addAll(Arrays.asList(focusTags));
        return this;
    }

    @Info(value="        Sets the name of the school. It requires a `Component`, which allows custom colors and formatting. You can also use `Text`.\n")
    public SchoolTypeJSBuilder setName(Component name) {
        this.name = name;
        return this;
    }

    @Info(value="        Sets the power attribute of the school. It takes either a String, ResourceLocation, or just an Attribute.\n")
    public SchoolTypeJSBuilder setPowerAttribute(Holder<Attribute> powerAttribute) {
        this.powerAttribute = powerAttribute;
        return this;
    }

    @Info(value="        Sets the resistance attribute of the school. It takes either a String, ResourceLocation, or just an Attribute.\n")
    public SchoolTypeJSBuilder setResistanceAttribute(Holder<Attribute> resistanceAttribute) {
        this.resistanceAttribute = resistanceAttribute;
        return this;
    }

    @Info(value="        Sets the default cast sound of the school. It takes either a String, ResourceLocation, or just a SoundEvent.\n")
    public SchoolTypeJSBuilder setDefaultCastSound(Holder<SoundEvent> defaultCastSound) {
        this.defaultCastSound = defaultCastSound;
        return this;
    }

    @Info(value="        Sets the damage type of the school. It takes either a String, ResourceLocation, or just a DamageType.\n        Damage types can be created using datapacks or server scripts, or you can use an existing damage type.\n")
    public SchoolTypeJSBuilder setDamageType(ResourceKey<DamageType> damageType) {
        this.damageType = damageType;
        return this;
    }

    @Info(value="        Sets require learning to true.\n")
    public SchoolTypeJSBuilder requiresLearning() {
        this.requiresLearning = true;
        return this;
    }

    @Info(value="        Disables looting.\n")
    public SchoolTypeJSBuilder disableLooting() {
        this.allowLooting = false;
        return this;
    }

    public SchoolType createObject() {
        return new SchoolType(this.schoolResource, this.schoolFocus, this.name, this.powerAttribute, this.resistanceAttribute, this.defaultCastSound, this.damageType, this.requiresLearning, this.allowLooting);
    }

    public void generateData(KubeDataGenerator generator) {
        JsonObject focusJson = new JsonObject();
        focusJson.addProperty("replace", Boolean.valueOf(false));
        JsonArray focusArray = new JsonArray();
        JsonObject tagObj = new JsonObject();
        tagObj.addProperty("id", "#" + String.valueOf(this.schoolFocus.location()));
        tagObj.addProperty("required", Boolean.valueOf(false));
        focusArray.add((JsonElement)tagObj);
        ResourceLocation target = ResourceLocation.parse((String)"irons_spellbooks:tags/item/school_focus");
        focusJson.add("values", (JsonElement)focusArray);
        generator.json(target, (JsonElement)focusJson);
        focusJson = new JsonObject();
        focusJson.addProperty("replace", Boolean.valueOf(false));
        focusArray = new JsonArray();
        if (!this.focusTags.isEmpty()) {
            for (TagKey<Item> tag : this.focusTags) {
                focusArray.add("#" + String.valueOf(tag.location()));
            }
        }
        if (!this.focusItems.isEmpty()) {
            for (Item item : this.focusItems) {
                focusArray.add(Objects.requireNonNull(BuiltInRegistries.ITEM.getKey((Object)item)).toString());
            }
        }
        focusJson.add("values", (JsonElement)focusArray);
        target = ResourceLocation.parse((String)(this.schoolFocus.location().getNamespace() + ":tags/item/" + this.schoolFocus.location().getPath()));
        generator.json(target, (JsonElement)focusJson);
    }
}

