/*
 * Decompiled with CFR 0.152.
 */
package com.squoshi.irons_spells_js.mixin;

import com.google.common.collect.Maps;
import io.redspace.ironsspellbooks.IronsSpellbooks;
import io.redspace.ironsspellbooks.api.entity.IMagicEntity;
import io.redspace.ironsspellbooks.api.magic.MagicData;
import io.redspace.ironsspellbooks.api.magic.SpellSelectionManager;
import io.redspace.ironsspellbooks.api.registry.SpellRegistry;
import io.redspace.ironsspellbooks.api.spells.AbstractSpell;
import io.redspace.ironsspellbooks.api.spells.CastSource;
import io.redspace.ironsspellbooks.api.spells.CastType;
import io.redspace.ironsspellbooks.api.spells.ICastData;
import io.redspace.ironsspellbooks.api.spells.SpellData;
import io.redspace.ironsspellbooks.api.util.Utils;
import io.redspace.ironsspellbooks.capabilities.magic.SyncedSpellData;
import io.redspace.ironsspellbooks.entity.mobs.abstract_spell_casting_mob.AbstractSpellCastingMob;
import io.redspace.ironsspellbooks.spells.ender.TeleportSpell;
import io.redspace.ironsspellbooks.spells.fire.BurningDashSpell;
import java.util.HashMap;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.LookControl;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={PathfinderMob.class})
public class PathfinderMobMixin
extends Mob
implements IMagicEntity {
    private boolean recreateSpell;
    @Unique
    private static final EntityDataAccessor<Boolean> DATA_CANCEL_CAST = SynchedEntityData.defineId(PathfinderMob.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    @Unique
    private static final EntityDataAccessor<Boolean> DATA_DRINKING_POTION = SynchedEntityData.defineId(PathfinderMob.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    @Unique
    private final MagicData playerMagicData = new MagicData(true);
    @Unique
    private static final AttributeModifier SPEED_MODIFIER_DRINKING = new AttributeModifier(IronsSpellbooks.id((String)"potion_slowdown"), -0.15, AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL);
    @Unique
    @Nullable
    public SpellData castingSpell;
    @Unique
    public final HashMap<String, AbstractSpell> spells = Maps.newHashMap();
    @Unique
    public int drinkTime;
    @Unique
    public boolean hasUsedSingleAttack;

    protected PathfinderMobMixin(EntityType<? extends Mob> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
    }

    public PathfinderMob self() {
        return (PathfinderMob)this;
    }

    @Inject(method={"<init>"}, at={@At(value="RETURN")}, remap=false)
    public void init(EntityType<? extends PathfinderMob> entityType, Level level, CallbackInfo ci) {
        if (!(this.self() instanceof AbstractSpellCastingMob)) {
            this.playerMagicData.setSyncedData(new SyncedSpellData((LivingEntity)this.self()));
            this.lookControl = this.createLookControl();
        }
    }

    @Unique
    private LookControl createLookControl() {
        return new LookControl(this){

            protected boolean resetXRotOnTick() {
                return PathfinderMobMixin.this.getTarget() == null;
            }
        };
    }

    protected void defineSynchedData(SynchedEntityData.Builder pBuilder) {
        super.defineSynchedData(pBuilder);
        pBuilder.define(DATA_CANCEL_CAST, (Object)false);
        pBuilder.define(DATA_DRINKING_POTION, (Object)false);
    }

    public MagicData getMagicData() {
        return this.playerMagicData;
    }

    public boolean isDrinkingPotion() {
        return (Boolean)this.entityData.get(DATA_DRINKING_POTION);
    }

    public void setDrinkingPotion(boolean drinkingPotion) {
        this.entityData.set(DATA_DRINKING_POTION, (Object)drinkingPotion);
    }

    public void startDrinkingPotion() {
        if (!this.level().isClientSide) {
            this.setDrinkingPotion(true);
            this.drinkTime = 35;
            AttributeInstance attributeinstance = this.getAttribute(Attributes.MOVEMENT_SPEED);
            attributeinstance.removeModifier(SPEED_MODIFIER_DRINKING);
            attributeinstance.addTransientModifier(SPEED_MODIFIER_DRINKING);
        }
    }

    private void finishDrinkingPotion() {
        this.setDrinkingPotion(false);
        this.heal(Math.min(Math.max(10.0f, this.getMaxHealth() / 10.0f), this.getMaxHealth() / 4.0f));
        this.getAttribute(Attributes.MOVEMENT_SPEED).removeModifier(SPEED_MODIFIER_DRINKING);
        if (this.isSilent()) {
            this.level().playSound((Player)null, this.getX(), this.getY(), this.getZ(), SoundEvents.WITCH_DRINK, this.getSoundSource(), 1.0f, 0.8f + this.random.nextFloat() * 0.4f);
        }
    }

    public void onSyncedDataUpdated(EntityDataAccessor<?> pKey) {
        super.onSyncedDataUpdated(pKey);
        if (!this.level().isClientSide) {
            return;
        }
        if (pKey.id() == DATA_CANCEL_CAST.id()) {
            IronsSpellbooks.LOGGER.debug("ASCM.onSyncedDataUpdated.1 this.isCasting:{}, playerMagicData.isCasting:{} isClient:{}", new Object[]{this.isCasting(), this.playerMagicData == null ? "null" : Boolean.valueOf(this.playerMagicData.isCasting()), this.level().isClientSide()});
            this.cancelCast();
        }
    }

    public void addAdditionalSaveData(CompoundTag pCompound) {
        super.addAdditionalSaveData(pCompound);
        if (!(this.self() instanceof AbstractSpellCastingMob)) {
            this.playerMagicData.getSyncedData().saveNBTData(pCompound, (HolderLookup.Provider)this.level().registryAccess());
            pCompound.putBoolean("usedSpecial", this.hasUsedSingleAttack);
        }
    }

    public void readAdditionalSaveData(CompoundTag pCompound) {
        super.readAdditionalSaveData(pCompound);
        if (!(this.self() instanceof AbstractSpellCastingMob)) {
            SyncedSpellData syncedSpellData = new SyncedSpellData((LivingEntity)this);
            syncedSpellData.loadNBTData(pCompound, (HolderLookup.Provider)this.level().registryAccess());
            if (syncedSpellData.isCasting()) {
                this.recreateSpell = true;
            }
            this.playerMagicData.setSyncedData(syncedSpellData);
            this.hasUsedSingleAttack = pCompound.getBoolean("usedSpecial");
        }
    }

    public void cancelCast() {
        if (this.isCasting()) {
            if (!this.level().isClientSide) {
                this.entityData.set(DATA_CANCEL_CAST, (Object)((Boolean)this.entityData.get(DATA_CANCEL_CAST) == false ? 1 : 0));
            }
            this.castComplete();
        }
    }

    public void castComplete() {
        if (!this.level().isClientSide) {
            if (this.castingSpell != null) {
                this.castingSpell.getSpell().onServerCastComplete(this.level(), this.castingSpell.getLevel(), (LivingEntity)this.self(), this.playerMagicData, false);
            }
        } else {
            this.playerMagicData.resetCastingState();
        }
        this.castingSpell = null;
    }

    public void setSyncedSpellData(SyncedSpellData syncedSpellData) {
        if (this.level().isClientSide) {
            boolean isCasting = this.playerMagicData.isCasting();
            this.playerMagicData.setSyncedData(syncedSpellData);
            this.castingSpell = this.playerMagicData.getCastingSpell();
            if (this.castingSpell != null) {
                if (!this.playerMagicData.isCasting() && isCasting) {
                    this.castComplete();
                } else if (this.playerMagicData.isCasting() && !isCasting) {
                    AbstractSpell spell = this.playerMagicData.getCastingSpell().getSpell();
                    this.initiateCastSpell(spell, this.playerMagicData.getCastingSpellLevel());
                    if (this.castingSpell.getSpell().getCastType() == CastType.INSTANT) {
                        this.castingSpell.getSpell().onClientPreCast(this.level(), this.castingSpell.getLevel(), (LivingEntity)this.self(), InteractionHand.MAIN_HAND, this.playerMagicData);
                        this.castComplete();
                    }
                }
            }
        }
    }

    protected void customServerAiStep() {
        super.customServerAiStep();
        if (this.recreateSpell) {
            this.recreateSpell = false;
            SyncedSpellData syncedSpellData = this.playerMagicData.getSyncedData();
            AbstractSpell spell = SpellRegistry.getSpell((String)syncedSpellData.getCastingSpellId());
            this.initiateCastSpell(spell, syncedSpellData.getCastingSpellLevel());
        }
        if (this.isDrinkingPotion()) {
            if (this.drinkTime-- <= 0) {
                this.finishDrinkingPotion();
            } else if (this.drinkTime % 4 == 0 && !this.isSilent()) {
                this.level().playSound(null, this.getX(), this.getY(), this.getZ(), SoundEvents.GENERIC_DRINK, this.getSoundSource(), 1.0f, Utils.random.nextFloat() * 0.1f + 0.9f);
            }
        }
        if (this.castingSpell == null) {
            return;
        }
        this.playerMagicData.handleCastDuration();
        if (this.playerMagicData.isCasting()) {
            this.castingSpell.getSpell().onServerCastTick(this.level(), this.castingSpell.getLevel(), (LivingEntity)this, this.playerMagicData);
        }
        IronsSpellbooks.LOGGER.debug("ASCM.customServerAiStep.1");
        this.forceLookAtTarget(this.getTarget());
        if (this.playerMagicData.getCastDurationRemaining() <= 0) {
            IronsSpellbooks.LOGGER.debug("ASCM.customServerAiStep.2");
            if (this.castingSpell.getSpell().getCastType() == CastType.LONG || this.castingSpell.getSpell().getCastType() == CastType.INSTANT) {
                IronsSpellbooks.LOGGER.debug("ASCM.customServerAiStep.3");
                this.castingSpell.getSpell().onCast(this.level(), this.castingSpell.getLevel(), (LivingEntity)this, CastSource.MOB, this.playerMagicData);
            }
            this.castComplete();
        } else if (this.castingSpell.getSpell().getCastType() == CastType.CONTINUOUS && (this.playerMagicData.getCastDurationRemaining() + 1) % 10 == 0) {
            this.castingSpell.getSpell().onCast(this.level(), this.castingSpell.getLevel(), (LivingEntity)this, CastSource.MOB, this.playerMagicData);
        }
    }

    public void initiateCastSpell(AbstractSpell spell, int spellLevel) {
        if (spell == SpellRegistry.none()) {
            this.castingSpell = null;
        } else {
            this.castingSpell = new SpellData(spell, spellLevel);
            if (this.getTarget() != null) {
                this.forceLookAtTarget(this.getTarget());
            }
            if (!this.level().isClientSide && !this.castingSpell.getSpell().checkPreCastConditions(this.level(), spellLevel, (LivingEntity)this.self(), this.playerMagicData)) {
                this.castingSpell = null;
            } else {
                if (spell != SpellRegistry.TELEPORT_SPELL.get() && spell != SpellRegistry.FROST_STEP_SPELL.get()) {
                    if (spell == SpellRegistry.BLOOD_STEP_SPELL.get()) {
                        this.setTeleportLocationBehindTarget(3);
                    } else if (spell == SpellRegistry.BURNING_DASH_SPELL.get()) {
                        this.setBurningDashDirectionData();
                    }
                } else {
                    this.setTeleportLocationBehindTarget(10);
                }
                this.playerMagicData.initiateCast(this.castingSpell.getSpell(), this.castingSpell.getLevel(), this.castingSpell.getSpell().getEffectiveCastTime(this.castingSpell.getLevel(), (LivingEntity)this.self()), CastSource.MOB, SpellSelectionManager.MAINHAND);
                if (!this.level().isClientSide) {
                    this.castingSpell.getSpell().onServerPreCast(this.level(), this.castingSpell.getLevel(), (LivingEntity)this.self(), this.playerMagicData);
                }
            }
        }
    }

    public void notifyDangerousProjectile(Projectile projectile) {
    }

    public boolean isCasting() {
        return this.playerMagicData.isCasting();
    }

    public boolean setTeleportLocationBehindTarget(int distance) {
        LivingEntity target = this.getTarget();
        boolean valid = false;
        if (target != null) {
            Vec3 rotation = target.getLookAngle().normalize().scale((double)(-distance));
            Vec3 pos = target.position();
            Vec3 teleportPos = rotation.add(pos);
            for (int i = 0; i < 24; ++i) {
                Vec3 randomness = Utils.getRandomVec3((double)(0.15f * (float)i)).multiply(1.0, 0.0, 1.0);
                teleportPos = Utils.moveToRelativeGroundLevel((Level)this.level(), (Vec3)target.position().subtract(new Vec3(0.0, 0.0, (double)((float)distance / (float)(i / 7 + 1))).yRot(-(target.getYRot() + (float)(i * 45)) * ((float)Math.PI / 180))).add(randomness), (int)5);
                teleportPos = new Vec3(teleportPos.x, teleportPos.y + (double)0.1f, teleportPos.z);
                AABB reposBB = this.getBoundingBox().move(teleportPos.subtract(this.position()));
                if (this.level().collidesWithSuffocatingBlock((Entity)this.self(), reposBB.inflate((double)-0.05f))) continue;
                valid = true;
                break;
            }
            if (valid) {
                this.playerMagicData.setAdditionalCastData((ICastData)new TeleportSpell.TeleportData(teleportPos));
            } else {
                this.playerMagicData.setAdditionalCastData((ICastData)new TeleportSpell.TeleportData(this.position()));
            }
        } else {
            this.playerMagicData.setAdditionalCastData((ICastData)new TeleportSpell.TeleportData(this.position()));
        }
        return valid;
    }

    public void setBurningDashDirectionData() {
        this.playerMagicData.setAdditionalCastData((ICastData)new BurningDashSpell.BurningDashDirectionOverrideCastData());
    }

    private void forceLookAtTarget(LivingEntity target) {
        if (target != null) {
            double d0 = target.getX() - this.getX();
            double d2 = target.getZ() - this.getZ();
            double d1 = target.getEyeY() - this.getEyeY();
            double d3 = Math.sqrt(d0 * d0 + d2 * d2);
            float f = (float)(Mth.atan2((double)d2, (double)d0) * 57.2957763671875) - 90.0f;
            float f1 = (float)(-(Mth.atan2((double)d1, (double)d3) * 57.2957763671875));
            this.setXRot(f1 % 360.0f);
            this.setYRot(f % 360.0f);
        }
    }

    public boolean getHasUsedSingleAttack() {
        return this.hasUsedSingleAttack;
    }

    public void setHasUsedSingleAttack(boolean hasUsedSingleAttack) {
        this.hasUsedSingleAttack = hasUsedSingleAttack;
    }
}

