/*
 * Decompiled with CFR 0.152.
 */
package com.squoshi.irons_spells_js.item;

import dev.latvian.mods.kubejs.item.ItemBuilder;
import dev.latvian.mods.rhino.util.HideFromJS;
import io.redspace.ironsspellbooks.api.item.weapons.ExtendedSwordItem;
import io.redspace.ironsspellbooks.api.item.weapons.MagicSwordItem;
import io.redspace.ironsspellbooks.api.registry.SpellDataRegistryHolder;
import io.redspace.ironsspellbooks.api.spells.AbstractSpell;
import io.redspace.ironsspellbooks.item.weapons.AttributeContainer;
import io.redspace.ironsspellbooks.item.weapons.ExtendedWeaponTier;
import io.redspace.ironsspellbooks.item.weapons.IronsWeaponTier;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import org.jetbrains.annotations.Nullable;

public class CustomMagicSwordItem
extends MagicSwordItem {
    public CustomMagicSwordItem(Builder b) {
        super((Tier)b.tier.build(), b.createItemProperties().attributes(ExtendedSwordItem.createAttributes((IronsWeaponTier)b.tier.build())), b.spellDataRegistryHolders.toArray(new SpellDataRegistryHolder[0]));
    }

    public static class Builder
    extends ItemBuilder {
        private final TierBuilder tier = new TierBuilder();
        private final Item.Properties properties = new Item.Properties();
        private final List<SpellDataRegistryHolder> spellDataRegistryHolders = new ArrayList<SpellDataRegistryHolder>();

        public Builder(ResourceLocation id) {
            super(id);
        }

        public Builder setTier(Consumer<TierBuilder> callback) {
            callback.accept(this.tier);
            return this;
        }

        public Builder addSpell(Holder<AbstractSpell> spell, int level) {
            this.spellDataRegistryHolders.add(new SpellDataRegistryHolder((Supplier)spell, level));
            return this;
        }

        public CustomMagicSwordItem createObject() {
            return new CustomMagicSwordItem(this);
        }
    }

    public static class TierBuilder {
        private final List<AttributeContainer> attributes = new ArrayList<AttributeContainer>();
        private ExtendedWeaponTierEnum existingTier = null;
        private boolean mergeAttributes = false;
        private Integer uses;
        private Float damage;
        private Float speed;
        private Integer enchantmentValue;
        private TagKey<Block> incorrectBlocksForDrops;
        private Supplier<Ingredient> repairIngredient;
        private ExtendedWeaponTier tier;

        private static <A, B> A weirdFunction(@Nullable A receivingVar, @Nullable B optional, Function<B, A> getIfTrue, A defaultValue) {
            return receivingVar == null ? (optional != null ? getIfTrue.apply(optional) : defaultValue) : receivingVar;
        }

        public TierBuilder useBaseTier(ExtendedWeaponTierEnum tier, boolean mergeAttributes) {
            this.existingTier = tier;
            this.mergeAttributes = mergeAttributes;
            return this;
        }

        public TierBuilder setUses(int uses) {
            this.uses = uses;
            return this;
        }

        public TierBuilder setDamage(float damage) {
            this.damage = Float.valueOf(damage);
            return this;
        }

        public TierBuilder setSpeed(float speed) {
            this.speed = Float.valueOf(speed);
            return this;
        }

        public TierBuilder setEnchantmentValue(int enchantmentValue) {
            this.enchantmentValue = enchantmentValue;
            return this;
        }

        public TierBuilder setIncorrectBlocksForDrops(TagKey<Block> incorrectBlocksForDrops) {
            this.incorrectBlocksForDrops = incorrectBlocksForDrops;
            return this;
        }

        public TierBuilder setRepairIngredient(Supplier<Ingredient> repairIngredient) {
            this.repairIngredient = repairIngredient;
            return this;
        }

        public TierBuilder addAttribute(Holder<Attribute> attribute, double value, AttributeModifier.Operation operation) {
            this.attributes.add(new AttributeContainer(attribute, value, operation));
            return this;
        }

        @HideFromJS
        private ExtendedWeaponTier build() {
            if (this.tier == null) {
                if (this.existingTier != null && this.mergeAttributes) {
                    this.attributes.addAll(List.of(this.existingTier.tier.getAdditionalAttributes()));
                }
                this.uses = TierBuilder.weirdFunction(this.uses, this.existingTier, t -> t.tier.getUses(), 1000);
                this.damage = (Float)((Object)TierBuilder.weirdFunction(this.damage, this.existingTier, t -> Float.valueOf(t.tier.getAttackDamageBonus()), 6));
                this.speed = (Float)((Object)TierBuilder.weirdFunction(this.speed, this.existingTier, t -> Float.valueOf(t.tier.getSpeed()), -3));
                this.enchantmentValue = TierBuilder.weirdFunction(this.enchantmentValue, this.existingTier, t -> t.tier.getEnchantmentValue(), 4);
                this.incorrectBlocksForDrops = TierBuilder.weirdFunction(this.incorrectBlocksForDrops, this.existingTier, t -> t.tier.getIncorrectBlocksForDrops(), BlockTags.INCORRECT_FOR_IRON_TOOL);
                this.repairIngredient = TierBuilder.weirdFunction(this.repairIngredient, this.existingTier, t -> () -> ((ExtendedWeaponTier)t.tier).getRepairIngredient(), () -> Ingredient.of((ItemLike[])new ItemLike[]{Items.IRON_INGOT}));
                this.tier = new ExtendedWeaponTier(this.uses.intValue(), this.damage.floatValue(), this.speed.floatValue(), this.enchantmentValue.intValue(), this.incorrectBlocksForDrops, this.repairIngredient, this.attributes.toArray(new AttributeContainer[0]));
            }
            return this.tier;
        }

        public static enum ExtendedWeaponTierEnum {
            HELLRAZOR(ExtendedWeaponTier.HELLRAZOR),
            LEGIONNAIRE_FLAMBERGE(ExtendedWeaponTier.LEGIONNAIRE_FLAMBERGE),
            DECREPIT_FLAMBERGE(ExtendedWeaponTier.DECREPIT_FLAMBERGE),
            DECREPIT_SCYTHE(ExtendedWeaponTier.DECREPIT_SCYTHE),
            DREADSWORD(ExtendedWeaponTier.DREADSWORD),
            MISERY(ExtendedWeaponTier.MISERY),
            METAL_MAGEHUNTER(ExtendedWeaponTier.METAL_MAGEHUNTER),
            CRYSTAL_MAGEHUNTER(ExtendedWeaponTier.CRYSTAL_MAGEHUNTER),
            SPELLBREAKER(ExtendedWeaponTier.SPELLBREAKER),
            TRUTHSEEKER(ExtendedWeaponTier.TRUTHSEEKER),
            CLAYMORE(ExtendedWeaponTier.CLAYMORE),
            AMETHYST_RAPIER(ExtendedWeaponTier.AMETHYST_RAPIER);

            private final ExtendedWeaponTier tier;

            private ExtendedWeaponTierEnum(ExtendedWeaponTier tier) {
                this.tier = tier;
            }
        }
    }
}

