/*
 * Decompiled with CFR 0.152.
 */
package io.redspace.ironsspellbooks.particle;

import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.core.particles.SimpleParticleType;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

public class AcidParticle
extends TextureSheetParticle {
    private final SpriteSet sprites;

    public AcidParticle(ClientLevel level, double xCoord, double yCoord, double zCoord, SpriteSet spriteSet, double xd, double yd, double zd) {
        super(level, xCoord, yCoord, zCoord, xd, yd, zd);
        this.xd = xd;
        this.yd = yd;
        this.zd = zd;
        this.quadSize *= 1.0f;
        this.scale(1.15f);
        this.lifetime = 5 + (int)(Math.random() * 25.0);
        this.sprites = spriteSet;
        this.gravity = 0.35f;
        this.setSpriteFromAge(spriteSet);
        float f = this.random.nextFloat() * 0.3f + 0.7f;
        this.rCol = 0.41f * f;
        this.gCol = 0.88f * f;
        this.bCol = 0.22f * f;
    }

    public void tick() {
        super.tick();
        this.setSpriteFromAge(this.sprites);
    }

    public ParticleRenderType getRenderType() {
        return ParticleRenderType.PARTICLE_SHEET_OPAQUE;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class Provider
    implements ParticleProvider<SimpleParticleType> {
        private final SpriteSet sprites;

        public Provider(SpriteSet spriteSet) {
            this.sprites = spriteSet;
        }

        public Particle createParticle(SimpleParticleType particleType, ClientLevel level, double x, double y, double z, double dx, double dy, double dz) {
            return new AcidParticle(level, x, y, z, this.sprites, dx, dy, dz);
        }
    }
}

