/*
 * Decompiled with CFR 0.152.
 */
package io.redspace.ironsspellbooks.mixin;

import io.redspace.ironsspellbooks.item.ILecternPlaceable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.LecternBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={LecternBlockEntity.class})
public abstract class LecternBlockEntityMixin
extends BlockEntity {
    @Shadow
    ItemStack book;
    @Shadow
    private int page;

    public LecternBlockEntityMixin(BlockEntityType<?> pType, BlockPos pPos, BlockState pBlockState) {
        super(pType, pPos, pBlockState);
    }

    @Inject(method={"hasBook"}, remap=false, at={@At(value="HEAD")}, cancellable=true)
    private void fudgeLecternValidity(CallbackInfoReturnable<Boolean> cir) {
        if (this.book.getItem() instanceof ILecternPlaceable) {
            cir.setReturnValue((Object)true);
        }
    }

    @Inject(method={"getPageCount"}, remap=false, at={@At(value="HEAD")}, cancellable=true)
    private static void getPageCount(ItemStack pStack, CallbackInfoReturnable<Integer> cir) {
        Item item = pStack.getItem();
        if (item instanceof ILecternPlaceable) {
            ILecternPlaceable lecternPlaceable = (ILecternPlaceable)item;
            cir.setReturnValue((Object)lecternPlaceable.getPages(pStack).size());
        }
    }

    public void setChanged() {
        super.setChanged();
        if (this.level != null) {
            this.level.sendBlockUpdated(this.worldPosition, this.getBlockState(), this.getBlockState(), 2);
        }
    }

    public Packet<ClientGamePacketListener> getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider pRegistries) {
        return this.saveWithoutMetadata(pRegistries);
    }
}

