/*
 * Decompiled with CFR 0.152.
 */
package io.redspace.ironsjewelry.loot;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.redspace.ironsjewelry.core.data.JewelryData;
import io.redspace.ironsjewelry.core.data.JewelryType;
import io.redspace.ironsjewelry.core.data.MaterialDefinition;
import io.redspace.ironsjewelry.core.data.PartDefinition;
import io.redspace.ironsjewelry.core.data.PartIngredient;
import io.redspace.ironsjewelry.core.data.PatternDefinition;
import io.redspace.ironsjewelry.registry.ComponentRegistry;
import io.redspace.ironsjewelry.registry.IronsJewelryRegistries;
import io.redspace.ironsjewelry.registry.LootRegistry;
import io.redspace.ironsjewelry.utils.JewelryModTags;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.TreeMap;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryCodecs;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionType;

public record GenerateJewelryLootFunction(HolderSet<PatternDefinition> patternSource, Optional<Map<String, HolderSet<MaterialDefinition>>> materialFilter) implements LootItemFunction
{
    public static MapCodec<GenerateJewelryLootFunction> CODEC = RecordCodecBuilder.mapCodec(builder -> builder.group((App)RegistryCodecs.homogeneousList(IronsJewelryRegistries.Keys.PATTERN_REGISTRY_KEY).fieldOf("patterns").forGetter(GenerateJewelryLootFunction::patternSource), (App)Codec.unboundedMap((Codec)Codec.STRING, (Codec)RegistryCodecs.homogeneousList(IronsJewelryRegistries.Keys.MATERIAL_REGISTRY_KEY)).optionalFieldOf("materials").forGetter(GenerateJewelryLootFunction::materialFilter)).apply((Applicative)builder, GenerateJewelryLootFunction::new));

    public LootItemFunctionType<? extends LootItemFunction> getType() {
        return LootRegistry.GENERATE_JEWELRY.get();
    }

    public ItemStack apply(ItemStack stack, LootContext lootContext) {
        TreeMap<Integer, Holder> weightedPatterns = new TreeMap<Integer, Holder>();
        Optional<JewelryType> typeOpt = IronsJewelryRegistries.JEWELRY_TYPE_REGISTRY.stream().filter(jewelryType -> ((Item)jewelryType.item().value()).equals(stack.getItem())).findFirst();
        if (typeOpt.isEmpty()) {
            return ItemStack.EMPTY;
        }
        int total = 0;
        for (int i = 0; i < this.patternSource.size(); ++i) {
            Holder pattern = this.patternSource.get(i);
            if (!((PatternDefinition)pattern.value()).jewelryType().equals(typeOpt.get())) continue;
            weightedPatterns.put(total, pattern);
            total += (int)(100.0 / (1.0 + ((PatternDefinition)pattern.value()).qualityMultiplier()));
        }
        if (!weightedPatterns.isEmpty()) {
            Holder pattern = (Holder)weightedPatterns.lowerEntry(lootContext.getRandom().nextInt(total) + 1).getValue();
            HashMap<Holder<PartDefinition>, Holder<MaterialDefinition>> materials = new HashMap<Holder<PartDefinition>, Holder<MaterialDefinition>>();
            Registry<MaterialDefinition> registry = IronsJewelryRegistries.materialRegistry(lootContext.getLevel().registryAccess());
            List<MaterialDefinition> allMaterials = registry.stream().filter(material -> !material.ingredient().hasNoItems() && (!registry.wrapAsHolder(material).is(JewelryModTags.JEWELRY_LOOT_MATERIAL_BLACKLIST) || !this.materialFilter.isEmpty())).toList();
            for (PartIngredient part : ((PatternDefinition)pattern.value()).partTemplate()) {
                List<MaterialDefinition> applicableMaterials = allMaterials.stream().filter(material -> ((PartDefinition)part.part().value()).canUseMaterial(material.materialType()) && (this.materialFilter.isEmpty() || material.materialType().stream().anyMatch(type -> !this.materialFilter.get().containsKey(type) || this.materialFilter.get().get(type).contains(registry.wrapAsHolder(material))))).toList();
                if (applicableMaterials.isEmpty()) continue;
                materials.put(part.part(), (Holder<MaterialDefinition>)registry.wrapAsHolder((Object)GenerateJewelryLootFunction.getRandomWeightedMaterial(applicableMaterials, lootContext.getRandom())));
            }
            JewelryData jewelryData = new JewelryData((Holder<PatternDefinition>)pattern, materials);
            if (jewelryData.isValid()) {
                stack.set(ComponentRegistry.JEWELRY_COMPONENT, (Object)jewelryData);
                return stack;
            }
        }
        return ItemStack.EMPTY;
    }

    private static MaterialDefinition getRandomWeightedMaterial(List<MaterialDefinition> applicableMaterials, RandomSource randomSource) {
        TreeMap<Integer, MaterialDefinition> weightedMaterials = new TreeMap<Integer, MaterialDefinition>();
        int total = 0;
        for (MaterialDefinition material : applicableMaterials) {
            weightedMaterials.put(total, material);
            total += (int)(100.0 / (1.0 + material.quality()));
        }
        return (MaterialDefinition)weightedMaterials.lowerEntry(randomSource.nextInt(total) + 1).getValue();
    }

    public static class Builder
    implements LootItemFunction.Builder {
        List<Holder<PatternDefinition>> patterns = new ArrayList<Holder<PatternDefinition>>();
        Map<String, HolderSet<MaterialDefinition>> materials = new HashMap<String, HolderSet<MaterialDefinition>>();
        HolderSet<PatternDefinition> holderSet = null;

        public Builder withMaterial(String name, HolderSet<MaterialDefinition> materials) {
            this.materials.put(name, materials);
            return this;
        }

        public Builder withPatterns(HolderSet<PatternDefinition> patterns) {
            this.holderSet = patterns;
            return this;
        }

        public Builder withPattern(Holder<PatternDefinition> pattern) {
            this.patterns.add(pattern);
            return this;
        }

        public LootItemFunction build() {
            Optional<Map<String, HolderSet<MaterialDefinition>>> materialOpt;
            Optional<Map<String, HolderSet<MaterialDefinition>>> optional = materialOpt = this.materials.isEmpty() ? Optional.empty() : Optional.of(this.materials);
            if (this.holderSet != null) {
                return new GenerateJewelryLootFunction(this.holderSet, materialOpt);
            }
            return new GenerateJewelryLootFunction((HolderSet<PatternDefinition>)new HolderSet.Direct(this.patterns), materialOpt);
        }
    }
}

