/*
 * Decompiled with CFR 0.152.
 */
package io.redspace.ironsjewelry.core.parameters;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.redspace.ironsjewelry.core.data.AttributeInstance;
import io.redspace.ironsjewelry.core.parameters.IBonusParameterType;
import java.util.Optional;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.component.ItemAttributeModifiers;

public class AttributeParameter
implements IBonusParameterType<AttributeInstance> {
    public static final Codec<AttributeInstance> CODEC = RecordCodecBuilder.create(p_349989_ -> p_349989_.group((App)BuiltInRegistries.ATTRIBUTE.holderByNameCodec().fieldOf("attribute").forGetter(AttributeInstance::attribute), (App)Codec.DOUBLE.fieldOf("amount").forGetter(AttributeInstance::amount), (App)AttributeModifier.Operation.CODEC.fieldOf("operation").forGetter(AttributeInstance::operation)).apply((Applicative)p_349989_, AttributeInstance::new));

    @Override
    public Codec<AttributeInstance> codec() {
        return CODEC;
    }

    @Override
    public Optional<String> getValueDescriptionId(AttributeInstance value) {
        return Optional.of(((Attribute)value.attribute().value()).getDescriptionId());
    }

    @Override
    public Optional<Component> getSimpleDescription(AttributeInstance value) {
        Holder<Attribute> attribute = value.attribute();
        double d0 = value.amount();
        double d1 = value.operation() == AttributeModifier.Operation.ADD_MULTIPLIED_BASE || value.operation() == AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL ? d0 * 100.0 : (attribute.is(Attributes.KNOCKBACK_RESISTANCE) ? d0 * 10.0 : d0);
        if (d0 >= 0.0) {
            return Optional.of(Component.translatable((String)("attribute.modifier.plus." + value.operation().id()), (Object[])new Object[]{ItemAttributeModifiers.ATTRIBUTE_MODIFIER_FORMAT.format(d1), Component.translatable((String)((Attribute)attribute.value()).getDescriptionId())}));
        }
        return Optional.of(Component.translatable((String)("attribute.modifier.take." + value.operation().id()), (Object[])new Object[]{ItemAttributeModifiers.ATTRIBUTE_MODIFIER_FORMAT.format(-d1), Component.translatable((String)((Attribute)attribute.value()).getDescriptionId())}));
    }
}

