/*
 * Decompiled with CFR 0.152.
 */
package io.redspace.ironsjewelry.core.actions;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.redspace.ironsjewelry.core.actions.IAction;
import io.redspace.ironsjewelry.core.data.BonusInstance;
import io.redspace.ironsjewelry.core.data.QualityScalar;
import io.redspace.ironsjewelry.utils.Utils;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;

public record IgniteAction(QualityScalar tickDuration) implements IAction
{
    public static final MapCodec<IgniteAction> CODEC = RecordCodecBuilder.mapCodec(builder -> builder.group((App)QualityScalar.CODEC.fieldOf("tickDuration").forGetter(IgniteAction::tickDuration)).apply((Applicative)builder, IgniteAction::new));

    @Override
    public void apply(ServerLevel serverLevel, double quality, boolean applyToSelf, ServerPlayer wearer, Entity entity) {
        int ticks = (int)this.tickDuration.sample(quality);
        (applyToSelf ? wearer : entity).igniteForTicks(ticks);
    }

    @Override
    public Component formatTooltip(BonusInstance bonusInstance, boolean applyToSelf) {
        MutableComponent target = applyToSelf ? Component.translatable((String)"tooltip.irons_jewelry.self").withStyle(ChatFormatting.RED) : Component.translatable((String)"tooltip.irons_jewelry.attacker").withStyle(ChatFormatting.RED);
        return Component.translatable((String)"action.irons_jewelry.ignite", (Object[])new Object[]{target, Component.literal((String)Utils.timeFromTicks((int)this.tickDuration.sample(bonusInstance.quality()), 1))});
    }

    @Override
    public Component simpleDescription(MutableComponent actionName) {
        return actionName;
    }

    @Override
    public MapCodec<? extends IAction> codec() {
        return CODEC;
    }
}

