/*
 * Decompiled with CFR 0.152.
 */
package io.redspace.ironsjewelry.registry;

import io.redspace.ironsjewelry.datagen.ItemModelDataGenerator;
import io.redspace.ironsjewelry.item.CurioBaseItem;
import io.redspace.ironsjewelry.item.PatternRecipeItem;
import io.redspace.ironsjewelry.registry.BlockRegistry;
import java.util.function.Supplier;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.level.block.Block;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;

public class ItemRegistry {
    private static final DeferredRegister<Item> ITEMS = DeferredRegister.create((ResourceKey)Registries.ITEM, (String)"irons_jewelry");
    public static final DeferredHolder<Item, CurioBaseItem> RING = ITEMS.register("ring", () -> new CurioBaseItem(new Item.Properties().stacksTo(1), "ring"));
    public static final DeferredHolder<Item, CurioBaseItem> NECKLACE = ITEMS.register("necklace", () -> new CurioBaseItem(new Item.Properties().stacksTo(1), "necklace"));
    public static final DeferredHolder<Item, PatternRecipeItem> RECIPE = ITEMS.register("recipe", () -> new PatternRecipeItem(new Item.Properties().stacksTo(1).rarity(Rarity.UNCOMMON)));
    public static final DeferredHolder<Item, Item> RUBY = ItemRegistry.registerSimpleItem("ruby", () -> new Item(new Item.Properties()));
    public static final DeferredHolder<Item, Item> SAPPHIRE = ItemRegistry.registerSimpleItem("sapphire", () -> new Item(new Item.Properties()));
    public static final DeferredHolder<Item, Item> TOPAZ = ItemRegistry.registerSimpleItem("topaz", () -> new Item(new Item.Properties()));
    public static final DeferredHolder<Item, Item> MOONSTONE = ItemRegistry.registerSimpleItem("moonstone", () -> new Item(new Item.Properties()));
    public static final DeferredHolder<Item, Item> PERIDOT = ItemRegistry.registerSimpleItem("peridot", () -> new Item(new Item.Properties()));
    public static final DeferredHolder<Item, Item> ONYX = ItemRegistry.registerSimpleItem("onyx", () -> new Item(new Item.Properties()));
    public static final DeferredHolder<Item, Item> GARNET = ItemRegistry.registerSimpleItem("garnet", () -> new Item(new Item.Properties()));
    public static final DeferredHolder<Item, BlockItem> JEWELCRAFTING_STATION_BLOCK_ITEM = ITEMS.register("jewelcrafting_station", () -> new BlockItem((Block)BlockRegistry.JEWELCRAFTING_STATION_BLOCK.get(), new Item.Properties()));

    public static void register(IEventBus eventBus) {
        ITEMS.register(eventBus);
    }

    private static <T extends Item> DeferredHolder<Item, T> registerSimpleItem(String name, Supplier<T> supplier) {
        DeferredHolder s = ITEMS.register(name, supplier);
        ItemModelDataGenerator.toRegister.add(generator -> generator.simpleItem((DeferredHolder<Item, ? extends Item>)s));
        return s;
    }
}

