/*
 * Decompiled with CFR 0.152.
 */
package dev.muon.irons_apothic.affix;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.muon.irons_apothic.affix.SchoolFilteredAffix;
import dev.muon.irons_apothic.category.LootCategories;
import dev.shadowsoffire.apotheosis.Apoth;
import dev.shadowsoffire.apotheosis.Apotheosis;
import dev.shadowsoffire.apotheosis.affix.Affix;
import dev.shadowsoffire.apotheosis.affix.AffixDefinition;
import dev.shadowsoffire.apotheosis.affix.AffixInstance;
import dev.shadowsoffire.apotheosis.loot.LootCategory;
import dev.shadowsoffire.apotheosis.loot.LootRarity;
import dev.shadowsoffire.placebo.util.StepFunction;
import io.redspace.ironsspellbooks.api.registry.SchoolRegistry;
import io.redspace.ironsspellbooks.api.spells.SchoolType;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.common.util.AttributeTooltipContext;

public class ManaCostAffix
extends SchoolFilteredAffix {
    public static final Codec<ManaCostAffix> CODEC = RecordCodecBuilder.create(inst -> inst.group(Affix.affixDef(), (App)ResourceLocation.CODEC.optionalFieldOf("school").forGetter(a -> a.schoolIds.filter(list -> list.size() == 1).map(list -> (ResourceLocation)list.get(0))), (App)ResourceLocation.CODEC.listOf().optionalFieldOf("schools").forGetter(a -> a.schoolIds), (App)LootRarity.mapCodec((Codec)StepFunction.CODEC).fieldOf("values").forGetter(a -> a.values), (App)LootCategory.SET_CODEC.fieldOf("categories").forGetter(a -> a.categories)).apply((Applicative)inst, (def, singleSchool, schoolsArray, values, categories) -> {
        Optional<List<ResourceLocation>> schoolIds = schoolsArray.isPresent() ? schoolsArray : singleSchool.map(List::of);
        return new ManaCostAffix((AffixDefinition)def, schoolIds, (Map<LootRarity, StepFunction>)values, (Set<LootCategory>)categories);
    }));
    protected final Optional<List<ResourceLocation>> schoolIds;
    protected final Optional<Set<SchoolType>> schools;
    protected final Map<LootRarity, StepFunction> values;
    protected final Set<LootCategory> categories;

    public ManaCostAffix(AffixDefinition definition, Optional<List<ResourceLocation>> schoolIds, Map<LootRarity, StepFunction> values, Set<LootCategory> categories) {
        super(definition);
        this.schoolIds = schoolIds;
        this.schools = schoolIds.map(ids -> {
            HashSet<SchoolType> schoolSet = new HashSet<SchoolType>();
            for (ResourceLocation id : ids) {
                SchoolType school = (SchoolType)SchoolRegistry.REGISTRY.get(id);
                if (school != null) {
                    schoolSet.add(school);
                    continue;
                }
                Apotheosis.LOGGER.warn("Unknown school ID {} provided for ManaCostAffix, ignoring.", (Object)id);
            }
            return schoolSet;
        });
        this.values = values;
        this.categories = categories;
    }

    public Codec<? extends Affix> getCodec() {
        return CODEC;
    }

    public boolean canApplyTo(ItemStack stack, LootCategory cat, LootRarity rarity) {
        if (cat != LootCategories.STAFF && cat != Apoth.LootCategories.MELEE_WEAPON && cat != LootCategories.SPELLBOOK) {
            return false;
        }
        if (!this.values.containsKey(rarity)) {
            return false;
        }
        if (!this.categories.isEmpty() && !this.categories.contains(cat)) {
            return false;
        }
        return ManaCostAffix.matchesSchools(stack, this.schools);
    }

    public MutableComponent getDescription(AffixInstance inst, AttributeTooltipContext ctx) {
        float reduction = this.getReductionPercent(inst.getRarity(), inst.level());
        Component schoolComponent = this.getSchoolComponent();
        return Component.translatable((String)"affix.irons_apothic.mana_cost.desc", (Object[])new Object[]{schoolComponent, ManaCostAffix.fmt((float)(reduction * 100.0f))});
    }

    private Component getSchoolComponent() {
        if (this.schools.isEmpty()) {
            return Component.translatable((String)"affix.irons_apothic.school.generic");
        }
        Set<SchoolType> schoolSet = this.schools.get();
        if (schoolSet.isEmpty()) {
            return Component.translatable((String)"affix.irons_apothic.school.none");
        }
        SchoolType[] arr = schoolSet.toArray(new SchoolType[0]);
        if (arr.length == 1) {
            return ManaCostAffix.formatSchool(arr[0]);
        }
        if (arr.length == 2) {
            return Component.empty().append(ManaCostAffix.formatSchool(arr[0])).append((Component)Component.literal((String)" and ")).append(ManaCostAffix.formatSchool(arr[1]));
        }
        if (arr.length == 3) {
            return Component.empty().append(ManaCostAffix.formatSchool(arr[0])).append((Component)Component.literal((String)", ")).append(ManaCostAffix.formatSchool(arr[1])).append((Component)Component.literal((String)", and ")).append(ManaCostAffix.formatSchool(arr[2]));
        }
        return Component.empty().append(ManaCostAffix.formatSchool(arr[0])).append((Component)Component.literal((String)", ")).append(ManaCostAffix.formatSchool(arr[1])).append((Component)Component.literal((String)", ")).append(ManaCostAffix.formatSchool(arr[2])).append((Component)Component.literal((String)", and ")).append(ManaCostAffix.formatSchool(arr[3]));
    }

    private static Component formatSchool(SchoolType school) {
        String key = "school." + school.getId().getNamespace() + "." + school.getId().getPath();
        return Component.translatable((String)key).withStyle(school.getDisplayName().getStyle());
    }

    public Component getAugmentingText(AffixInstance inst, AttributeTooltipContext ctx) {
        MutableComponent comp = this.getDescription(inst, ctx);
        float minReduction = this.getReductionPercent(inst.getRarity(), 0.0f);
        float maxReduction = this.getReductionPercent(inst.getRarity(), 1.0f);
        MutableComponent minComp = Component.translatable((String)"%s%%", (Object[])new Object[]{ManaCostAffix.fmt((float)(minReduction * 100.0f))});
        MutableComponent maxComp = Component.translatable((String)"%s%%", (Object[])new Object[]{ManaCostAffix.fmt((float)(maxReduction * 100.0f))});
        return comp.append((Component)ManaCostAffix.valueBounds((Component)minComp, (Component)maxComp));
    }

    public Optional<Set<SchoolType>> getSchools() {
        return this.schools;
    }

    public float getReductionPercent(LootRarity rarity, float level) {
        StepFunction func = this.values.get(rarity);
        return func != null ? func.get(level) : 0.0f;
    }
}

