/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedterminals.api.terminalstorage;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import org.apache.commons.lang3.tuple.Pair;
import org.cyclops.integrateddynamics.api.evaluate.variable.ValueDeseralizationContext;

public interface ITerminalStorageTabCommon {
    public ResourceLocation getName();

    default public List<Pair<Slot, ISlotPositionCallback>> loadSlots(AbstractContainerMenu container, int startIndex, Player player, Optional<IVariableInventory> variableInventory, ValueDeseralizationContext valueDeseralizationContext) {
        return Collections.emptyList();
    }

    default public void onUpdate(AbstractContainerMenu container, Player player, Optional<IVariableInventory> variableInventory) {
    }

    public record SlotPositionFactors(int offsetX, int offsetY, int gridXSize, int gridYSize, int playerInventoryOffsetX, int playerInventoryOffsetY) {
    }

    public static interface ISlotPositionCallback {
        public Pair<Integer, Integer> getSlotPosition(SlotPositionFactors var1);
    }

    public static interface IVariableInventory {
        default public void loadNamedInventory(String name, Container inventory, HolderLookup.Provider holderLookupProvider) {
            NonNullList<ItemStack> tabItems = this.getNamedInventory(name, holderLookupProvider);
            if (tabItems != null) {
                for (int i = 0; i < tabItems.size(); ++i) {
                    inventory.setItem(i, (ItemStack)tabItems.get(i));
                }
            }
        }

        default public void saveNamedInventory(String name, Container inventory, HolderLookup.Provider holderLookupProvider) {
            NonNullList latestItems = NonNullList.create();
            for (int i = 0; i < inventory.getContainerSize(); ++i) {
                latestItems.add((Object)inventory.getItem(i));
            }
            this.setNamedInventory(name, (NonNullList<ItemStack>)latestItems, holderLookupProvider);
        }

        @Nullable
        public NonNullList<ItemStack> getNamedInventory(String var1, HolderLookup.Provider var2);

        public void setNamedInventory(String var1, NonNullList<ItemStack> var2, HolderLookup.Provider var3);
    }
}

