/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedscripting.vendors.org.graalvm.shadowed.com.ibm.icu;

import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.util.Arrays;
import org.cyclops.integratedscripting.vendors.com.oracle.svm.core.annotate.Substitute;
import org.cyclops.integratedscripting.vendors.com.oracle.svm.core.annotate.TargetClass;
import org.cyclops.integratedscripting.vendors.org.graalvm.shadowed.com.ibm.icu.impl.ICUData;
import org.cyclops.integratedscripting.vendors.org.graalvm.shadowed.org.tukaani.xz.LZMA2Options;

@TargetClass(value=ICUData.class)
final class Target_org_graalvm_shadowed_com_ibm_icu_impl_ICUData {
    Target_org_graalvm_shadowed_com_ibm_icu_impl_ICUData() {
    }

    @Substitute
    private static InputStream getResourceStream(ClassLoader loader, Class<?> root, String resourceName) {
        Class<Object> refClass = root;
        if (refClass == null && loader == ICUData.class.getClassLoader()) {
            refClass = ICUData.class;
        }
        boolean uncompressed = false;
        InputStream inputStream;
        while ((inputStream = refClass != null ? refClass.getResourceAsStream(resourceName) : loader.getResourceAsStream(resourceName)) != null) {
            if (uncompressed) {
                return inputStream;
            }
            try {
                byte[] expected = new byte[]{2, -85};
                byte[] hdr = new byte[expected.length];
                int nBytes = inputStream.read(hdr);
                if (nBytes >= expected.length && Arrays.equals(hdr, 0, expected.length, expected, 0, expected.length)) {
                    int preset = inputStream.read();
                    int dictSize = inputStream.read();
                    int uncompressedSize = inputStream.read() | inputStream.read() << 8 | inputStream.read() << 16 | inputStream.read() << 24;
                    LZMA2Options opts = new LZMA2Options(preset);
                    opts.setDictSize(1 << dictSize);
                    return opts.getInputStream(inputStream);
                }
                uncompressed = true;
                inputStream.close();
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
        return null;
    }
}

