/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedscripting.vendors.org.graalvm.polyglot.io;

import java.util.Objects;
import org.cyclops.integratedscripting.vendors.org.graalvm.polyglot.io.FileSystem;

public final class IOAccess {
    public static final IOAccess NONE = IOAccess.newBuilder().name("IOAccess.NONE").build();
    public static final IOAccess ALL = IOAccess.newBuilder().name("IOAccess.ALL").allowHostFileAccess(true).allowHostSocketAccess(true).build();
    private final String name;
    private final boolean allowHostFileAccess;
    private final boolean allowHostSocketAccess;
    private final FileSystem fileSystem;

    IOAccess(String name, boolean allowHostFileAccess, boolean allowHostSocketAccess, FileSystem fileSystem) {
        if (allowHostFileAccess && fileSystem != null) {
            throw new IllegalArgumentException("The method IOAccess.Builder.allowHostFileAccess(boolean) and the method IOAccess.Builder.fileSystem(FileSystem) are mutually exclusive.");
        }
        this.name = name;
        this.allowHostFileAccess = allowHostFileAccess;
        this.allowHostSocketAccess = allowHostSocketAccess;
        this.fileSystem = fileSystem;
    }

    boolean hasHostFileAccess() {
        return this.allowHostFileAccess;
    }

    boolean hasHostSocketAccess() {
        return this.allowHostSocketAccess;
    }

    FileSystem getFileSystem() {
        return this.fileSystem;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static Builder newBuilder(IOAccess prototype) {
        return new Builder(prototype);
    }

    public int hashCode() {
        return Objects.hash(this.allowHostFileAccess, this.allowHostSocketAccess, this.fileSystem);
    }

    public boolean equals(Object obj) {
        if (obj instanceof IOAccess) {
            IOAccess other = (IOAccess)obj;
            return this.allowHostFileAccess == other.allowHostFileAccess && this.allowHostSocketAccess == other.allowHostSocketAccess && Objects.equals(this.fileSystem, other.fileSystem);
        }
        return false;
    }

    public String toString() {
        if (this.name != null) {
            return this.name;
        }
        return String.format("IOAccess[allowHostFileAccess=%b, allowHostSocketAccess=%b, fileSystem=%s]", this.allowHostFileAccess, this.allowHostSocketAccess, this.fileSystem);
    }

    public static final class Builder {
        private String name;
        private boolean allowHostFileAccess;
        private boolean allowHostSocketAccess;
        private FileSystem customFileSystem;

        Builder() {
        }

        Builder(IOAccess prototype) {
            this.allowHostFileAccess = prototype.allowHostFileAccess;
            this.allowHostSocketAccess = prototype.allowHostSocketAccess;
            this.customFileSystem = prototype.fileSystem;
        }

        Builder name(String givenName) {
            this.name = givenName;
            return this;
        }

        public Builder allowHostFileAccess(boolean allow) {
            this.allowHostFileAccess = allow;
            return this;
        }

        public Builder allowHostSocketAccess(boolean allow) {
            this.allowHostSocketAccess = allow;
            return this;
        }

        public Builder fileSystem(FileSystem fileSystem) {
            this.customFileSystem = Objects.requireNonNull(fileSystem, "FileSystem must be non null.");
            return this;
        }

        public IOAccess build() {
            return new IOAccess(this.name, this.allowHostFileAccess, this.allowHostSocketAccess, this.customFileSystem);
        }
    }
}

