/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedscripting.vendors.org.graalvm.polyglot;

import java.lang.ref.Reference;
import java.math.BigInteger;
import java.nio.ByteOrder;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalTime;
import java.time.ZoneId;
import java.util.Objects;
import java.util.Set;
import org.cyclops.integratedscripting.vendors.org.graalvm.polyglot.AbstractValue;
import org.cyclops.integratedscripting.vendors.org.graalvm.polyglot.Context;
import org.cyclops.integratedscripting.vendors.org.graalvm.polyglot.Engine;
import org.cyclops.integratedscripting.vendors.org.graalvm.polyglot.PolyglotException;
import org.cyclops.integratedscripting.vendors.org.graalvm.polyglot.SourceSection;
import org.cyclops.integratedscripting.vendors.org.graalvm.polyglot.TypeLiteral;
import org.cyclops.integratedscripting.vendors.org.graalvm.polyglot.impl.AbstractPolyglotImpl;
import org.cyclops.integratedscripting.vendors.org.graalvm.polyglot.proxy.Proxy;

public final class Value
extends AbstractValue {
    Value(AbstractPolyglotImpl.AbstractValueDispatch dispatch, Object context, Object receiver, Context creatorContext) {
        super(dispatch, context, receiver, creatorContext);
    }

    public Value getMetaObject() {
        try {
            Value value = (Value)this.dispatch.getMetaObject(this.context, this.receiver);
            return value;
        }
        finally {
            Reference.reachabilityFence(this.creatorContext);
        }
    }

    public boolean isMetaObject() {
        try {
            boolean bl = this.dispatch.isMetaObject(this.context, this.receiver);
            return bl;
        }
        finally {
            Reference.reachabilityFence(this.creatorContext);
        }
    }

    public String getMetaQualifiedName() {
        try {
            String string = this.dispatch.getMetaQualifiedName(this.context, this.receiver);
            return string;
        }
        finally {
            Reference.reachabilityFence(this.creatorContext);
        }
    }

    public String getMetaSimpleName() {
        try {
            String string = this.dispatch.getMetaSimpleName(this.context, this.receiver);
            return string;
        }
        finally {
            Reference.reachabilityFence(this.creatorContext);
        }
    }

    public boolean isMetaInstance(Object instance) {
        try {
            boolean bl = this.dispatch.isMetaInstance(this.context, this.receiver, instance);
            return bl;
        }
        finally {
            Reference.reachabilityFence(this.creatorContext);
        }
    }

    public boolean hasMetaParents() {
        try {
            boolean bl = this.dispatch.hasMetaParents(this.context, this.receiver);
            return bl;
        }
        finally {
            Reference.reachabilityFence(this.creatorContext);
        }
    }

    public Value getMetaParents() {
        try {
            Value value = (Value)this.dispatch.getMetaParents(this.context, this.receiver);
            return value;
        }
        finally {
            Reference.reachabilityFence(this.creatorContext);
        }
    }

    public boolean hasArrayElements() {
        try {
            boolean bl = this.dispatch.hasArrayElements(this.context, this.receiver);
            return bl;
        }
        finally {
            Reference.reachabilityFence(this.creatorContext);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Value getArrayElement(long index) {
        try {
            Value value = (Value)this.dispatch.getArrayElement(this.context, this.receiver, index);
            return value;
        }
        finally {
            Reference.reachabilityFence(this.creatorContext);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setArrayElement(long index, Object value) {
        try {
            this.dispatch.setArrayElement(this.context, this.receiver, index, value);
        }
        finally {
            Reference.reachabilityFence(this.creatorContext);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeArrayElement(long index) {
        try {
            boolean bl = this.dispatch.removeArrayElement(this.context, this.receiver, index);
            return bl;
        }
        finally {
            Reference.reachabilityFence(this.creatorContext);
        }
    }

    public long getArraySize() {
        try {
            long l = this.dispatch.getArraySize(this.context, this.receiver);
            return l;
        }
        finally {
            Reference.reachabilityFence(this.creatorContext);
        }
    }

    public boolean hasBufferElements() {
        try {
            boolean bl = this.dispatch.hasBufferElements(this.context, this.receiver);
            return bl;
        }
        finally {
            Reference.reachabilityFence(this.creatorContext);
        }
    }

    public boolean isBufferWritable() throws UnsupportedOperationException {
        try {
            boolean bl = this.dispatch.isBufferWritable(this.context, this.receiver);
            return bl;
        }
        finally {
            Reference.reachabilityFence(this.creatorContext);
        }
    }

    public long getBufferSize() throws UnsupportedOperationException {
        try {
            long l = this.dispatch.getBufferSize(this.context, this.receiver);
            return l;
        }
        finally {
            Reference.reachabilityFence(this.creatorContext);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte readBufferByte(long byteOffset) throws UnsupportedOperationException, IndexOutOfBoundsException {
        try {
            byte by = this.dispatch.readBufferByte(this.context, this.receiver, byteOffset);
            return by;
        }
        finally {
            Reference.reachabilityFence(this.creatorContext);
        }
    }

    public void readBuffer(long byteOffset, byte[] destination, int destinationOffset, int length) throws UnsupportedOperationException, IndexOutOfBoundsException {
        Objects.requireNonNull(destination, "destination");
        Objects.checkFromIndexSize(destinationOffset, length, destination.length);
        this.dispatch.readBuffer(this.context, this.receiver, byteOffset, destination, destinationOffset, length);
        Reference.reachabilityFence(this.creatorContext);
    }

    public void writeBufferByte(long byteOffset, byte value) throws UnsupportedOperationException, IndexOutOfBoundsException {
        this.dispatch.writeBufferByte(this.context, this.receiver, byteOffset, value);
        Reference.reachabilityFence(this.creatorContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public short readBufferShort(ByteOrder order, long byteOffset) throws UnsupportedOperationException, IndexOutOfBoundsException {
        try {
            short s = this.dispatch.readBufferShort(this.context, this.receiver, order, byteOffset);
            return s;
        }
        finally {
            Reference.reachabilityFence(this.creatorContext);
        }
    }

    public void writeBufferShort(ByteOrder order, long byteOffset, short value) throws UnsupportedOperationException, IndexOutOfBoundsException {
        this.dispatch.writeBufferShort(this.context, this.receiver, order, byteOffset, value);
        Reference.reachabilityFence(this.creatorContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int readBufferInt(ByteOrder order, long byteOffset) throws UnsupportedOperationException, IndexOutOfBoundsException {
        try {
            int n = this.dispatch.readBufferInt(this.context, this.receiver, order, byteOffset);
            return n;
        }
        finally {
            Reference.reachabilityFence(this.creatorContext);
        }
    }

    public void writeBufferInt(ByteOrder order, long byteOffset, int value) throws UnsupportedOperationException, IndexOutOfBoundsException {
        this.dispatch.writeBufferInt(this.context, this.receiver, order, byteOffset, value);
        Reference.reachabilityFence(this.creatorContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long readBufferLong(ByteOrder order, long byteOffset) throws UnsupportedOperationException, IndexOutOfBoundsException {
        try {
            long l = this.dispatch.readBufferLong(this.context, this.receiver, order, byteOffset);
            return l;
        }
        finally {
            Reference.reachabilityFence(this.creatorContext);
        }
    }

    public void writeBufferLong(ByteOrder order, long byteOffset, long value) throws UnsupportedOperationException, IndexOutOfBoundsException {
        this.dispatch.writeBufferLong(this.context, this.receiver, order, byteOffset, value);
        Reference.reachabilityFence(this.creatorContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public float readBufferFloat(ByteOrder order, long byteOffset) throws UnsupportedOperationException, IndexOutOfBoundsException {
        try {
            float f = this.dispatch.readBufferFloat(this.context, this.receiver, order, byteOffset);
            return f;
        }
        finally {
            Reference.reachabilityFence(this.creatorContext);
        }
    }

    public void writeBufferFloat(ByteOrder order, long byteOffset, float value) throws UnsupportedOperationException, IndexOutOfBoundsException {
        this.dispatch.writeBufferFloat(this.context, this.receiver, order, byteOffset, value);
        Reference.reachabilityFence(this.creatorContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double readBufferDouble(ByteOrder order, long byteOffset) throws UnsupportedOperationException, IndexOutOfBoundsException {
        try {
            double d = this.dispatch.readBufferDouble(this.context, this.receiver, order, byteOffset);
            return d;
        }
        finally {
            Reference.reachabilityFence(this.creatorContext);
        }
    }

    public void writeBufferDouble(ByteOrder order, long byteOffset, double value) throws UnsupportedOperationException, IndexOutOfBoundsException {
        this.dispatch.writeBufferDouble(this.context, this.receiver, order, byteOffset, value);
        Reference.reachabilityFence(this.creatorContext);
    }

    public boolean hasMembers() {
        try {
            boolean bl = this.dispatch.hasMembers(this.context, this.receiver);
            return bl;
        }
        finally {
            Reference.reachabilityFence(this.creatorContext);
        }
    }

    public boolean hasMember(String identifier) {
        Objects.requireNonNull(identifier, "identifier");
        try {
            boolean bl = this.dispatch.hasMember(this.context, this.receiver, identifier);
            return bl;
        }
        finally {
            Reference.reachabilityFence(this.creatorContext);
        }
    }

    public Value getMember(String identifier) {
        Objects.requireNonNull(identifier, "identifier");
        try {
            Value value = (Value)this.dispatch.getMember(this.context, this.receiver, identifier);
            return value;
        }
        finally {
            Reference.reachabilityFence(this.creatorContext);
        }
    }

    public Set<String> getMemberKeys() {
        try {
            Set<String> set = this.dispatch.getMemberKeys(this.context, this.receiver);
            return set;
        }
        finally {
            Reference.reachabilityFence(this.creatorContext);
        }
    }

    public void putMember(String identifier, Object value) {
        Objects.requireNonNull(identifier, "identifier");
        this.dispatch.putMember(this.context, this.receiver, identifier, value);
        Reference.reachabilityFence(this.creatorContext);
    }

    public boolean removeMember(String identifier) {
        Objects.requireNonNull(identifier, "identifier");
        try {
            boolean bl = this.dispatch.removeMember(this.context, this.receiver, identifier);
            return bl;
        }
        finally {
            Reference.reachabilityFence(this.creatorContext);
        }
    }

    public boolean canExecute() {
        try {
            boolean bl = this.dispatch.canExecute(this.context, this.receiver);
            return bl;
        }
        finally {
            Reference.reachabilityFence(this.creatorContext);
        }
    }

    public Value execute(Object ... arguments) {
        try {
            if (arguments.length == 0) {
                Value value = (Value)this.dispatch.execute(this.context, this.receiver);
                return value;
            }
            Value value = (Value)this.dispatch.execute(this.context, this.receiver, arguments);
            return value;
        }
        finally {
            Reference.reachabilityFence(this.creatorContext);
        }
    }

    public void executeVoid(Object ... arguments) {
        if (arguments.length == 0) {
            this.dispatch.executeVoid(this.context, this.receiver);
        } else {
            this.dispatch.executeVoid(this.context, this.receiver, arguments);
        }
        Reference.reachabilityFence(this.creatorContext);
    }

    public boolean canInstantiate() {
        try {
            boolean bl = this.dispatch.canInstantiate(this.context, this.receiver);
            return bl;
        }
        finally {
            Reference.reachabilityFence(this.creatorContext);
        }
    }

    public Value newInstance(Object ... arguments) {
        Objects.requireNonNull(arguments, "arguments");
        try {
            Value value = (Value)this.dispatch.newInstance(this.context, this.receiver, arguments);
            return value;
        }
        finally {
            Reference.reachabilityFence(this.creatorContext);
        }
    }

    public boolean canInvokeMember(String identifier) {
        Objects.requireNonNull(identifier, "identifier");
        try {
            boolean bl = this.dispatch.canInvoke(this.context, identifier, this.receiver);
            return bl;
        }
        finally {
            Reference.reachabilityFence(this.creatorContext);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Value invokeMember(String identifier, Object ... arguments) {
        Objects.requireNonNull(identifier, "identifier");
        try {
            if (arguments.length == 0) {
                Value value = (Value)this.dispatch.invoke(this.context, this.receiver, identifier);
                return value;
            }
            Value value = (Value)this.dispatch.invoke(this.context, this.receiver, identifier, arguments);
            return value;
        }
        finally {
            Reference.reachabilityFence(this.creatorContext);
        }
    }

    public boolean isString() {
        try {
            boolean bl = this.dispatch.isString(this.context, this.receiver);
            return bl;
        }
        finally {
            Reference.reachabilityFence(this.creatorContext);
        }
    }

    public String asString() {
        try {
            String string = this.dispatch.asString(this.context, this.receiver);
            return string;
        }
        finally {
            Reference.reachabilityFence(this.creatorContext);
        }
    }

    public byte[] asStringBytes(StringEncoding encoding) {
        return this.dispatch.asStringBytes(this.context, this.receiver, encoding.value);
    }

    public boolean fitsInInt() {
        try {
            boolean bl = this.dispatch.fitsInInt(this.context, this.receiver);
            return bl;
        }
        finally {
            Reference.reachabilityFence(this.creatorContext);
        }
    }

    public int asInt() {
        try {
            int n = this.dispatch.asInt(this.context, this.receiver);
            return n;
        }
        finally {
            Reference.reachabilityFence(this.creatorContext);
        }
    }

    public boolean isBoolean() {
        try {
            boolean bl = this.dispatch.isBoolean(this.context, this.receiver);
            return bl;
        }
        finally {
            Reference.reachabilityFence(this.creatorContext);
        }
    }

    public boolean asBoolean() {
        try {
            boolean bl = this.dispatch.asBoolean(this.context, this.receiver);
            return bl;
        }
        finally {
            Reference.reachabilityFence(this.creatorContext);
        }
    }

    public boolean isNumber() {
        try {
            boolean bl = this.dispatch.isNumber(this.context, this.receiver);
            return bl;
        }
        finally {
            Reference.reachabilityFence(this.creatorContext);
        }
    }

    public boolean fitsInLong() {
        try {
            boolean bl = this.dispatch.fitsInLong(this.context, this.receiver);
            return bl;
        }
        finally {
            Reference.reachabilityFence(this.creatorContext);
        }
    }

    public long asLong() {
        try {
            long l = this.dispatch.asLong(this.context, this.receiver);
            return l;
        }
        finally {
            Reference.reachabilityFence(this.creatorContext);
        }
    }

    public boolean fitsInBigInteger() {
        try {
            boolean bl = this.dispatch.fitsInBigInteger(this.context, this.receiver);
            return bl;
        }
        finally {
            Reference.reachabilityFence(this.creatorContext);
        }
    }

    public BigInteger asBigInteger() {
        try {
            BigInteger bigInteger = this.dispatch.asBigInteger(this.context, this.receiver);
            return bigInteger;
        }
        finally {
            Reference.reachabilityFence(this.creatorContext);
        }
    }

    public boolean fitsInDouble() {
        try {
            boolean bl = this.dispatch.fitsInDouble(this.context, this.receiver);
            return bl;
        }
        finally {
            Reference.reachabilityFence(this.creatorContext);
        }
    }

    public double asDouble() {
        try {
            double d = this.dispatch.asDouble(this.context, this.receiver);
            return d;
        }
        finally {
            Reference.reachabilityFence(this.creatorContext);
        }
    }

    public boolean fitsInFloat() {
        try {
            boolean bl = this.dispatch.fitsInFloat(this.context, this.receiver);
            return bl;
        }
        finally {
            Reference.reachabilityFence(this.creatorContext);
        }
    }

    public float asFloat() {
        try {
            float f = this.dispatch.asFloat(this.context, this.receiver);
            return f;
        }
        finally {
            Reference.reachabilityFence(this.creatorContext);
        }
    }

    public boolean fitsInByte() {
        try {
            boolean bl = this.dispatch.fitsInByte(this.context, this.receiver);
            return bl;
        }
        finally {
            Reference.reachabilityFence(this.creatorContext);
        }
    }

    public byte asByte() {
        try {
            byte by = this.dispatch.asByte(this.context, this.receiver);
            return by;
        }
        finally {
            Reference.reachabilityFence(this.creatorContext);
        }
    }

    public boolean fitsInShort() {
        try {
            boolean bl = this.dispatch.fitsInShort(this.context, this.receiver);
            return bl;
        }
        finally {
            Reference.reachabilityFence(this.creatorContext);
        }
    }

    public short asShort() {
        try {
            short s = this.dispatch.asShort(this.context, this.receiver);
            return s;
        }
        finally {
            Reference.reachabilityFence(this.creatorContext);
        }
    }

    public boolean isNull() {
        try {
            boolean bl = this.dispatch.isNull(this.context, this.receiver);
            return bl;
        }
        finally {
            Reference.reachabilityFence(this.creatorContext);
        }
    }

    public boolean isNativePointer() {
        try {
            boolean bl = this.dispatch.isNativePointer(this.context, this.receiver);
            return bl;
        }
        finally {
            Reference.reachabilityFence(this.creatorContext);
        }
    }

    public long asNativePointer() {
        try {
            long l = this.dispatch.asNativePointer(this.context, this.receiver);
            return l;
        }
        finally {
            Reference.reachabilityFence(this.creatorContext);
        }
    }

    public boolean isHostObject() {
        try {
            boolean bl = this.dispatch.isHostObject(this.context, this.receiver);
            return bl;
        }
        finally {
            Reference.reachabilityFence(this.creatorContext);
        }
    }

    public <T> T asHostObject() {
        try {
            Object object = this.dispatch.asHostObject(this.context, this.receiver);
            return (T)object;
        }
        finally {
            Reference.reachabilityFence(this.creatorContext);
        }
    }

    public boolean isProxyObject() {
        try {
            boolean bl = this.dispatch.isProxyObject(this.context, this.receiver);
            return bl;
        }
        finally {
            Reference.reachabilityFence(this.creatorContext);
        }
    }

    public <T extends Proxy> T asProxyObject() {
        try {
            Proxy proxy = (Proxy)this.dispatch.asProxyObject(this.context, this.receiver);
            return (T)proxy;
        }
        finally {
            Reference.reachabilityFence(this.creatorContext);
        }
    }

    public <T> T as(Class<T> targetType) throws ClassCastException, IllegalStateException, PolyglotException {
        Objects.requireNonNull(targetType, "targetType");
        if (targetType == Value.class) {
            return (T)this;
        }
        try {
            T t = this.dispatch.asClass(this.context, this.receiver, targetType);
            return t;
        }
        finally {
            Reference.reachabilityFence(this.creatorContext);
        }
    }

    public <T> T as(TypeLiteral<T> targetType) {
        Objects.requireNonNull(targetType, "targetType");
        try {
            T t = this.dispatch.asTypeLiteral(this.context, this.receiver, targetType.getRawType(), targetType.getType());
            return t;
        }
        finally {
            Reference.reachabilityFence(this.creatorContext);
        }
    }

    @Override
    public String toString() {
        return super.toString();
    }

    public SourceSection getSourceLocation() {
        try {
            SourceSection sourceSection = (SourceSection)this.dispatch.getSourceLocation(this.context, this.receiver);
            return sourceSection;
        }
        finally {
            Reference.reachabilityFence(this.creatorContext);
        }
    }

    public boolean isDate() {
        try {
            boolean bl = this.dispatch.isDate(this.context, this.receiver);
            return bl;
        }
        finally {
            Reference.reachabilityFence(this.creatorContext);
        }
    }

    public LocalDate asDate() {
        try {
            LocalDate localDate = this.dispatch.asDate(this.context, this.receiver);
            return localDate;
        }
        finally {
            Reference.reachabilityFence(this.creatorContext);
        }
    }

    public boolean isTime() {
        try {
            boolean bl = this.dispatch.isTime(this.context, this.receiver);
            return bl;
        }
        finally {
            Reference.reachabilityFence(this.creatorContext);
        }
    }

    public LocalTime asTime() {
        try {
            LocalTime localTime = this.dispatch.asTime(this.context, this.receiver);
            return localTime;
        }
        finally {
            Reference.reachabilityFence(this.creatorContext);
        }
    }

    public boolean isInstant() {
        try {
            boolean bl = this.isDate() && this.isTime() && this.isTimeZone();
            return bl;
        }
        finally {
            Reference.reachabilityFence(this.creatorContext);
        }
    }

    public Instant asInstant() {
        try {
            Instant instant = this.dispatch.asInstant(this.context, this.receiver);
            return instant;
        }
        finally {
            Reference.reachabilityFence(this.creatorContext);
        }
    }

    public boolean isTimeZone() {
        try {
            boolean bl = this.dispatch.isTimeZone(this.context, this.receiver);
            return bl;
        }
        finally {
            Reference.reachabilityFence(this.creatorContext);
        }
    }

    public ZoneId asTimeZone() {
        try {
            ZoneId zoneId = this.dispatch.asTimeZone(this.context, this.receiver);
            return zoneId;
        }
        finally {
            Reference.reachabilityFence(this.creatorContext);
        }
    }

    public boolean isDuration() {
        try {
            boolean bl = this.dispatch.isDuration(this.context, this.receiver);
            return bl;
        }
        finally {
            Reference.reachabilityFence(this.creatorContext);
        }
    }

    public Duration asDuration() {
        try {
            Duration duration = this.dispatch.asDuration(this.context, this.receiver);
            return duration;
        }
        finally {
            Reference.reachabilityFence(this.creatorContext);
        }
    }

    public boolean isException() {
        try {
            boolean bl = this.dispatch.isException(this.context, this.receiver);
            return bl;
        }
        finally {
            Reference.reachabilityFence(this.creatorContext);
        }
    }

    public RuntimeException throwException() {
        try {
            RuntimeException runtimeException = this.dispatch.throwException(this.context, this.receiver);
            return runtimeException;
        }
        finally {
            Reference.reachabilityFence(this.creatorContext);
        }
    }

    public Context getContext() {
        if (this.creatorContext != null && this.creatorContext.currentAPI != null) {
            return this.creatorContext.currentAPI;
        }
        return this.creatorContext;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj);
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    public boolean hasIterator() {
        try {
            boolean bl = this.dispatch.hasIterator(this.context, this.receiver);
            return bl;
        }
        finally {
            Reference.reachabilityFence(this.creatorContext);
        }
    }

    public Value getIterator() {
        try {
            Value value = (Value)this.dispatch.getIterator(this.context, this.receiver);
            return value;
        }
        finally {
            Reference.reachabilityFence(this.creatorContext);
        }
    }

    public boolean isIterator() {
        try {
            boolean bl = this.dispatch.isIterator(this.context, this.receiver);
            return bl;
        }
        finally {
            Reference.reachabilityFence(this.creatorContext);
        }
    }

    public boolean hasIteratorNextElement() {
        try {
            boolean bl = this.dispatch.hasIteratorNextElement(this.context, this.receiver);
            return bl;
        }
        finally {
            Reference.reachabilityFence(this.creatorContext);
        }
    }

    public Value getIteratorNextElement() {
        try {
            Value value = (Value)this.dispatch.getIteratorNextElement(this.context, this.receiver);
            return value;
        }
        finally {
            Reference.reachabilityFence(this.creatorContext);
        }
    }

    public boolean hasHashEntries() {
        try {
            boolean bl = this.dispatch.hasHashEntries(this.context, this.receiver);
            return bl;
        }
        finally {
            Reference.reachabilityFence(this.creatorContext);
        }
    }

    public long getHashSize() throws UnsupportedOperationException {
        try {
            long l = this.dispatch.getHashSize(this.context, this.receiver);
            return l;
        }
        finally {
            Reference.reachabilityFence(this.creatorContext);
        }
    }

    public boolean hasHashEntry(Object key) {
        try {
            boolean bl = this.dispatch.hasHashEntry(this.context, this.receiver, key);
            return bl;
        }
        finally {
            Reference.reachabilityFence(this.creatorContext);
        }
    }

    public Value getHashValue(Object key) throws UnsupportedOperationException {
        try {
            Value value = (Value)this.dispatch.getHashValue(this.context, this.receiver, key);
            return value;
        }
        finally {
            Reference.reachabilityFence(this.creatorContext);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Value getHashValueOrDefault(Object key, Object defaultValue) throws UnsupportedOperationException {
        try {
            Value value = (Value)this.dispatch.getHashValueOrDefault(this.context, this.receiver, key, defaultValue);
            return value;
        }
        finally {
            Reference.reachabilityFence(this.creatorContext);
        }
    }

    public void putHashEntry(Object key, Object value) throws IllegalArgumentException, UnsupportedOperationException {
        this.dispatch.putHashEntry(this.context, this.receiver, key, value);
        Reference.reachabilityFence(this.creatorContext);
    }

    public boolean removeHashEntry(Object key) throws UnsupportedOperationException {
        try {
            boolean bl = this.dispatch.removeHashEntry(this.context, this.receiver, key);
            return bl;
        }
        finally {
            Reference.reachabilityFence(this.creatorContext);
        }
    }

    public Value getHashEntriesIterator() throws UnsupportedOperationException {
        try {
            Value value = (Value)this.dispatch.getHashEntriesIterator(this.context, this.receiver);
            return value;
        }
        finally {
            Reference.reachabilityFence(this.creatorContext);
        }
    }

    public Value getHashKeysIterator() throws UnsupportedOperationException {
        try {
            Value value = (Value)this.dispatch.getHashKeysIterator(this.context, this.receiver);
            return value;
        }
        finally {
            Reference.reachabilityFence(this.creatorContext);
        }
    }

    public Value getHashValuesIterator() throws UnsupportedOperationException {
        try {
            Value value = (Value)this.dispatch.getHashValuesIterator(this.context, this.receiver);
            return value;
        }
        finally {
            Reference.reachabilityFence(this.creatorContext);
        }
    }

    public static Value asValue(Object o) {
        if (o instanceof Value) {
            return (Value)o;
        }
        return (Value)Engine.getImpl().asValue(o);
    }

    public void pin() {
        this.dispatch.pin(this.context, this.receiver);
        Reference.reachabilityFence(this.creatorContext);
    }

    public static Value fromByteBasedString(byte[] bytes, StringEncoding encoding) {
        Objects.requireNonNull(bytes);
        Objects.requireNonNull(encoding);
        return Engine.getImpl().fromByteBasedString(bytes, 0, bytes.length, encoding.value, true);
    }

    public static Value fromByteBasedString(byte[] bytes, int offset, int length, StringEncoding encoding, boolean copy) {
        Objects.requireNonNull(bytes);
        Objects.requireNonNull(encoding);
        if (offset < 0) {
            throw new IndexOutOfBoundsException("byteLength must not be negative");
        }
        if (length < 0) {
            throw new IndexOutOfBoundsException("byteOffset must not be negative");
        }
        if (offset + length > bytes.length) {
            throw new IndexOutOfBoundsException("byte index is out of bounds");
        }
        return Engine.getImpl().fromByteBasedString(bytes, offset, length, encoding.value, copy);
    }

    public static Value fromNativeString(long basePointer, int byteOffset, int byteLength, StringEncoding encoding, boolean copy) {
        Objects.requireNonNull(encoding);
        if (basePointer == 0L) {
            throw new NullPointerException("Null base pointer provided.");
        }
        if (byteLength < 0) {
            throw new IndexOutOfBoundsException("byteLength must not be negative");
        }
        if (byteOffset < 0) {
            throw new IndexOutOfBoundsException("byteOffset must not be negative");
        }
        return Engine.getImpl().fromNativeString(basePointer, byteOffset, byteLength, encoding.value, copy);
    }

    public static Value fromNativeString(long basePointer, int byteLength, StringEncoding encoding) {
        return Value.fromNativeString(basePointer, 0, byteLength, encoding, true);
    }

    public static final class StringEncoding {
        public static final StringEncoding UTF_8 = new StringEncoding(0);
        public static final StringEncoding UTF_16_LITTLE_ENDIAN = new StringEncoding(1);
        public static final StringEncoding UTF_16_BIG_ENDIAN = new StringEncoding(2);
        public static final StringEncoding UTF_32_LITTLE_ENDIAN = new StringEncoding(3);
        public static final StringEncoding UTF_32_BIG_ENDIAN = new StringEncoding(4);
        public static final StringEncoding UTF_16 = ByteOrder.nativeOrder() == ByteOrder.LITTLE_ENDIAN ? UTF_16_LITTLE_ENDIAN : UTF_16_BIG_ENDIAN;
        public static final StringEncoding UTF_32 = ByteOrder.nativeOrder() == ByteOrder.LITTLE_ENDIAN ? UTF_32_LITTLE_ENDIAN : UTF_32_BIG_ENDIAN;
        final int value;

        private StringEncoding(int value) {
            this.value = value;
        }
    }
}

