/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedscripting.vendors.org.graalvm.nativeimage.hosted;

import java.util.Arrays;
import java.util.Locale;
import java.util.Objects;
import org.cyclops.integratedscripting.vendors.org.graalvm.nativeimage.ImageSingletons;
import org.cyclops.integratedscripting.vendors.org.graalvm.nativeimage.Platform;
import org.cyclops.integratedscripting.vendors.org.graalvm.nativeimage.Platforms;
import org.cyclops.integratedscripting.vendors.org.graalvm.nativeimage.impl.ConfigurationCondition;
import org.cyclops.integratedscripting.vendors.org.graalvm.nativeimage.impl.RuntimeResourceSupport;

@Platforms(value={Platform.HOSTED_ONLY.class})
public final class RuntimeResourceAccess {
    public static void addResource(Module module, String resourcePath) {
        Objects.requireNonNull(module);
        Objects.requireNonNull(resourcePath);
        ImageSingletons.lookup(RuntimeResourceSupport.class).addResource(module, resourcePath, "Manually added via RuntimeResourceAccess");
    }

    public static void addResource(Module module, String resourcePath, byte[] resourceContent) {
        Objects.requireNonNull(module);
        Objects.requireNonNull(resourcePath);
        Objects.requireNonNull(resourceContent);
        ImageSingletons.lookup(RuntimeResourceSupport.class).injectResource(module, resourcePath, resourceContent, "Manually added via RuntimeResourceAccess");
        ImageSingletons.lookup(RuntimeResourceSupport.class).addCondition(ConfigurationCondition.alwaysTrue(), module, resourcePath);
    }

    public static void addResourceBundle(Module module, String baseBundleName, Locale[] locales) {
        Objects.requireNonNull(locales);
        RuntimeResourceSupport.singleton().addResourceBundles(ConfigurationCondition.alwaysTrue(), RuntimeResourceAccess.withModuleName(module, baseBundleName), Arrays.asList(locales));
    }

    public static void addResourceBundle(Module module, String bundleName) {
        RuntimeResourceSupport.singleton().addResourceBundles(ConfigurationCondition.alwaysTrue(), RuntimeResourceAccess.withModuleName(module, bundleName));
    }

    private static String withModuleName(Module module, String str) {
        Objects.requireNonNull(module);
        Objects.requireNonNull(str);
        return (module.isNamed() ? module.getName() : "ALL-UNNAMED") + ":" + str;
    }

    private RuntimeResourceAccess() {
    }
}

