/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedscripting.vendors.com.oracle.truffle.runtime.hotspot.libgraal;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Formatter;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import jdk.vm.ci.code.InstalledCode;
import jdk.vm.ci.hotspot.HotSpotSpeculationLog;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.ResolvedJavaField;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import jdk.vm.ci.meta.ResolvedJavaType;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.compiler.ConstantFieldInfo;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.compiler.HostMethodInfo;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.compiler.OptimizedAssumptionDependency;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.compiler.PartialEvaluationMethodInfo;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.compiler.TruffleCompilable;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.compiler.TruffleCompilationTask;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.compiler.TruffleCompilerAssumptionDependency;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.compiler.TruffleCompilerListener;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.compiler.TruffleCompilerRuntime;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.compiler.TruffleSourceLanguagePosition;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.compiler.hotspot.libgraal.TruffleFromLibGraal;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.runtime.OptimizedCallTarget;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.runtime.hotspot.libgraal.BinaryOutput;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.runtime.hotspot.libgraal.LibGraal;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.runtime.hotspot.libgraal.LibGraalCompilationResultInfo;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.runtime.hotspot.libgraal.LibGraalGraphInfo;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.runtime.hotspot.libgraal.LibGraalIsolate;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.runtime.hotspot.libgraal.LibGraalScopedStringSupplier;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.runtime.hotspot.libgraal.LibGraalStringSupplier;

final class TruffleFromLibGraalEntryPoints {
    TruffleFromLibGraalEntryPoints() {
    }

    @TruffleFromLibGraal(value=TruffleFromLibGraal.Id.OnIsolateShutdown)
    static void onIsolateShutdown(long isolateId) {
        LibGraalIsolate.unregister(isolateId);
    }

    @TruffleFromLibGraal(value=TruffleFromLibGraal.Id.ConsumeOptimizedAssumptionDependency)
    static void consumeOptimizedAssumptionDependency(Consumer<OptimizedAssumptionDependency> consumer, Object target, long installedCode) {
        OptimizedCallTarget callTarget = (OptimizedCallTarget)target;
        TruffleCompilerAssumptionDependency dependency = callTarget == null ? null : new TruffleCompilerAssumptionDependency(callTarget, LibGraal.unhand(InstalledCode.class, installedCode));
        consumer.accept(dependency);
    }

    @TruffleFromLibGraal(value=TruffleFromLibGraal.Id.IsValueType)
    static boolean isValueType(Object truffleRuntime, long typeHandle) {
        ResolvedJavaType type = LibGraal.unhand(ResolvedJavaType.class, typeHandle);
        return ((TruffleCompilerRuntime)truffleRuntime).isValueType(type);
    }

    @TruffleFromLibGraal(value=TruffleFromLibGraal.Id.GetConstantFieldInfo)
    static int getConstantFieldInfo(Object truffleRuntime, long typeHandle, boolean isStatic, int fieldIndex) {
        ResolvedJavaType enclosing = LibGraal.unhand(ResolvedJavaType.class, typeHandle);
        ResolvedJavaField[] declaredFields = isStatic ? enclosing.getStaticFields() : enclosing.getInstanceFields(false);
        ResolvedJavaField field = declaredFields[fieldIndex];
        ConstantFieldInfo constantFieldInfo = ((TruffleCompilerRuntime)truffleRuntime).getConstantFieldInfo(field);
        if (constantFieldInfo == null) {
            return Integer.MIN_VALUE;
        }
        if (constantFieldInfo.isChildren()) {
            return -2;
        }
        if (constantFieldInfo.isChild()) {
            return -1;
        }
        return constantFieldInfo.getDimensions();
    }

    @TruffleFromLibGraal(value=TruffleFromLibGraal.Id.Log)
    static void log(Object truffleRuntime, String loggerId, Object compilable, String message) {
        ((TruffleCompilerRuntime)truffleRuntime).log(loggerId, (TruffleCompilable)compilable, message);
    }

    @TruffleFromLibGraal(value=TruffleFromLibGraal.Id.RegisterOptimizedAssumptionDependency)
    static Consumer<OptimizedAssumptionDependency> registerOptimizedAssumptionDependency(Object truffleRuntime, long optimizedAssumptionHandle) {
        JavaConstant optimizedAssumption = LibGraal.unhand(JavaConstant.class, optimizedAssumptionHandle);
        return ((TruffleCompilerRuntime)truffleRuntime).registerOptimizedAssumptionDependency(optimizedAssumption);
    }

    @TruffleFromLibGraal(value=TruffleFromLibGraal.Id.IsSuppressedFailure)
    static boolean isSuppressedFailure(Object truffleRuntime, Object compilable, Supplier<String> serializedException) {
        return ((TruffleCompilerRuntime)truffleRuntime).isSuppressedFailure((TruffleCompilable)compilable, serializedException);
    }

    @TruffleFromLibGraal(value=TruffleFromLibGraal.Id.GetPosition)
    static Object getPosition(Object task, long callNodeHandle) {
        JavaConstant callNode = LibGraal.unhand(JavaConstant.class, callNodeHandle);
        return ((TruffleCompilationTask)task).getPosition(callNode);
    }

    @TruffleFromLibGraal(value=TruffleFromLibGraal.Id.EngineId)
    static long engineId(Object compilable) {
        return ((OptimizedCallTarget)compilable).engineId();
    }

    @TruffleFromLibGraal(value=TruffleFromLibGraal.Id.GetDebugProperties)
    static byte[] getDebugProperties(Object task, long callNodeHandle) {
        JavaConstant callNode = LibGraal.unhand(JavaConstant.class, callNodeHandle);
        Map<String, Object> properties = ((TruffleCompilationTask)task).getDebugProperties(callNode);
        if (properties == null) {
            properties = Collections.emptyMap();
        }
        BinaryOutput.ByteArrayBinaryOutput output = BinaryOutput.create(new byte[128]);
        output.writeInt(properties.size());
        for (Map.Entry<String, Object> e : properties.entrySet()) {
            output.writeUTF(e.getKey());
            Object value = e.getValue();
            if (!BinaryOutput.isTypedValue(value)) {
                value = value.toString();
            }
            output.writeTypedValue(value);
        }
        return output.getArray();
    }

    @TruffleFromLibGraal(value=TruffleFromLibGraal.Id.GetCompilerOptions)
    static byte[] getCompilerOptions(Object o) {
        TruffleCompilable compilable = (TruffleCompilable)o;
        Map<String, String> properties = compilable.getCompilerOptions();
        BinaryOutput.ByteArrayBinaryOutput output = BinaryOutput.create();
        output.writeInt(properties.size());
        for (Map.Entry<String, String> e : properties.entrySet()) {
            output.writeUTF(e.getKey());
            String value = e.getValue();
            output.writeUTF(value);
        }
        return output.getArray();
    }

    @TruffleFromLibGraal(value=TruffleFromLibGraal.Id.PrepareForCompilation)
    static void prepareForCompilation(Object compilable) {
        ((TruffleCompilable)compilable).prepareForCompilation();
    }

    static boolean prepareForCompilation(Object compilable, boolean rootCompilation, int tier, boolean lastTier) {
        return ((TruffleCompilable)compilable).prepareForCompilation(rootCompilation, tier, lastTier);
    }

    static int getSuccessfulCompilationCount(Object compilable) {
        return ((TruffleCompilable)compilable).getSuccessfulCompilationCount();
    }

    @TruffleFromLibGraal(value=TruffleFromLibGraal.Id.GetURI)
    static String getURI(Object position) {
        URI uri = ((TruffleSourceLanguagePosition)position).getURI();
        return uri == null ? null : uri.toString();
    }

    @TruffleFromLibGraal(value=TruffleFromLibGraal.Id.AsJavaConstant)
    static long asJavaConstant(Object compilable) {
        JavaConstant constant = ((TruffleCompilable)compilable).asJavaConstant();
        return LibGraal.translate(constant);
    }

    @TruffleFromLibGraal(value=TruffleFromLibGraal.Id.OnCodeInstallation)
    static void onCodeInstallation(Object truffleRuntime, Object compilable, long installedCodeHandle) {
        InstalledCode installedCode = LibGraal.unhand(InstalledCode.class, installedCodeHandle);
        ((TruffleCompilerRuntime)truffleRuntime).onCodeInstallation((TruffleCompilable)compilable, installedCode);
    }

    @TruffleFromLibGraal(value=TruffleFromLibGraal.Id.GetFailedSpeculationsAddress)
    static long getFailedSpeculationsAddress(Object compilable) {
        OptimizedCallTarget callTarget = (OptimizedCallTarget)compilable;
        HotSpotSpeculationLog log = (HotSpotSpeculationLog)callTarget.getSpeculationLog();
        return LibGraal.getFailedSpeculationsAddress(log);
    }

    @TruffleFromLibGraal(value=TruffleFromLibGraal.Id.CreateStringSupplier)
    static Supplier<String> createStringSupplier(long handle) {
        return new LibGraalStringSupplier(handle);
    }

    @TruffleFromLibGraal(value=TruffleFromLibGraal.Id.GetSuppliedString)
    static String getSuppliedString(Supplier<String> supplier) {
        return supplier.get();
    }

    @TruffleFromLibGraal(value=TruffleFromLibGraal.Id.IsCancelled)
    static boolean isCancelled(Object task) {
        return ((TruffleCompilationTask)task).isCancelled();
    }

    @TruffleFromLibGraal(value=TruffleFromLibGraal.Id.IsLastTier)
    static boolean isLastTier(Object task) {
        return ((TruffleCompilationTask)task).isLastTier();
    }

    @TruffleFromLibGraal(value=TruffleFromLibGraal.Id.HasNextTier)
    static boolean hasNextTier(Object task) {
        return ((TruffleCompilationTask)task).hasNextTier();
    }

    @TruffleFromLibGraal(value=TruffleFromLibGraal.Id.CompilableToString)
    static String compilableToString(Object compilable) {
        return compilable.toString();
    }

    @TruffleFromLibGraal(value=TruffleFromLibGraal.Id.GetCompilableName)
    static String getCompilableName(Object compilable) {
        return ((TruffleCompilable)compilable).getName();
    }

    @TruffleFromLibGraal(value=TruffleFromLibGraal.Id.GetDescription)
    static String getDescription(Object pos) {
        return ((TruffleSourceLanguagePosition)pos).getDescription();
    }

    @TruffleFromLibGraal(value=TruffleFromLibGraal.Id.GetLanguage)
    static String getLanguage(Object pos) {
        return ((TruffleSourceLanguagePosition)pos).getLanguage();
    }

    @TruffleFromLibGraal(value=TruffleFromLibGraal.Id.GetLineNumber)
    static int getLineNumber(Object pos) {
        return ((TruffleSourceLanguagePosition)pos).getLineNumber();
    }

    @TruffleFromLibGraal(value=TruffleFromLibGraal.Id.GetOffsetEnd)
    static int getOffsetEnd(Object pos) {
        return ((TruffleSourceLanguagePosition)pos).getOffsetEnd();
    }

    @TruffleFromLibGraal(value=TruffleFromLibGraal.Id.GetOffsetStart)
    static int getOffsetStart(Object pos) {
        return ((TruffleSourceLanguagePosition)pos).getOffsetStart();
    }

    @TruffleFromLibGraal(value=TruffleFromLibGraal.Id.GetNodeClassName)
    static String getNodeClassName(Object pos) {
        return ((TruffleSourceLanguagePosition)pos).getNodeClassName();
    }

    @TruffleFromLibGraal(value=TruffleFromLibGraal.Id.GetNodeId)
    static int getNodeId(Object pos) {
        return ((TruffleSourceLanguagePosition)pos).getNodeId();
    }

    @TruffleFromLibGraal(value=TruffleFromLibGraal.Id.OnCompilationFailed)
    static void onCompilationFailed(Object compilable, Supplier<String> serializedException, boolean silent, boolean bailout, boolean permanentBailout, boolean graphTooBig) {
        ((TruffleCompilable)compilable).onCompilationFailed(serializedException, silent, bailout, permanentBailout, graphTooBig);
    }

    static void onCompilationSuccess(Object compilable, int compilationTier, boolean lastTier) {
        ((TruffleCompilable)compilable).onCompilationSuccess(compilationTier, lastTier);
    }

    @TruffleFromLibGraal(value=TruffleFromLibGraal.Id.OnSuccess)
    static void onSuccess(Object listener, Object compilable, Object plan, long graphInfoHandle, long compilationResultInfoHandle, int tier) {
        try (LibGraalGraphInfo graphInfo = new LibGraalGraphInfo(graphInfoHandle);
             LibGraalCompilationResultInfo compilationResultInfo = new LibGraalCompilationResultInfo(compilationResultInfoHandle);){
            ((TruffleCompilerListener)listener).onSuccess((TruffleCompilable)compilable, (TruffleCompilationTask)plan, graphInfo, compilationResultInfo, tier);
        }
    }

    @TruffleFromLibGraal(value=TruffleFromLibGraal.Id.OnFailure)
    @Deprecated
    static void onFailure(Object listener, Object compilable, String reason, boolean bailout, boolean permanentBailout, int tier) {
        ((TruffleCompilerListener)listener).onFailure((TruffleCompilable)compilable, reason, bailout, permanentBailout, tier);
    }

    @TruffleFromLibGraal(value=TruffleFromLibGraal.Id.OnFailure)
    static void onFailure(Object listener, Object compilable, String reason, boolean bailout, boolean permanentBailout, int tier, long lazyStackTraceHandle) {
        try (LibGraalScopedStringSupplier serializedException = lazyStackTraceHandle != 0L ? new LibGraalScopedStringSupplier(lazyStackTraceHandle) : null;){
            ((TruffleCompilerListener)listener).onFailure((TruffleCompilable)compilable, reason, bailout, permanentBailout, tier, serializedException);
        }
    }

    @TruffleFromLibGraal(value=TruffleFromLibGraal.Id.OnCompilationRetry)
    static void onCompilationRetry(Object listener, Object compilable, Object task) {
        ((TruffleCompilerListener)listener).onCompilationRetry((TruffleCompilable)compilable, (TruffleCompilationTask)task);
    }

    @TruffleFromLibGraal(value=TruffleFromLibGraal.Id.OnGraalTierFinished)
    static void onGraalTierFinished(Object listener, Object compilable, long graphInfoHandle) {
        try (LibGraalGraphInfo graphInfo = new LibGraalGraphInfo(graphInfoHandle);){
            ((TruffleCompilerListener)listener).onGraalTierFinished((TruffleCompilable)compilable, graphInfo);
        }
    }

    @TruffleFromLibGraal(value=TruffleFromLibGraal.Id.OnTruffleTierFinished)
    static void onTruffleTierFinished(Object listener, Object compilable, Object plan, long graphInfoHandle) {
        try (LibGraalGraphInfo graphInfo = new LibGraalGraphInfo(graphInfoHandle);){
            ((TruffleCompilerListener)listener).onTruffleTierFinished((TruffleCompilable)compilable, (TruffleCompilationTask)plan, graphInfo);
        }
    }

    @TruffleFromLibGraal(value=TruffleFromLibGraal.Id.CancelCompilation)
    static boolean cancelCompilation(Object compilableTruffleAST, String reason) {
        return ((TruffleCompilable)compilableTruffleAST).cancelCompilation(reason);
    }

    @TruffleFromLibGraal(value=TruffleFromLibGraal.Id.GetCompilableCallCount)
    static int getCompilableCallCount(Object compilableTruffleAST) {
        return ((TruffleCompilable)compilableTruffleAST).getCallCount();
    }

    @TruffleFromLibGraal(value=TruffleFromLibGraal.Id.GetKnownCallSiteCount)
    static int getKnownCallSiteCount(Object compilableTruffleAST) {
        return ((TruffleCompilable)compilableTruffleAST).getKnownCallSiteCount();
    }

    @TruffleFromLibGraal(value=TruffleFromLibGraal.Id.IsSameOrSplit)
    static boolean isSameOrSplit(Object compilableTruffleAST1, Object compilableTruffleAST2) {
        return ((TruffleCompilable)compilableTruffleAST1).isSameOrSplit((TruffleCompilable)compilableTruffleAST2);
    }

    @TruffleFromLibGraal(value=TruffleFromLibGraal.Id.IsTrivial)
    static boolean isTrivial(Object compilableTruffleAST1) {
        return ((TruffleCompilable)compilableTruffleAST1).isTrivial();
    }

    @TruffleFromLibGraal(value=TruffleFromLibGraal.Id.GetNonTrivialNodeCount)
    static int getNonTrivialNodeCount(Object compilableTruffleAST) {
        return ((TruffleCompilable)compilableTruffleAST).getNonTrivialNodeCount();
    }

    @TruffleFromLibGraal(value=TruffleFromLibGraal.Id.CountDirectCallNodes)
    static int countDirectCallNodes(Object compilableTruffleAST) {
        return ((TruffleCompilable)compilableTruffleAST).countDirectCallNodes();
    }

    @TruffleFromLibGraal(value=TruffleFromLibGraal.Id.AddTargetToDequeue)
    static void addTargetToDequeue(Object task, Object compilableTruffleAST) {
        ((TruffleCompilationTask)task).addTargetToDequeue((TruffleCompilable)compilableTruffleAST);
    }

    @TruffleFromLibGraal(value=TruffleFromLibGraal.Id.SetCallCounts)
    static void setCallCounts(Object task, int total, int inlined) {
        ((TruffleCompilationTask)task).setCallCounts(total, inlined);
    }

    @TruffleFromLibGraal(value=TruffleFromLibGraal.Id.AddInlinedTarget)
    static void addInlinedTarget(Object task, Object target) {
        ((TruffleCompilationTask)task).addInlinedTarget((TruffleCompilable)target);
    }

    @TruffleFromLibGraal(value=TruffleFromLibGraal.Id.GetPartialEvaluationMethodInfo)
    static Object getPartialEvaluationMethodInfo(Object truffleRuntime, long methodHandle) {
        ResolvedJavaMethod method = LibGraal.unhand(ResolvedJavaMethod.class, methodHandle);
        PartialEvaluationMethodInfo info = ((TruffleCompilerRuntime)truffleRuntime).getPartialEvaluationMethodInfo(method);
        BinaryOutput.ByteArrayBinaryOutput out = BinaryOutput.create(new byte[5]);
        out.writeByte(info.loopExplosion().ordinal());
        out.writeByte(info.inlineForPartialEvaluation().ordinal());
        out.writeByte(info.inlineForTruffleBoundary().ordinal());
        out.writeBoolean(info.isInlineable());
        out.writeBoolean(info.isSpecializationMethod());
        return out.getArray();
    }

    @Deprecated
    static Object getHostMethodInfo(Object truffleRuntime, long methodHandle) {
        ResolvedJavaMethod method = LibGraal.unhand(ResolvedJavaMethod.class, methodHandle);
        HostMethodInfo info = ((TruffleCompilerRuntime)truffleRuntime).getHostMethodInfo(method);
        BinaryOutput.ByteArrayBinaryOutput out = BinaryOutput.create(new byte[4]);
        out.writeBoolean(info.isTruffleBoundary());
        out.writeBoolean(info.isBytecodeInterpreterSwitch());
        out.writeBoolean(info.isBytecodeInterpreterSwitchBoundary());
        out.writeBoolean(info.isInliningCutoff());
        return out.getArray();
    }

    static boolean checkHotSpotCalls() {
        EnumSet<TruffleFromLibGraal.Id> unimplemented = EnumSet.allOf(TruffleFromLibGraal.Id.class);
        Map<String, TruffleFromLibGraal.Id> entryPointMethodNames = unimplemented.stream().collect(Collectors.toMap(TruffleFromLibGraal.Id::getMethodName, id -> id));
        LinkedHashMap<TruffleFromLibGraal.Id, List> idToMethod = new LinkedHashMap<TruffleFromLibGraal.Id, List>();
        for (Method method : TruffleFromLibGraalEntryPoints.class.getDeclaredMethods()) {
            TruffleFromLibGraal.Id id2;
            List methods;
            if (!Modifier.isStatic(method.getModifiers())) continue;
            TruffleFromLibGraal a = method.getAnnotation(TruffleFromLibGraal.class);
            if (a != null) {
                TruffleFromLibGraal.Id id22 = a.value();
                methods = idToMethod.computeIfAbsent(id22, k -> new ArrayList());
                methods.add(method);
                continue;
            }
            if (method.getAnnotation(Deprecated.class) == null || (id2 = entryPointMethodNames.get(method.getName())) == null) continue;
            methods = idToMethod.computeIfAbsent(id2, k -> new ArrayList());
            methods.add(method);
        }
        for (Map.Entry entry : idToMethod.entrySet()) {
            TruffleFromLibGraal.Id id3 = (TruffleFromLibGraal.Id)entry.getKey();
            List methods = (List)entry.getValue();
            int legacyMethodCount = 0;
            for (Method method : methods) {
                TruffleFromLibGraalEntryPoints.check(id3, id3.getMethodName().equals(method.getName()), "Expected name \"%s\", got \"%s\"", id3.getMethodName(), method.getName());
                if (method.getAnnotation(Deprecated.class) != null && method.getAnnotation(TruffleFromLibGraal.class) != null) {
                    ++legacyMethodCount;
                }
                if (!Arrays.equals(id3.getParameterTypes(), method.getParameterTypes())) continue;
                unimplemented.remove(id3);
                TruffleFromLibGraalEntryPoints.check(id3, id3.getReturnType().equals(method.getReturnType()), "Expected return type %s, got %s", id3.getReturnType().getName(), method.getReturnType().getName());
                TruffleFromLibGraalEntryPoints.checkParameters(id3, method.getParameterTypes());
            }
            TruffleFromLibGraalEntryPoints.check(id3, legacyMethodCount == methods.size() - 1, "Entry points with multiple versions must mark all legacy versions with the @Deprecated annotation.", new Object[0]);
        }
        TruffleFromLibGraalEntryPoints.check(null, unimplemented.isEmpty(), "Missing implementations:%n%s", unimplemented.stream().map(TruffleFromLibGraalEntryPoints::missingImpl).sorted().collect(Collectors.joining(System.lineSeparator())));
        return true;
    }

    private static void checkParameters(TruffleFromLibGraal.Id id, Class<?>[] types) {
        Class<?>[] idTypes = id.getParameterTypes();
        TruffleFromLibGraalEntryPoints.check(id, idTypes.length == types.length, "Expected %d parameters, got %d", idTypes.length, types.length);
        for (int i = 0; i < types.length; ++i) {
            TruffleFromLibGraalEntryPoints.check(id, idTypes[i].equals(types[i]), "Parameter %d has wrong type, expected %s, got %s", i, idTypes[i].getName(), types[i].getName());
        }
    }

    private static String missingImpl(TruffleFromLibGraal.Id id) {
        Formatter buf = new Formatter();
        buf.format("    @%s(%s)%n", TruffleFromLibGraal.class.getSimpleName(), id.name());
        buf.format("    static %s %s(%s) {%n    }%n", id.getReturnType().getSimpleName(), id.getMethodName(), Stream.of(id.getParameterTypes()).map(c -> c.getSimpleName()).collect(Collectors.joining(", ")));
        return buf.toString();
    }

    private static void check(TruffleFromLibGraal.Id id, boolean condition, String format, Object ... args) {
        if (!condition) {
            String msg = String.format(format, args);
            String target = id != null ? String.format("%s.%s", TruffleFromLibGraalEntryPoints.class.getName(), id) : TruffleFromLibGraalEntryPoints.class.getName();
            throw new AssertionError((Object)String.format("Incompatible Truffle runtime change: %s: %s", target, msg));
        }
    }
}

